// Light.cpp: implementation of the CLight class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CryViewer.h"
#include "Light.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#pragma warning( disable : 4244)

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CLight::CLight()
{
	memset(&chunk,0,sizeof(chunk));
	LightPen=CreatePen(PS_SOLID,0,RGB(255,255,0));
	LightBrush=NULL;
}

CLight::~CLight()
{
	DeleteObject(LightPen);
	DeleteObject(LightBrush);
}

RECT CLight::Paint(HDC hdc, DispOptions &opt)
{
	const int radius=5;
	CryPoint3 p=CryPoint3(0,0,0);
	CryPoint3 pp=p*opt.tm;

	HGDIOBJ  old_pen=SelectObject(hdc,LightPen);
	HGDIOBJ  old_brh=SelectObject(hdc,LightBrush);
	Ellipse(hdc,pp.x-radius,pp.y-radius,pp.x+radius,pp.y+radius);

	if(chunk.type == LT_SPOT || chunk.type == LT_DIRECT)
	{
		CryPoint3 p2=CryPoint3(0,0,-1);
		CryPoint3 pp2=p2*opt.tm;
		CryPoint3 d= pp2-pp;
		float len=sqrt(d.x*d.x+d.y*d.y+d.z*d.z);
		float k=4*radius/len;
		pp2.x=pp.x + k*d.x;
		pp2.y=pp.y + k*d.y;

		MoveToEx(hdc,pp.x,pp.y,NULL);
		LineTo(hdc,pp2.x,pp2.y);
	}
	SelectObject(hdc,old_pen);
	SelectObject(hdc,old_brh);

	CRect r;
	r.top=r.bottom=pp.y;
	r.left=r.right=pp.x;
	r.top-=radius;
	r.bottom+=radius;
	r.left-=radius;
	r.right+=radius;

	return r;
}

bool CLight::Load(FILE *f, long pos)
{
	if(fseek(f,pos,SEEK_SET)) return true;

	int res=fread(&chunk,sizeof(chunk),1,f);
	if(res!=1) return true;
	
	if(chunk.chdr.ChunkType != ChunkType_Light || chunk.chdr.ChunkVersion != LIGHT_CHUNK_DESC_VERSION)
	{
		memset(&chunk,0,sizeof(chunk));
		return true;
	}

	hdr=chunk.chdr;
	
	LOGBRUSH lb={BS_SOLID,RGB(chunk.color.r,chunk.color.g,chunk.color.b), 0};
	LightBrush=CreateBrushIndirect(&lb);
	
	return false;
}
