// Node.cpp: implementation of the CNode class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CryViewer.h"
#include "Node.h"
#include "Geom.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CNode::CNode() : BaseObj()
{
	obj			= NULL;
	propstr		= NULL;
	children	= NULL;
	children_ids= NULL;
	Parent		= NULL;
	mtl			= NULL;
	crot		= NULL;
	cpos		= NULL;
	cscl		= NULL;
	memset(&chunk,0,sizeof(chunk));
}

CNode::~CNode()
{
	if(children)		free(children);
	if(children_ids)	free(children_ids);
	if(propstr)			free(propstr);
}

bool CNode::Load(FILE *f, long pos)
{
	if(fseek(f,pos,SEEK_SET)) return true;

	int res=fread(&chunk,sizeof(chunk),1,f);
	if(res!=1) return true;
	
	if(chunk.chdr.ChunkType != ChunkType_Node || chunk.chdr.ChunkVersion != NODE_CHUNK_DESC_VERSION)
	{
		memset(&chunk,0,sizeof(chunk));
		return true;
	}

	hdr=chunk.chdr;
	tm = chunk.tm;

	//read propstr
	if(chunk.PropStrLen)
	{
		propstr=(char*)calloc(chunk.PropStrLen+1,1);
		assert(propstr);
		res=fread(propstr,chunk.PropStrLen,1,f);
		if(res!=1) return true;
	}

	//read children
	if(chunk.nChildren)
	{
		children_ids = (int*) calloc(chunk.nChildren,sizeof(int));
		assert(children_ids);
		children = (CNode **) calloc(chunk.nChildren,sizeof(CNode*));
		assert(children_ids);
		
		int res=fread(children_ids,sizeof(int),chunk.nChildren,f);
		if(res!=chunk.nChildren) return true;
	}

	return false;
}

void CNode::Bind(BaseObj **all_objects, int n_obj)
{
	if(binded) return;

	for(int i=0;i<n_obj;i++)
	{
		BaseObj *o=all_objects[i];
		if(!o) continue;
		if(o->hdr.ChunkID == -1) continue;

		if(o->hdr.ChunkID == chunk.ParentID)	Parent=(CNode *)o;
		if(o->hdr.ChunkID == chunk.ObjectID)	obj=o;
		if(o->hdr.ChunkID == chunk.MatID)		mtl=o;
		if(o->hdr.ChunkID == chunk.pos_cont_id) cpos=(Controller *)o;
		if(o->hdr.ChunkID == chunk.rot_cont_id) crot=(Controller *)o;
		if(o->hdr.ChunkID == chunk.scl_cont_id) cscl=(Controller *)o;

		for(int j=0;j<chunk.nChildren;j++)
		{
			if(o->hdr.ChunkID == children_ids[j]) children[j]=(CNode *)o;
		}
	}

	binded = true;
}

RECT CNode::Paint(HDC hdc, DispOptions &opt)
{
	CRect rec;
	rec.SetRectEmpty();

	//update the TM so that it includes nodes transform as well as view TM
	DispOptions newopt=opt;
	newopt.tm.Multiply(opt.tm, tm);

	if(obj)
	{
		rec=obj->Paint(hdc,newopt);
	}

	for(int i=0;i<chunk.nChildren;i++)
	{
		if(children[i])
		{
			CRect cr=children[i]->Paint(hdc,newopt);
			rec.UnionRect(rec,cr);
		}
	}

	return rec;
}

void CNode::Pose(int time)
{
	CryPoint3 pos=chunk.pos;
	CryQuat   rot=chunk.rot;
	CryPoint3 scl=chunk.scl;

	if(cpos) cpos->GetValue(time, pos);
	if(crot) crot->GetValue(time, rot);
	if(cscl) cscl->GetValue(time, scl);

	tm.Build(rot,pos,scl);
}