// CryWaterMark, simple watermarking of executables
// Wouter, 8 april 2003
// [Timur] Modified to additionally crc stamp crysystem.dll (crc of FarCry.exe)
//
// usage: first add watermark data to an exe, see CryWaterMark.h on how to do this.
// then call this program, with as first argument the name of the exe to process,
// and as second argument the key to set (any string, though only the first 40
// characters are used). If the second argument is ommitted, only information
// about currently existing watermarks is displayed. 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "CryWaterMark.h"

WATERMARKDATA(_m);

const char CodeWatermarkString[] = "Cannot find attached entity.\0....";

#define AUTODIN_IIREV	0xEDB88320
static unsigned int CRC_32( const char *buf,unsigned int len )
{
	static unsigned int Table[256];
	static int init = 0;
	unsigned int code = 0xFFFFFFFF;  

	if (!init) {
		int i;
		init = 1;
		for (i = 0; i <= 255; i++) {
			int j;
			unsigned int part = i;
			for (j = 0; j < 8; j++) {
				if (part & 1)
					part = (part >> 1) ^ AUTODIN_IIREV;
				else
					part >>= 1;
			}
			Table[i] = part;
		}
	}
	while (len--)
	{
		unsigned int temp1 = code >> 8;
		unsigned int temp2 = Table[(code ^ (unsigned int )*buf) & 0xff];
		code = temp1 ^ temp2;
		buf += 1;
	}
	return code;
}


void Exit(char *msg, char *arg="")
{
	//printf("%s%s\n[ press return to close ]\n", msg, arg);
	//getchar();
	//exit(1);
};

char *LoadFile(char *fn, int &len)
{
	FILE *f = fopen(fn, "rb");
	if(!f) return NULL;
	fseek(f, 0, SEEK_END);
	len = ftell(f);
	fseek(f, 0, SEEK_SET);
	char *buf = (char *)malloc(len+1);
	if(!buf) return NULL;
	buf[len] = 0;
	size_t rlen = fread(buf, 1, len, f);
	fclose(f);
	if(len!=rlen || len<=0) { free(buf); return NULL; };
	return buf;
};

void endecode(int *p)
{
	for(int i = 0; i<NUMMARKWORDS; i++) p[i] ^= -1;
};

unsigned int GetFileCode( char *sFilename )
{
	int len = 0;
	char *pBuffer = LoadFile( sFilename,len );

	unsigned int nCode = CRC_32( pBuffer,len );

	if (pBuffer)
		free(pBuffer);

	// return invert of code.
	return nCode;
}

int main(int argc, char *argv[])
{
	printf("CryWaterMark 0.1\n");
	if(argc<2 || argc>3) Exit("usage: CryWaterMark <exefile> [ <keyname> ]");
	
	char *exename = argv[1];
	char *key = argc==3 ? argv[2] : "";
	
	int len = 0;
	char *buf = LoadFile(exename, len);
	if(!buf) Exit("cannot load exe file: ", exename);
	
	printf("\n");
	int mods = 0, numkeys = 0;
	
	for(int *p = (int *)buf; (char *)p<=buf+len-sizeof(_m); p++)
	{
		if(p[0]==_m[0] && p[1]==_m[1] && p[2]==_m[2]) 
		{
			printf("watermark at offset %d ", (char *)p-buf);
			numkeys++;
			
			if(!p[3]) printf("(uninitialised)");
			else
			{
				endecode(&p[3]);
				printf("(current value %s)", &p[3]); 
			};
			
			if(!*key) printf(": no action taken\n");
			else
			{
				printf(": set to key %s\n", key);
				strncpy((char *)&p[3], key, sizeof(int)*NUMMARKWORDS);
				p[NUMMARKWORDS+2] = 0;
				endecode(&p[3]);
				mods++;
			};
		};
	};

	
	printf("\nfound %d keys, modified %d keys\n", numkeys, mods);


  /*
	//////////////////////////////////////////////////////////////////////////
	// Stamp invert of crc32 code of FarCry.exe to file.
	//////////////////////////////////////////////////////////////////////////
	unsigned int nFarCryCode;
	{
		char path_buffer[_MAX_PATH];
		char drive[_MAX_DRIVE];
		char dir[_MAX_DIR];
		char fname[_MAX_FNAME];
		char ext[_MAX_EXT];
		_splitpath( exename,drive,dir,fname,ext );
		_makepath( path_buffer,drive,dir,"FarCry","exe" );
		nFarCryCode = GetFileCode( path_buffer );
	}
	int nStrLen = (int)strlen(CodeWatermarkString) + 1;
	for (int i = 0; i < len-nStrLen-32; i++)
	{
		if (memcmp(buf+i,CodeWatermarkString,nStrLen) == 0)
		{
			// Found!, Write code there.
			unsigned int nInvertCrc32 = ~nFarCryCode;
			memcpy( buf+i+nStrLen,&nInvertCrc32,sizeof(nInvertCrc32) );
			printf("\nFarCry.exe CRC32=%X\n",nFarCryCode );
			printf("FarCry.exe InvertCRC32=%X written into %s\n",nInvertCrc32,exename );
			mods++;
			break;
		}
	}
  */

	
	if(mods)
	{
		printf("writing modified exe to disk...\n");
		FILE *f = fopen(exename, "wb");
		if(!f) Exit("cannot write exe: ", exename);
		fwrite(buf, len, 1, f);
		fclose(f);
	};
	
	Exit("succesfully processed exe");
	return 0;
}

WATERMARKDATA(_n);
WATERMARKDATA(_o);



