// CryXML.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "ICryXML.h"
#include "XMLSerializer.h"

//int sEmptyStringBuffer[] = { -1, 0, 0, 0 };
//string::StrHeader* string::m_emptyStringData = (string::StrHeader*)&sEmptyStringBuffer;
//wstring::StrHeader* wstring::m_emptyStringData = (wstring::StrHeader*)&sEmptyStringBuffer;

class CryXML : public ICryXML
{
public:
	CryXML();
	virtual void AddRef();
	virtual void Release();
	virtual IXMLSerializer* GetXMLSerializer();

private:
	int nRefCount;
	XMLSerializer serializer;
};

static CryXML* s_pCryXML = 0;

BOOL APIENTRY DllMain(HANDLE hModule, DWORD ul_reason_for_call, LPVOID lpReserved)
{
	return TRUE;
}

ICryXML* __stdcall GetICryXML()
{
	if (s_pCryXML == 0)
		s_pCryXML = new CryXML;
	return s_pCryXML;
}

CryXML::CryXML()
:	nRefCount(0)
{
}

void CryXML::AddRef()
{
	++this->nRefCount;
}

void CryXML::Release()
{
	--this->nRefCount;
	if (this->nRefCount == 0)
		delete this;
}

IXMLSerializer* CryXML::GetXMLSerializer()
{
	return &this->serializer;
}

void* CryModuleMalloc(size_t size) {return malloc(size);}
//size_t CryModuleFree(void *ptr) { size_t ret=_msize(ptr); free(ptr); return ret; }
void CryModuleFree(void *ptr) { size_t ret=_msize(ptr); free(ptr); }
void* CryModuleRealloc(void *memblock,size_t size) {return realloc(memblock, size);}
