#ifndef IJOBSERVER_H
#define IJOBSERVER_H

#if _MSC_VER > 1000
#	pragma once
#endif

#ifdef JOBSERVER_IMPORT
	#define JOBSERVER_API
#else
	#define JOBSERVER_API __declspec(dllexport)
#endif


#define IJOBSERVERVERSION 1																								// To clearly indetify any differences between the client and the job servers

enum JobServerPlatform
{
	JSP_WINDOWS,																														// Native Windows platform
	JPS_LINUX,																															// Currenty Linux means WINE on linux - different path because of the mounting..
};

enum JobServerResult
{
	JSRESULT_OK,																														// Everything is ok, but not finished
	JSRESULT_INTERNAL_ERROR,																								// Internal error -> the system have a problem, the datas looks like ok.
	JSRESULT_DATA_ERROR,																										// Data error -> needed to report as "success" because it will stall the whole workflow
	JSRESULT_FINISHED																												// The jobs are finished
};

struct SJobServerInfo
{
	bool									m_bExclusiveMode;									//is needed to run alone - no other servers can run at all.
	int										m_nMaxThread;											//the max number
//	int										m_nMinMemoryPerThread;						//the neccessary (estimated) memory needed for the thread
};

struct IJobServer
{
	typedef IJobServer *(*TCreateFunction)( int nThreadID, JobServerPlatform ePlatform, const int nIJobServerVersion );									//The create function
	typedef void	(*TDeleteFunction)( IJobServer* pJobServer );																						//The delete function
	typedef void	(*TGetInfoFunction) (	SJobServerInfo* pInfo );																					//The ServerJobInfo function

	virtual JobServerResult Init( const char* sJob,const char *sWorkPath ) = 0;														//Init the jobserver
	virtual JobServerResult Tick() = 0;																																		//One "Tick" of the jobserver
	virtual JobServerResult Done() = 0;																																		//Done the jobserver

	//Get infos
	virtual int							GetUsedMemoryMB() = 0;																												//Give back the used/predicted memory size in MB
	virtual int							GetPercent() = 0;																															//Give back the percent of the finished work
};

#endif//IJOBSERVER_H