/*****************************************************************************
 ** osr_service.h - osr service
 **
 ** Copyright (C) 2002 Rodrigo OSORIO. All rights reserved.
 **
 ** Redistribution and use in source and binary forms, with
 ** or  without  modification, are permitted  provided that 
 ** the following conditions are met:
 **
 ** 1. Redistributions of source code must retain the above 
 **    copyright notice, this  list of  conditions  and the 
 **    following disclaimer. 
 **    
 ** 2. Redistributions in binary  form  must reproduce  the
 **    above copyright  notice, this list of conditions and
 **    the following disclaimer in the documentation and/or
 **    other materials provided with the distribution. 
 **
 ** 3. Neither the name of this application nor the names of
 **    its  contributors may be used to  endorse or  promote 
 **    products derived from this software without  specific
 **    prior written permission. 
 **
 ** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 ** CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 ** INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 ** MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 ** DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 ** CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 ** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 ** NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 ** LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 ** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 ** CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 ** OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 ** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *****************************************************************************/

#ifndef OSR_SERVICE_H
#define OSR_SERVICE_H

#include "osr_types.h"
#include <winsvc.h>

#define OSR_SERVICE_DONE  0
#define OSR_SERVICE_WAIT  1
#define OSR_SERVICE_ERROR 2


typedef struct _OSR_SERVICE_PARAMS
{
	UCHAR  ServiceName[STR_CHAR32];
	UCHAR  ServiceNameDisplay[STR_CHAR32];
	UCHAR  ServiceDependencies[STR_CHAR64];

	U32BIT ServiceDesiredAccess;
	U32BIT ServiceStartType;

	UCHAR  ServiceLogin[STR_CHAR32];
	UCHAR  ServicePassword[STR_CHAR32];
	U32BIT ServiceAcceptedCommands;

}OSR_SERVICE_PARAMS;

// User functions called to Install and uninstall the service
OSR_ERROR OSR_CALL ServiceInstall(OSR_SERVICE_PARAMS * Params);
OSR_ERROR OSR_CALL ServiceUninstall(OSR_SERVICE_PARAMS * Params);

// Check if the service is installed
OSR_ERROR OSR_CALL ServiceIsInstalled(UCHAR * ServiceName);

int OSR_CALL OSR_APP_START(int step);
int OSR_CALL OSR_APP_STOP(int step);
int OSR_CALL OSR_APP_PAUSE(int step);
int OSR_CALL OSR_APP_CONTINUE(int step);
int OSR_CALL OSR_APP_SHUTDOWN(int step);


OSR_ERROR OSR_CALL ServiceStart(OSR_SERVICE_PARAMS * Params);

#endif