/*****************************************************************************
 ** osr_service_internals.h - osr service internals
 **
 ** Copyright (C) 2002 Rodrigo OSORIO. All rights reserved.
 **
 ** Redistribution and use in source and binary forms, with
 ** or  without  modification, are permitted  provided that 
 ** the following conditions are met:
 **
 ** 1. Redistributions of source code must retain the above 
 **    copyright notice, this  list of  conditions  and the 
 **    following disclaimer. 
 **    
 ** 2. Redistributions in binary  form  must reproduce  the
 **    above copyright  notice, this list of conditions and
 **    the following disclaimer in the documentation and/or
 **    other materials provided with the distribution. 
 **
 ** 3. Neither the name of this application nor the names of
 **    its  contributors may be used to  endorse or  promote 
 **    products derived from this software without  specific
 **    prior written permission. 
 **
 ** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 ** CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 ** INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 ** MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 ** DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 ** CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 ** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 ** NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 ** LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 ** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 ** CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 ** OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 ** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *****************************************************************************/

#ifndef OSR_SERVICE_INTERNALS_H
#define OSR_SERVICE_INTERNALS_H

#include "osr_types.h"
#include "osr_service.h"

#define OSR_SERVICE_WAIT_HINT        1000
OSR_VAR_GLOBAL SERVICE_STATUS        OsrServiceStatus;
OSR_VAR_GLOBAL SERVICE_STATUS_HANDLE OsrServiceStatusHandle;
OSR_VAR_GLOBAL U32BIT                OsrServiceAcceptCommands;

OSR_ERROR OSR_CALL ServiceReportStatus(DWORD ServiceCurrentState);
OSR_ERROR OSR_CALL OnServiceStart();
OSR_ERROR OSR_CALL OnServiceStop();
OSR_ERROR OSR_CALL OnServicePause();
OSR_ERROR OSR_CALL OnServiceContinue();
OSR_ERROR OSR_CALL OnServiceShutDown();
DWORD WINAPI OsrStartServiceDiapatcher(LPVOID lpParameter);
 
VOID WINAPI OsrServiceMainFunction(DWORD dwArgc,LPTSTR *lpszArgv);


#endif