// (c) 2000 by Zachary Booth Simpson
// This code may be freely used, modified, and distributed without any license
// as long as the original author is noted in the source file and all
// changes are made clear disclaimer using a "MODIFIED VERSION" disclaimer.
// There is NO warranty and the original author may not be held liable for any damages.
// http://www.totempole.net

/*
********************************** MODIFIED VERSION *************************************
Modification History:
	01.03.2006 - Tamas Schlagl: Made it confortable with VC2005
															Add normal error checks
															Distinguis between the client want a message & it isn't have a message
  10.03.2006 - Tamas Schlagl: Login detect the client version
															Crash fix, when a client form an old server think he is logged in to that server.

															Priority is added.
															GLOBALJOBID is needed
********************************** MODIFIED VERSION *************************************
*/

#include "stdafx.h"


#ifdef _DEBUG

#ifndef ASSERT
	#define ASSERT(exp) do { if ( ! (exp) ) { dprintf("ASSERT: %s(%d) : %s\n",__FILE__,__LINE__,#exp); __asm {int 3}; } } while(0)
#endif
#else

#ifndef ASSERT
	#define ASSERT(exp)	do { if ( ! (exp) ) dprintf("ASSERT: %s(%d) : %s\n",__FILE__,__LINE__,#exp); } while(0)
#endif

#endif

/*
#ifdef _DEBUG
#define ASSERT(exp) do { if ( ! (exp) ) { dprintf("ASSERT: %s(%d) : %s\n",__FILE__,__LINE__,#exp); __asm {int 3}; } } while(0)
#else
#define ASSERT(exp)	do { if ( ! (exp) ) dprintf("ASSERT: %s(%d) : %s\n",__FILE__,__LINE__,#exp); } while(0)
#endif
*/

#define BLOCK	1

/*

a machine can be a client and a server

clients log in to the server, server keeps a list of clients

Login :
	client sends msgLogin
	server replies with msgLoginConfirm

Server send to client:
	
	msgCommand
	msgGetStatus

Client sends to server :
	msgStatus
	msgCommandComplete

*/

#include "zocket.h"
#include "msgzocket.h"
#include "hashtable.h"
#include "net.h"

#define MAX_SERVER_WAIT_FOR_CLIENT	(3.0)
#define MAX_CLIENT_WAIT_TO_LOGIN	(5.0)

#define CLIENT_VERSION					18

const float c_statusRequestInterval = 1.0;
const float c_statusWaitKillDuration = 10.0;

int	nClientGUID;

ServerStatus g_serverStatus;
bool g_bServerStatusReceived = false;

#ifdef _DEBUG
	void	dprintf(const char* fmt, ...)
	{
		va_list			ArgPtr;
		char			TempStr[1024];

		va_start(ArgPtr, fmt);
		_vsnprintf_s(TempStr, 1024, fmt, ArgPtr);
		va_end(ArgPtr);

	//	OutputDebugString(TempStr);
		printf("debug: ");
		printf(TempStr);
	}
#else
	#define dprintf
#endif

extern void Log( const char* szFormat,... );

bool checkZocket(Zocket * z)
{
	if(NULL == z)
		return false;
	ZocketError err = z->getZocketError();
	if ( err == zeNO_ERROR )
	{
		return (z->isOpen()) && (z->getSockFD() != INVALID_SOCKET);
	}
	else
	{
		dprintf("zock error: %d\n",err);
		return false;
	}
}

double GetTime( void )
{
    static __int64 Frequency;
    static __int64 StartTime;
    static int Init = 1;
    __int64 Timer;

    if(Init)
    {
        QueryPerformanceFrequency((LARGE_INTEGER*)&Frequency);
        QueryPerformanceCounter((LARGE_INTEGER*)&StartTime);
        Init = 0;
        return 0.0;
    }
    else
    {
        QueryPerformanceCounter((LARGE_INTEGER*)&Timer);
        return ((double)(Timer-StartTime)/(double)(Frequency));
    }
}

// Client Lists, used by server
//-----------------------------

#define MAX_CLIENTS	(256)

struct Client 
{
	SimpleMsgZocket *	zocket; // zocket to send to client
	int               version; // client version
	FixedString			name;
	double				lastStatusTime; // I sent a GetStatus and I'm waiting for a reply
	bool				isLoggedIn;
	FixedString			command;
	bool				busy;
	bool				unusable;
	bool        updated;
	int					GUID;
	
//	int					lastCommandSent;
	double				lastCommandTime;
	double        lastUnusableTime;

	bool loggedIn() { return (zocket != NULL) && isLoggedIn; }

	void Terminate()
	{
		zocket = NULL;
		isLoggedIn = false;
		busy = false;
		unusable = false;
		updated = false;
		name.str[0] = 0;
//		lastCommandSent = -1;
		lastStatusTime = - 1000.0;
		lastCommandTime = - 1000.0;
		lastUnusableTime = - 1000.0;
		GUID = -1;
		command.str[0] = 0;
	}

	Client() : lastStatusTime(0.0), zocket(NULL), isLoggedIn(false), busy(false), unusable(false)/*, lastCommandSent(-1)*/
	{
		command.str[0] = 0;
		name.str[0] = 0;
		GUID = -1;
	}
};

Client clients[MAX_CLIENTS];

// Server Zocket, used by client
//-----------------------------

std::vector<FixedString>	clientCommands;
bool											bDefaultClientBusy = false;
std::vector<CommandInfo>	serverSentCommands;

SimpleMsgZocket *serverZocket = NULL; // zocket to send to server

SimpleMsgZocket *listeningZocket = NULL;
	// This is the listening zocket used
	// only by the server.

//======================================================

bool client = false;
	// Am I a client

bool server = false;
	// Am I a server

bool clientIsLoggedIn = false;
	// client is logged in

bool clientIsConnected = false;

//======================================================

// Messages
//======================================================

enum Msgs 
{
	msgLogin = 1,
	msgLoginConfirm,
	msgCommand,
	msgCommandComplete,
	msgGetStatus,
	msgStatus,
	msgServerStatus, // Send from server to clients at regular intervals.
};

struct MsgLogin : public SimpleMsg 
{
	FixedString	name;
	unsigned int	client_version;
	MsgLogin() { type = msgLogin; len = sizeof(*this); }
};

struct MsgLoginConfirm : public SimpleMsg 
{
	MsgLoginConfirm() { type = msgLoginConfirm; len = sizeof(*this); }
};
	
struct MsgCommand : public SimpleMsg 
{
	FixedString command;
	MsgCommand() { type = msgCommand; len = sizeof(*this); }
};

struct MsgCommandComplete : public SimpleMsg 
{
	FixedString command;
	bool		success;
	MsgCommandComplete() { type = msgCommandComplete; len = sizeof(*this); }
};

struct MsgGetStatus : public SimpleMsg 
{
	MsgGetStatus() { type = msgGetStatus; len = sizeof(*this); }
};

struct MsgStatus : public SimpleMsg 
{
	FixedString command;
	bool		busy;
	MsgStatus() { type = msgStatus; len = sizeof(*this); }
};

struct MsgServerStatus : public SimpleMsg 
{
	int nJobsLeft;
	int nClients;
	int nFreeClients;
	int reserved[16];

	MsgServerStatus() { type = msgServerStatus; len = sizeof(*this); }
};

//////////////////////////////////////////////////////////////////////////
bool Client_IsConnected()
{
	return clientIsConnected;
}

//////////////////////////////////////////////////////////////////////////
bool Client_IsLoggedIn()
{
	return clientIsLoggedIn;
};

void Client_RequestCommand(const char * command, int nPriority )
{
	ASSERT(client);
	//ASSERT(serverZocket);
	if ( ! serverZocket ) return;

	MsgCommand msg;
	msg.command.set(command,0,nPriority);
	serverZocket->write( &msg , BLOCK);
}

void Client_SendStatusToServer(const char * command,bool busy)
{
	ASSERT(client);
	//ASSERT(serverZocket);
	if ( ! serverZocket ) return;

	MsgStatus msg;
	msg.command.set(command,0,0);
	msg.busy = busy;
	serverZocket->write( &msg , BLOCK);
}

void Client_SendStatusToServer()
{
	// don't use "clientIsBusy"
	//	send the next command we'll do, if any
/*	if ( ! clientCommands.empty() )
	{
		Client_SendStatusToServer(clientCommands[0].str,true);
	}
	else
	{*/
	dprintf("Status: %s", bDefaultClientBusy ? "Busy" : "Free" );
		Client_SendStatusToServer("",bDefaultClientBusy);
/*	}*/
}

bool Client_GetCommand( FixedString * pInto )
{
	if ( clientCommands.empty() || NULL == pInto )
		return false;

	//get the last
/*	if( false == clientCommands[clientCommands.size()-1].bNew )
		return false;

	strcpy_s(pInto, nBufferSize,clientCommands[clientCommands.size()-1].str);
	clientCommands[clientCommands.size()-1].bNew = false;*/
//	Client_SendStatusToServer();

	//find the first new command
	for( unsigned int i = 0; i < clientCommands.size(); ++i )
		if( clientCommands[i].bNew )
		{
			clientCommands[i].bNew = false;
			memcpy( pInto, &clientCommands[i], sizeof(FixedString) );
			return true;
		}
		return false;
}

bool Server_GetRemoteCommandRequest( FixedString* pCommand )
{
	if ( clientCommands.empty() || NULL == pCommand )
		return false;

	pCommand->set( &clientCommands[0] );
	clientCommands.erase(clientCommands.begin());
	return true;
}

void Client_CommandComplete( FixedString * pCommand, bool success)
{
	ASSERT(serverZocket);
	if ( ! serverZocket || NULL == pCommand ) return;
	
	//search the command
	unsigned int nCommandID;
	for( nCommandID = 0; nCommandID < clientCommands.size(); ++nCommandID )
		if( *pCommand  == clientCommands[nCommandID] )
		{
			MsgCommandComplete msg;
			msg.command.set(&clientCommands[nCommandID]);
			msg.success = success;
			serverZocket->write( &msg , BLOCK);	

			// pop the head :
			ASSERT( ! clientCommands.empty() );
			clientCommands.erase( clientCommands.begin()+nCommandID );
			return;
		}
}

void Server_SendCommandToClient(int iClient,const CommandInfo* pCommandInfo )
{
	if( NULL == pCommandInfo )
		return;

	ASSERT(server);
	ASSERT(clients[iClient].zocket);
	if ( ! clients[iClient].zocket ) return;

	Log( "<%s>\t Sending Command: %s",clients[iClient].name.str,pCommandInfo->command.str );

	MsgCommand msg;
	msg.command.set(&pCommandInfo->command);
	clients[iClient].zocket->write( &msg , BLOCK);

	//set the client to busy - until he report different
	clients[iClient].busy = true;
//	clients[iClient].lastCommandSent = pCommandInfo->guid;
	clients[iClient].lastCommandTime = GetTime();

	serverSentCommands.push_back( *pCommandInfo );
	serverSentCommands.back().iClient = iClient;
	serverSentCommands.back().done = false;
	serverSentCommands.back().success = false;
	serverSentCommands.back().timeStart = GetTime();
	serverSentCommands.back().guid = pCommandInfo->guid;
}

void Server_SendCommandToClient(int iClient,const char * command,int guid, int nCommanderGUID, int nPriority )
{
	ASSERT(server);
	ASSERT(clients[iClient].zocket);
	if ( ! clients[iClient].zocket ) return;

	Log( "<%s>\t Sending Command: %s",clients[iClient].name.str,command );

	MsgCommand msg;
	msg.command.set(command,nCommanderGUID,nPriority);
	clients[iClient].zocket->write( &msg , BLOCK);
	
	//set the client to busy - until he report different
	clients[iClient].busy = true;
//	clients[iClient].lastCommandSent = guid;
	clients[iClient].lastCommandTime = GetTime();
	
	serverSentCommands.push_back( CommandInfo() );
	serverSentCommands.back().command.set(command,nCommanderGUID,nPriority);
	serverSentCommands.back().iClient = iClient;
	serverSentCommands.back().done = false;
	serverSentCommands.back().success = false;
	serverSentCommands.back().timeStart = GetTime();
	serverSentCommands.back().guid = guid;
}

//////////////////////////////////////////////////////////////////////////
void Server_SendSimpleCommandToClient(int iClient,const char * command )
{
	ASSERT(server);
	ASSERT(clients[iClient].zocket);
	if ( ! clients[iClient].zocket ) return;

	Log( "<%s>\t Sending Simple Command: %s",clients[iClient].name.str,command );

	MsgCommand msg;
	msg.command.set(command,-1,10000);
	clients[iClient].zocket->write( &msg , BLOCK);
}

//////////////////////////////////////////////////////////////////////////
void Server_SendServerStatusToClient( int iClient,const ServerStatus &status )
{
	ASSERT(server);
	ASSERT(clients[iClient].zocket);
	if ( ! clients[iClient].zocket ) return;

	MsgServerStatus msg;
	msg.nClients = status.nClients;
	msg.nFreeClients = status.nFreeClients;
	msg.nJobsLeft = status.nJobsLeft;
	memset( msg.reserved,0,sizeof(msg.reserved) );
	clients[iClient].zocket->write( &msg , BLOCK);
}

std::vector<CommandInfo> & Server_GetAllSentCommands()
{
	return serverSentCommands;
}

bool Server_IsClientConnected( int n )
{
	ASSERT( server );
	return clients[n].loggedIn();
}

int Server_GetClientCount()
{
	int n = MAX_CLIENTS;
/*	while ( n > 0 && ! clients[n-1].loggedIn() )
	{
		n--;
	}*/
	return n;
}

const char * Server_GetClientName(int n)
{
	return clients[n].name.str;
}

void Server_TerminateClient(int n)
{
	Log( "<%s>\t Terminate Client",clients[n].name.str );
	if( clients[n].zocket )
	{
		clients[n].zocket->appData = 0;
		clients[n].zocket->kill();
	}
	clients[n].Terminate();
}

// Message handlers
//======================================================

void handleTerminate( SimpleMsgZocket *zocket, SimpleMsg *msg ) 
{
	//ASSERT( zocket != serverZocket );
	if ( zocket == serverZocket )
	{
		dprintf("terminating server socket!!\n");
		zocket->kill();
		serverZocket = NULL;
	}
	else if ( zocket == listeningZocket )
	{
		dprintf("terminating listener socket!!\n");
		zocket->kill();
		listeningZocket = NULL;
	}
	else
	{
		Client* pClient = (Client*)zocket->appData;

		zocket->kill();

		if( pClient ) 
		{
			if( pClient->name.str)
				dprintf("terminate client : %s\n",pClient->name.str);

			pClient->Terminate();
		}
		zocket->appData = 0;
	}
}

void handleAcceptedConnection( SimpleMsgZocket *zocket, SimpleMsg *msg ) 
{
	// this zocket just got made
	dprintf("handleAcceptedConnection!!\n");
	dprintf("zockets in list : %d\n",SimpleMsgZocket::countAll());

	{
		int is_open = zocket->isOpen();
		dprintf("login zocket open : %d\n",is_open?1:0);
		int is_con = zocket->isConnected();
		dprintf("login zocket connected : %d\n",is_con?1:0);
	}

	if( server ) 
	{	
		{
			int is_open = zocket->isOpen();
			dprintf("login zocket open : %d\n",is_open?1:0);
			int is_con = zocket->isConnected();
			dprintf("login zocket connected : %d\n",is_con?1:0);
		}
	}
}

void handleConnected( SimpleMsgZocket *zocket, SimpleMsg *msg ) 
{
	dprintf("handleConnected!!\n");
	dprintf("zockets in list : %d\n",SimpleMsgZocket::countAll());
	
	if (zocket == serverZocket)
	{
		clientIsConnected = true;
	}
}

void handleLoginConfirm( SimpleMsgZocket *zocket, SimpleMsg *msg ) 
{
	dprintf("handleLoginConfirm!!\n");
	dprintf("zockets in list : %d\n",SimpleMsgZocket::countAll());

	clientIsLoggedIn = true;

	//MsgLoginConfirm *m = (MsgLoginConfirm *)msg;
}

void handleLogin( SimpleMsgZocket *zocket, SimpleMsg *msg ) 
{
	dprintf("handleLogin!!\n");
	
	dprintf("zockets in list : %d\n",SimpleMsgZocket::countAll());

	// A login associates a name with a zocket so
	// that the server can send to people by name
	// if it chooses to.
	MsgLogin *m = (MsgLogin *)msg;
	if( server ) // I'm the server
	{
		/*
		int c = m->player;
		if( clients[c].loggedIn() ) 
		{
			dprintf("handleLogin : %d already loggin in!!\n",c);
		}
		else 
		*/
		{
			// brand new client
			int iClient = 0;
			for(;;)
			{
				if ( clients[iClient].zocket == NULL )
					break;
				iClient++;
				if ( iClient == MAX_CLIENTS )
				{
					dprintf("too many clients!!\n");
					return; // can't log him in !
				}
			}

			if( CLIENT_VERSION != m->client_version )
			{
				dprintf("wrong client version!!\n");

				if (m->client_version < 18)
					return; // can't log him in !
			}

			dprintf("handleLogin : new client %d : %s\n",iClient,m->name.str);

			clients[iClient].name = m->name;
			clients[iClient].zocket = zocket;
			clients[iClient].lastStatusTime = GetTime();
			clients[iClient].version = m->client_version;
			zocket->appData = (__w64 int)&clients[iClient];
				// Set the app data to point to the
				// cached handle.  It will be reset by
				// handleTerminate

			/*
			{
				int is_open = zocket->isOpen();
				dprintf("login zocket open : %d\n",is_open);
				int is_con = zocket->isConnected();
				dprintf("login zocket connected : %d\n",is_con);
			}
			*/
			
			/*
			{
				int is_open = zocket->isOpen();
				dprintf("login zocket open : %d\n",is_open);
				int is_con = zocket->isConnected();
				dprintf("login zocket connected : %d\n",is_con);
			}
			*/

			{
			MsgLoginConfirm msg;
			zocket->write( &msg , BLOCK);
			}

			clients[iClient].isLoggedIn = true;
			clients[iClient].busy = true; // start busy until he tells me otherwise
			clients[iClient].unusable = false;
//			clients[iClient].lastCommandSent = -1;
			clients[iClient].GUID = nClientGUID++;
			nClientGUID = nClientGUID < 0 ? 1 : nClientGUID;

			int nConnectedClients = 0;
			{
				int nCC = Server_GetClientCount();
				for( int i = 0; i < nCC; ++i )
					if( Server_IsClientConnected(i) )
						nConnectedClients++;
			}

			Log( "<%s>\t New Client Connected [%d Clients]",m->name.str,nConnectedClients );

			Sleep(10);

			/*
			{
			MsgGetStatus msg;
			zocket->write( &msg , BLOCK);
			}
			*/
		}
	}
}

void handleCommand( SimpleMsgZocket *zocket, SimpleMsg *msg )  
{

	MsgCommand *m = (MsgCommand *)msg;

	//get command only from the logged in commanders in server mode
	if( server )
	{
		Client* pClient = (Client*)zocket->appData;
		if( NULL == pClient )
			return;

		__w64 int iClient = pClient - clients;
		ASSERT( clients[iClient].loggedIn() );	
		if( !clients[iClient].loggedIn() )
			return;
		clientCommands.push_back(m->command);
		clientCommands.back().CommanderGUID = pClient->GUID;
		clientCommands.back().bNew = true;

		Log( "<%s>\t Command Received: %s",clients[iClient].name.str,m->command.str );
	}
	else
	{
		clientCommands.push_back(m->command);
		clientCommands.back().bNew = true;
	}
}

void handleCommandComplete( SimpleMsgZocket *zocket, SimpleMsg *msg )  
{
	ASSERT(server);
	Client* pClient = (Client*)zocket->appData;
	if( NULL == pClient )
		return;

	MsgCommandComplete *m = (MsgCommandComplete *)msg;
	//Server_CommandComplete(m->command.str,m->success);
	dprintf("Command Complete : %s : %s\n",m->command.str,m->success ? "ok" : "fail" );

	//GetTimeDiff( m-> )
	
	__w64 int iClient = pClient - clients;
	ASSERT( clients[iClient].loggedIn() );	
	if( iClient >= MAX_CLIENTS || iClient < 0 || !clients[iClient].loggedIn() )
	{
		Log( "<BadClient> Command Complete : %s : %s",clients[iClient].name.str,m->command.str,m->success ? "ok" : "fail" );
		return;
	}

	// actually I may have already sent another command
//	ASSERT( clients[iClient].lastCommandSent == m->command );
	
//	clients[iClient].lastCommandSent = -1;										//No command at the client anymore

	double commandStartTime = GetTime();
	bool bCommandFound = false;

	// find it in serverSentCommands :
	if( serverSentCommands.size() )
	{
		__w64 unsigned int i;
		for( i=0; i < serverSentCommands.size(); ++i )
		{
			if( serverSentCommands[i].iClient == iClient &&
				serverSentCommands[i].command == m->command )
			{
				serverSentCommands[i].done = true;
				serverSentCommands[i].success = m->success;
				commandStartTime = serverSentCommands[i].timeStart;
				bCommandFound = true;
				break;
			}
		}

		if( i == serverSentCommands.size() )
			dprintf("handleAnUnknownCommandComplette: %s CommanderGUID:%d Priority:%d\n",m->command.str,m->command.CommanderGUID, m->command.Priority );

	}
	else
		dprintf("handleAnUnknownCommandComplette: %s CommanderGUID:%d Priority:%d\n",m->command.str,m->command.CommanderGUID, m->command.Priority );

	if (!bCommandFound)
	{
		int minutes,seconds;
		GetTimeDiff( commandStartTime,minutes,seconds );
		Log( "<%s>\t Command Complete : %s : %s (Time: %d:%d)",clients[iClient].name.str,m->command.str,m->success ? "ok" : "fail",minutes,seconds );
	}
}

void handleGetStatus( SimpleMsgZocket *zocket, SimpleMsg *msg )  
{
	ASSERT(client);
	Client_SendStatusToServer();
}
void handleStatus( SimpleMsgZocket *zocket, SimpleMsg *msg ) 
{
	ASSERT(server);
	// got status from client
	
	Client* pClient = (Client*)zocket->appData;
	if( NULL == pClient )
		return;

	MsgStatus *m = (MsgStatus *)msg;
	__w64 int iClient = pClient - clients;
	if( iClient >= MAX_CLIENTS || iClient < 0 || !clients[iClient].loggedIn() )
		return;
	ASSERT( clients[iClient].loggedIn() );
	//Server_Status(iClient,m->command.str,m->busy);

	double timeSinceLast = (GetTime() - clients[iClient].lastCommandTime);	

	clients[iClient].lastStatusTime = GetTime();
	clients[iClient].command = m->command;

	// Ignore client saying its free if last command was sent to it less then 10 seconds ago.
	if (!((timeSinceLast >= 0 && timeSinceLast < 10.0f) && !m->busy))
		clients[iClient].busy = m->busy;
}


//////////////////////////////////////////////////////////////////////////
void handleServerStatus( SimpleMsgZocket *zocket, SimpleMsg *msg )  
{
	ASSERT(client);
	MsgServerStatus *m = (MsgServerStatus*)msg;
	g_serverStatus.nClients = m->nClients;
	g_serverStatus.nFreeClients = m->nFreeClients;
	g_serverStatus.nJobsLeft = m->nJobsLeft;
	
	g_bServerStatusReceived = true;
}

bool Client_GetServerStatus( ServerStatus &status )
{
	if (!g_bServerStatusReceived)
		return false;
	
	status = g_serverStatus;
	return true;
}


// State
//======================================================

bool startupServer() 
{
	dprintf("StartupServer\n");
	dprintf("zockets in list : %d\n",SimpleMsgZocket::countAll());

	listeningZocket = new SimpleMsgZocket( "tcp(lb)://*:5050" );
	if( false == checkZocket(listeningZocket) )
		return false;
	listeningZocket->appData = (__w64 int)&listeningZocket;
	
	server = true;
	client = false;
	clientIsLoggedIn = false;
	clientIsConnected = false;

	dprintf("zockets in list : %d\n",SimpleMsgZocket::countAll());
	return true;
}

void shutdownServer() 
{
	if( server ) 
	{
		if( listeningZocket ) 
		{
			listeningZocket->kill();
			listeningZocket = NULL;
		}
		for( int i=0; i<MAX_CLIENTS; i++ ) 
		{
			//if( clients[i].loggedIn() ) 
			if ( clients[i].zocket != NULL )
			{
				clients[i].zocket->kill();
				clients[i].zocket = NULL;
			}
		}
		memset( clients, 0, sizeof(Client) * MAX_CLIENTS );
		clientIsLoggedIn = false;
		clientIsConnected = false;
		//server = 0;
	}
}

void startupClient() 
{
	client = true;
	server = false;
	clientIsLoggedIn = false;
	clientIsConnected = false;
}

void shutdownClient() 
{
	if( client ) 
	{
		if( serverZocket ) 
		{
			serverZocket->kill();
			serverZocket = NULL;
		}
		clientIsLoggedIn = false;
		clientIsConnected = false;
		//client = false;
	}
}


int Server_GetNumClientsConnected()
{
	int n = 0;
	for ( int i = 0; i < MAX_CLIENTS; ++i)
	{
		if (clients[i].loggedIn())
			n++;
	}
	return n;
}

const bool Server_GetClientBusy(int iClient)
{
	return clients[iClient].busy && !clients[iClient].unusable;
}


const void Server_SetClientUnusable(int iClient)
{
	clients[iClient].unusable = true;
	clients[iClient].lastUnusableTime = GetTime();
}
const bool Server_GetClientUnusable(int iClient)
{
	if (clients[iClient].version != Server_GetExpectedClientVersion())
		return true;
	return clients[iClient].unusable;
}

//////////////////////////////////////////////////////////////////////////
const int  Server_GetClientVersion(int iClient);

//////////////////////////////////////////////////////////////////////////
const void Server_SetClientUpdated(int iClient)
{
	clients[iClient].updated = true;
}
const bool Server_GetClientUpdated(int iClient)
{
	return clients[iClient].updated;
}
const int Server_GetClientVersion(int iClient)
{
	return clients[iClient].version;
}

const char * Server_GetClientCommand(int iClient)
{
	if ( clients[iClient].busy && !clients[iClient].unusable && strlen( clients[iClient].command.str ) )
		return clients[iClient].command.str;
	else
		return NULL;
}

double Server_GetClientStatusRecivedTime(int iClient)
{
	return clients[iClient].lastStatusTime;
}

double Server_GetClientCommandSendTime(int iClient)
{
	return clients[iClient].lastCommandTime;
}

int Server_GetAvailableClient() // -1 for none
{
	double timeNow = GetTime();
	int iBest = -1;
	double timeSinceBest = 0.0;
	for ( int i = 0; i < MAX_CLIENTS; ++i)
	{
		if (clients[i].loggedIn() && clients[i].unusable)
		{
			double unusableTime = timeNow - clients[i].lastUnusableTime;
			if (unusableTime > 2*60) // If unusable for 2 minutes, try it again.
			{
				// Make client usable again to try it out.
				clients[i].unusable = false;
			}
		}

		double timeSinceLast = (timeNow - clients[i].lastCommandTime);	
		double timeSinceLastState = (timeNow - clients[i].lastStatusTime);	
		if ( clients[i].loggedIn() &&
			! clients[i].busy &&																			//It's want to work..
			! Server_GetClientUnusable(i) &&													//It's want to work..
//			clients[i].lastCommandSent == -1 &&												//Not sent any command
			timeSinceLastState < 2.0 &&																//It's active
			timeSinceLast > timeSinceBest )
		{
			timeSinceBest = timeSinceLast;
			iBest = i;
		}
	}
	if ( timeSinceBest < 10.0 )																				//10 sec for lag...
		return -1;
	return iBest;
}

char g_GetenvBug[MAX_PATH];
char g_HostNameSuffix[32] = "";

const char * Client_GetClientName()
{
	memset( g_GetenvBug, 0, 80 );
	gethostname( g_GetenvBug, 79 );
	strcat( g_GetenvBug,g_HostNameSuffix );
	return g_GetenvBug;
}

void Client_GetClientName(FixedString * pName)
{
	//TODO: uhh i need a real fixedstring again...
	pName->set( Client_GetClientName(),0,0 );
	dprintf("GetClientName : %s\n",pName->str);
}

FixedString savedIP;

void SetNetBusy( const bool bBusy )
{
	bDefaultClientBusy = bBusy;
	dprintf("SetNetBusy: %s", bDefaultClientBusy ? "Busy" : "Free" );
}

bool NetInit( char const* pServerIP,const  bool bBusy ) 
{
	nClientGUID = 1;

	dprintf("Starting NetInit\n");
	dprintf("zockets in list : %d\n",SimpleMsgZocket::countAll());

	dTimeInit();

	SimpleMsgZocket::registerHandler( -1, handleTerminate );
	SimpleMsgZocket::registerHandler( -2, handleAcceptedConnection );
	SimpleMsgZocket::registerHandler( -3, handleConnected );
	SimpleMsgZocket::registerHandler( msgLogin, handleLogin );
	SimpleMsgZocket::registerHandler( msgLoginConfirm, handleLoginConfirm );
	SimpleMsgZocket::registerHandler( msgCommand, handleCommand );
	SimpleMsgZocket::registerHandler( msgCommandComplete, handleCommandComplete );
	SimpleMsgZocket::registerHandler( msgStatus, handleStatus );
	SimpleMsgZocket::registerHandler( msgGetStatus, handleGetStatus );
	SimpleMsgZocket::registerHandler( msgServerStatus, handleServerStatus );

	ASSERT( clientIsConnected == false );	
	
	if( pServerIP && strlen(pServerIP) > 2 ) 
	{
		//TODO: uhh i need a real fixedstring again
		savedIP.set(pServerIP,0,0);
		dprintf("Starting a client...\n");

		startupClient();

	    char remoteName[80];
		char* pIP = (char *)pServerIP;
		while (*pIP <= ' ' && *pIP != 0)
			pIP++;
		char* pSpace = strchr( pIP, ' ' );
		__w64 int len;
		if ( !pSpace )
			len = strlen( pIP ) + 1;
		else
			len = (__w64 int)pSpace - (__w64 int)pIP;
		memcpy( remoteName, pIP, len );
		remoteName[len] = 0;
		dprintf("Trying to connect to server %s\n",remoteName);

		char feh[1024];
		sprintf_s(feh,"tcp://%s:5050", remoteName );

		serverZocket = new SimpleMsgZocket( feh, NULL, "b" );
		if( false == checkZocket(serverZocket) )
			return false;
		serverZocket->appData = (__w64 int)&serverZocket;

		Sleep( 1000 );

		dprintf("Trying to connect to server...\n");

		double time_started = GetTime();
		while (!clientIsConnected)
		{
			if ( (GetTime() - time_started) > MAX_CLIENT_WAIT_TO_LOGIN )
			{
//				exit(10);
					return false;
			}

			Sleep(10);
			SimpleMsgZocket::pollAll();
		}
		double actual_time = GetTime() - time_started;
		dprintf("time waited for !clientIsConnected = %f\n",actual_time);

		Sleep( 1000 );

		// Log in to the server
		MsgLogin login;
		Client_GetClientName(&login.name);
		login.client_version = CLIENT_VERSION;
		serverZocket->write( &login, BLOCK );
	}
	else
	{
		dprintf("Making a server\n");
		dprintf("zockets in list : %d\n",SimpleMsgZocket::countAll());

		if( false == startupServer() )
			return false;

		//startupClient();

		serverZocket = new SimpleMsgZocket( "tcp://127.0.0.1:5050", NULL, "b" );
		if( false == checkZocket(serverZocket) )
			return false;
		serverZocket->appData = (__w64 int)&serverZocket;
		
		/*
		dprintf("Connecting to self...\n");
		dprintf("zockets in list : %d\n",SimpleMsgZocket::countAll());

		while (!clientIsConnected)
		{
			Sleep(10);
			SimpleMsgZocket::pollAll();
		}

		dprintf("Sending login to server...\n");
		dprintf("zockets in list : %d\n",SimpleMsgZocket::countAll());

		// Log in to the server
		MsgLogin login;
		serverZocket->write( &login );
		*/
	}

	if ( client )
	{
		dprintf("Trying to log in...\n");
		dprintf("zockets in list : %d\n",SimpleMsgZocket::countAll());

		double time_started = GetTime();
		while (!clientIsLoggedIn)
		{
			if ( (GetTime() - time_started) > MAX_CLIENT_WAIT_TO_LOGIN )
			{
				dprintf("client couldn't log in - quitting!\n");
//				exit(10);
					return false;
			}

			Sleep(10);
			SimpleMsgZocket::pollAll();
		}
		double actual_time = GetTime() - time_started;
		dprintf("time waited for !clientIsLoggedIn = %f\n",actual_time);
	}
	
	dprintf("Done with NetInit\n");
	return true;
}

bool IsClient() 
{
	return client; 
}

bool IsServer()
{
	return server;
}

void TickServer()
{
	//in_input_gather = true;
	
	if ( serverZocket == NULL )
	{
		dprintf("Server Lost connection to Self!!\n");
		serverZocket = new SimpleMsgZocket( "tcp://127.0.0.1:5050", NULL, "b" );
		checkZocket(serverZocket);
		serverZocket->appData = (__w64 int)&serverZocket;
	}
}

void TickClient()
{
	// if I haven't gotten a GetStatus in a long time, kill me
	
	if ( serverZocket == NULL || ! serverZocket->isConnected() )
	{
		dprintf("Lost connection to server!! Quitting!\n");
		shutdownClient();
		startupClient();
		NetInit(savedIP.str, bDefaultClientBusy);
	}
	
	double now = GetTime();
			
	// Now re-echo all input out....
	static double s_lastTimeStatusRequested = 0.0;
	if ( (now - s_lastTimeStatusRequested) > c_statusRequestInterval )
	{
		s_lastTimeStatusRequested = now;
		Client_SendStatusToServer();
	}
}

void NetFrame()
{
	SimpleMsgZocket::pollAll();
	
	dTimeLatchFrame();

	// Wait till I hear from everyone
	if (server)
	{
		TickServer();
	}

	if (client)
	{
		TickClient();
	}
}


void NetShutdown()
{
	if( client ) 
	{
		shutdownClient();
		client = false;
	}

	if( server ) 
	{
		shutdownServer();
		server = false;
	}
}

//////////////////////////////////////////////////////////////////////////
int Server_GetExpectedClientVersion()
{
	return CLIENT_VERSION;
}
