/*
********************************** MODIFIED VERSION *************************************
	Modification History:
		01.03.2006 - Tamas Schlagl: Made it confortable with VC2005
********************************** MODIFIED VERSION *************************************
*/

#ifndef NET_H
#define NET_H

#include <string.h>

//======================================================

struct FixedString
{
	enum { len = 1024 };
	char str[len];
	bool bNew;
	int  Priority;
	int	CommanderGUID;

	void set(const char *commandstring, int nCommanderGUID, int nPriority )
	{
		if( NULL == commandstring )
			return;
		strncpy_s(str,commandstring,len);
		str[len-1] = 0;
		bNew = true;
		Priority = nPriority;
		CommanderGUID = nCommanderGUID;
	}

	void set(const FixedString *ptr)
	{
		if( NULL == ptr )
			return;
		strncpy_s(str,ptr->str,len);
		str[len-1] = 0;
		bNew = true;
		Priority = ptr->Priority;
		CommanderGUID = ptr->CommanderGUID;
	}
	FixedString()
	{
		str[0] = 0;
		bNew = true;
	}
	
	bool operator == (const FixedString & other)
	{
		return _stricmp(str,other.str) == 0 && CommanderGUID == other.CommanderGUID && Priority == other.Priority;
	}
};

struct CommandInfo
{
	FixedString			command;
	double				timeStart;
	int					iClient;
	int					guid;
	bool				done;
	bool				success;
	std::vector<int>	depends;
	
	CommandInfo() : timeStart(0.0), done(false), success(false), iClient(-1), guid(-1)
	{		
	}
};

//////////////////////////////////////////////////////////////////////////
struct ServerStatus
{
	int nClients;
	int nFreeClients;
	int nJobsLeft;
};

// Messages
//======================================================

bool NetInit( char const* pServerIP, bool bBusy = false );
void NetFrame();
void NetShutdown();
void SetNetBusy( const bool bBusy );

bool IsClient();
bool IsServer();

double GetTime( void );

//////////////////////////////////////////////////////////////////////////
inline void GetTimeDiff( double startTime,int &minutes,int &seconds )
{
	double dt = GetTime() - startTime;
	minutes = (int) dt/60;
	seconds = (int) fmod(dt,60);
}

//======================================================
// Client calls these :

bool Client_GetCommand( FixedString * pInto  ); // returns if any
void Client_CommandComplete( FixedString * pCommand , bool success);

const char * Client_GetClientName();

void Client_SendStatusToServer();
void Client_SendStatusToServer(const char * command,bool busy);

void Client_RequestCommand(const char * command, int nPriority);

// Return true if client is connected to server.
bool Client_IsConnected();
// Return true if client is logged in to server.
bool Client_IsLoggedIn();

// Return false if status was not yet received from the server.
bool Client_GetServerStatus( ServerStatus &status );

//======================================================

bool Server_GetRemoteCommandRequest( FixedString* pCommand );

void Server_SendCommandToClient(int iClient,const CommandInfo* pCommandInfo );
void Server_SendCommandToClient(int iClient,const char * command,int guid, int nCommanderGUID, int nPriority );
void Server_SendSimpleCommandToClient(int iClient,const char * command );
void Server_SendServerStatusToClient( int iClient,const ServerStatus &status );

int Server_GetAvailableClient(); // -1 for none

int Server_GetExpectedClientVersion();

// Server can ask about these :
int Server_GetClientCount();
const char * Server_GetClientName(int n);
bool Server_IsClientConnected( int n );
const int  Server_GetClientVersion(int iClient);
const bool Server_GetClientBusy(int iClient);
const void Server_SetClientUnusable(int iClient);
const bool Server_GetClientUnusable(int iClient);
const void Server_SetClientUpdated(int iClient);
const bool Server_GetClientUpdated(int iClient);
const char * Server_GetClientCommand( int n ); // NULL for none
double Server_GetClientStatusRecivedTime(int iClient);
double Server_GetClientCommandSendTime(int iClient);
void Server_TerminateClient(int n);

int Server_GetNumClientsConnected();

std::vector<CommandInfo> & Server_GetAllSentCommands();

//======================================================
#endif

