#ifndef REGEXP_H
#define REGEXP_H

// This is a C++ Wrapper around Henry Spencer's original
// regex code.  See regexp.cpp for distribution license details.
// The RegExp class is original of Zachary B. Simpson, all other code is inherited.
// *** THIS IS AN ALTERED VERSION. It was altered by Zachary B. Simpson, 1997
// *** I added various escape sequences to the character match like [\r],


/*
 * Definitions etc. for regexp(3) routines.
 *
 * Caveat:  this is V8 regexp(3) [actually, a reimplementation thereof],
 * not the System V one.
 *
 */

/*
********************************** MODIFIED VERSION *************************************
Modification History:
01.03.2006 - Tamas Schlagl: Made it confortable with VC2005
********************************** MODIFIED VERSION *************************************
*/

#define NSUBEXP  10
typedef struct regexp {
	char *startp[NSUBEXP];
	char *endp[NSUBEXP];
	char regstart;		/* Internal use only. */
	char reganch;		/* Internal use only. */
	char *regmust;		/* Internal use only. */
	__w64 int regmlen;		/* Internal use only. */
	char program[1];	/* Unwarranted chumminess with compiler. */
} regexp;


extern regexp *regcomp( const char *exp );
extern int regexec( const regexp *prog, const char *string );
extern void regsub();
extern void regerror( const char *s );


// Oh, happy regular expression parser!!!

struct RegExp {
	static char buffer [80];
	regexp *a;
	int b;
	char *start;

	RegExp() { }
	RegExp( char *regex );
		// Feed the constructor the regular expression, this
		// get compiled for speed purposes

	void set( char *regex );

	~RegExp();

	int test( char *string );
		// Feed the string to compare to.  Returns if anything
		// was found or not.  If anything was found, then
		// use the get() to extract the parenthesized subparts
		// starting at offset 1.  0 is used for the whole matching string
		// You can ignore the return value if you want

	char *get( int i, char *dst=(char*)0, __w64 int dstSize=80, __w64 int skip=0, int retNULL=1 );
		// Get subpart, 0 = whole matching, 1 = first parenthesis
		// If you don't supply a dst buffer, the static one
		// will be used.
		// This will null terminate the string for you
		// If you specify skip, it will skip over that many chars
		// at the head of the string.  Useful when you are
		// extracting words that are optionally delimited

	__w64 int getPos( __w64 int i );
		// Gives the position in the string of the ith element (see above)
		// WARNING! This can return -1 if it wasn't found

	__w64 int getRealPos( __w64 int i );
		// Gives the position relative to the whole string

};

#endif
