// DJS_Client.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "DJS_Client.h"
#include "DJS_WorkerThread.h"

#ifdef WIN32
#include <shellapi.h>
#include <psapi.h>
#endif

#define JOBSERVER_IMPORT
#include "..\Common\IJobServer.h"

#include "CpuInfo.h"

#define				INFO_INTERVAL 8																							//Time of the update interval of info screen
#define				DJS_CLIENT_VERSION 3.0f																			//Version of the Client - (Important for Client - Server communication)
//#define				DJS_CLIENT_SERVERNAME "PC051"																//Development pc...


char g_DJS_CLIENT_SERVERNAME[256] = "DJS_SERVER";
char g_WINDOWS_JOBSERVER_DIRECTORY[256] = "\\\\DJS_SERVER\\DJS\\";
char g_WINDOWS_JOBSERVER_SUB_DIRECTORY[256] = "Versions\\Windows\\";
char g_EXE_DIRECTORY[256] = "";
char g_szWorkPath[MAX_PATH] = "";


//This is the directory of the job servers..
#define LINUX_JOBSERVER_DIRECTORY	"data/Versions/"

//Pre stored "emulated" jobs for the job servers - for debugging purpose
#ifdef EMULATION_ENABLED
	#define MAX_EMULATEDSTRING	1
	char *g_szEmulatedCommandString[MAX_EMULATEDSTRING] = {
			"DJS_RAMJobServer \"Hill\" 0",
/*			"RendererJobServer \"\\\\trash2\\public\\__users\\Tamas\\DX10\" 1 ",
			"RendererJobServer \"\\\\trash2\\public\\__users\\Tamas\\DX10\" 2 ",
			"RendererJobServer \"\\\\trash2\\public\\__users\\Tamas\\DX10\" 3 ",*/
	};
	int	g_nEmulatedCommand = 0;
#endif

//----------------------------------------------------------------------
// Clears the screen
//----------------------------------------------------------------------
void clrscr()
{
	COORD coordScreen = { 0, 0 };
	DWORD cCharsWritten;
	CONSOLE_SCREEN_BUFFER_INFO csbi;
	DWORD dwConSize;
	HANDLE hConsole = GetStdHandle(STD_OUTPUT_HANDLE);

	GetConsoleScreenBufferInfo(hConsole, &csbi);
	dwConSize = csbi.dwSize.X * csbi.dwSize.Y;
	FillConsoleOutputCharacter(hConsole, TEXT(' '),
		dwConSize,
		coordScreen,
		&cCharsWritten);
	GetConsoleScreenBufferInfo(hConsole, &csbi);
	FillConsoleOutputAttribute(hConsole,
		csbi.wAttributes,
		dwConSize,
		coordScreen,
		&cCharsWritten);
	SetConsoleCursorPosition(hConsole, coordScreen);
}

//////////////////////////////////////////////////////////////////////////
void Log( const char* szFormat,...)
{
	FILE *f;
	fopen_s( &f, "C:\\DJS_CLIENT\\DJS_Client.log", "at" );
	if( f )
	{
		char timestr[32];
		_strtime_s( timestr,sizeof(timestr) );

		char datestr[128];
		_strdate_s( datestr,sizeof(datestr) );

		va_list arglist;
		va_start(arglist, szFormat);
		char szBuf[1024];
		vsprintf_s( szBuf, 1024, szFormat, arglist);
		fprintf_s( f, "[%s][%s] %s\n",datestr,timestr,szBuf );
		fclose(f);
	}
}

//------------------------------------------------------------------------------------------------------------------
// Copy file function
//------------------------------------------------------------------------------------------------------------------
int CopyFile( const char* szSource, const char* szDestination )
{
	if( NULL == szSource || NULL == szDestination )
		return -1;

	char szCommand[1024];

	strcpy_s( szCommand, 1024, "copy ");
	strcat_s( szCommand, 1024, szSource );
	strcat_s( szCommand, 1024, " " );
	strcat_s( szCommand, 1024, szDestination );
	strcat_s( szCommand, 1024, " /Y" );

	Log( szCommand );
	return system( szCommand );
}

int XCopy( const char* szSource, const char* szDestination )
{
	if( NULL == szSource || NULL == szDestination )
		return -1;

	char szCommand[1024];

	strcpy_s( szCommand, 1024, "xcopy ");
	strcat_s( szCommand, 1024, szSource );
	strcat_s( szCommand, 1024, " " );
	strcat_s( szCommand, 1024, szDestination );
	strcat_s( szCommand, 1024, " /Y" );

	Log( szCommand );

	return system( szCommand );
}
/*
void Test()
{
	char sLib[_MAX_PATH];
	strcpy(sLib,"\\\\DJS_SERVER\\DJS\\Versions\\Windows\\DJS_ShaderPrecacheJobServer.dll");

	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char fext[_MAX_EXT];

	_splitpath(g_EXE_DIRECTORY,drive,dir,NULL,NULL);
	_splitpath(sLib,NULL,NULL,fname,fext);

	char sLocalDLL[_MAX_PATH];
	char sRemoteDLL[_MAX_PATH];
	_makepath_s(sLocalDLL,drive,dir,fname,"dll");

	_splitpath(sLib,drive,dir,fname,fext);
	_makepath_s(sRemoteDLL,drive,dir,fname,"dll");

	Log( "Start Copy Test" );
	if (0 != XCopy( sRemoteDLL, g_EXE_DIRECTORY ) )
	{
		Log( "Test File copy failed" );
		return;
		//return DJS_LoadLibrary(sLib);
	}
	Log( "Test File copy OK" );
}
*/

//////////////////////////////////////////////////////////////////////////
bool IsDllAlreadLoaded( const char *filename )
{
#ifdef WIN32
	HMODULE hMods[1024];
	HANDLE hProcess = GetCurrentProcess();
	DWORD cbNeeded;

	if( EnumProcessModules( hProcess, hMods, sizeof(hMods), &cbNeeded))
	{
		for (unsigned int i = 0; i < (cbNeeded / sizeof(HMODULE)); i++ )
		{
			TCHAR szModName[MAX_PATH];

			// Get the full path to the module's file.

			if ( GetModuleFileNameEx( hProcess, hMods[i], szModName,sizeof(szModName)/sizeof(TCHAR)))
			{
				if (strstr(szModName,filename) != 0)
				{
					//Log( "DLL %s already loaded",filename );
					return true;
				}
			}
		}
	}
#endif

	return false;
}

//////////////////////////////////////////////////////////////////////////
HMODULE DJS_GetAndLoadLibrary( const char *sLib )
{
#ifdef WIN32
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char fext[_MAX_EXT];
	
	_splitpath(g_EXE_DIRECTORY,drive,dir,NULL,NULL);
	_splitpath(sLib,NULL,NULL,fname,fext);

	char sLocalDLL[_MAX_PATH];
	char sRemoteDLL[_MAX_PATH];
	_makepath_s(sLocalDLL,NULL,NULL,fname,"dll");

	// check if dll already loaded.
	if (IsDllAlreadLoaded(sLocalDLL))
	{
		return DJS_LoadLibrary(sLocalDLL);
	}

	_splitpath(sLib,drive,dir,fname,fext);
	_makepath_s(sRemoteDLL,drive,dir,fname,"dll");
	
	if (0 != XCopy( sRemoteDLL, g_EXE_DIRECTORY ) )
	{
		Log( "File copy %s to %s failed",sRemoteDLL,g_EXE_DIRECTORY );
		//return NULL;
	}
//	Log( "DLL %s loaded successfully",sLocalDLL );
	return DJS_LoadLibrary(sLocalDLL);
#else
	return DJS_LoadLibrary(sLib);
#endif
}

//----------------------------------------------------------------------
// Init the client
//----------------------------------------------------------------------
int CDistributedJobService_Client::Init(const bool bSmallInfo,const int nFreeMemoryMB )
{
	Log( "\n" );
	Log( "--------------------------------------- START ---------------------------------------" );

	m_nAllocatedMemoryMB = 0;
	m_nFreeMemoryMB = nFreeMemoryMB;
	m_bSmallInfo = bSmallInfo;

#ifdef WIN32
	/*
	SYSTEM_INFO   sys_info;
	GetSystemInfo( &sys_info );
	m_nNumberOfUsableWorkerThread = sys_info.dwNumberOfProcessors;
	*/
	m_nNumberOfUsableWorkerThread = 1;

	unsigned int nCores = 1;
	unsigned int nCoresForProcess = 1;
	GetNumCPUCores(nCores,nCoresForProcess);
	m_nNumberOfUsableWorkerThread = nCoresForProcess;

#else
	m_nNumberOfUsableWorkerThread = 1;
#endif

	//Test everytime.
	m_nNumberOfUsableWorkerThread = MAX_WORKERTHREAD_NUMBER < m_nNumberOfUsableWorkerThread ? MAX_WORKERTHREAD_NUMBER : m_nNumberOfUsableWorkerThread;
	memset( m_Workers, 0, sizeof(SWorkerInfo)*MAX_WORKERTHREAD_NUMBER );

	Log( "Available threads: %d",m_nNumberOfUsableWorkerThread );

	m_dLastWorkingTime = 0;
	m_dLastInfoTime		= -INFO_INTERVAL;
	SetNetBusy( false );
#ifndef EMULATION_ENABLED
	m_szClientName = Client_GetClientName();
#endif

	//set the thread priority
	HANDLE Handle = GetCurrentThread();
	SetThreadPriority(Handle,THREAD_PRIORITY_BELOW_NORMAL);
	CloseHandle( Handle );

	m_nJobServerInfoNumber = 0;
	m_JobServerInfos = NULL;


#ifndef EMULATION_ENABLED
	if( false == NetInit( g_DJS_CLIENT_SERVERNAME ) )
	{
		printf("###############################################################################\n");
		printf("### Crytek's distributed job service - Client Version %2.2f                  ###\n", DJS_CLIENT_VERSION );
		printf("###############################################################################\n\n");
		printf("NET>  Can't connect to the '%s' server! Terminate the program. <<<<\n", g_DJS_CLIENT_SERVERNAME );
		NetShutdown();
		return -1;
	}
#endif

	return 1;
}

//----------------------------------------------------------------------
// Init the client
//----------------------------------------------------------------------
int CDistributedJobService_Client::Done()
{
	SetNetBusy( true );
	int i;
	for( i = 0; i < m_nNumberOfUsableWorkerThread; ++i )
		if( NULL != m_Workers[i].m_pThread )
		{
			m_Workers[i].m_pThread->Done();
			delete m_Workers[i].m_pThread;
		}

	memset( m_Workers, 0, sizeof(SWorkerInfo)*MAX_WORKERTHREAD_NUMBER );

	if( m_JobServerInfos )
		delete m_JobServerInfos;
	m_JobServerInfos = NULL;
	m_nJobServerInfoNumber = 0;

	Log("Client shutdown.");
#ifndef EMULATION_ENABLED
	NetShutdown();
#endif

	return 1;
}

//----------------------------------------------------------------------
// Search the first free worker thread
//----------------------------------------------------------------------
int CDistributedJobService_Client::CheckForFreeWorker()
{
	int i;

	// No free workers if any exclusive worker.
	for( i = 0; i < m_nNumberOfUsableWorkerThread; ++i )
		if (m_Workers[i].m_bExclusiveMode)
			return -1;

	for( i = 0; i < m_nNumberOfUsableWorkerThread; ++i )
		if( NULL == m_Workers[i].m_pThread )
			return i;

	return -1;
}

//----------------------------------------------------------------------
// Start a worker with the JobServer and Job
//----------------------------------------------------------------------
int CDistributedJobService_Client::InitWorker( const FixedString* pCommand, const int nWorkerID )
{
	if( NULL == pCommand )
		return -1;

	Log( "Init Worker [%d] for %s",nWorkerID,pCommand->str );

	if( m_Workers[nWorkerID].m_pThread )
	{
		Log("DJS>> Try to overload an thread! Client shutdown. <<");
		return -1;
	}

	//Get the JobServerName
	char szText[1024];
	strcpy_s( szText, 1024, pCommand->str );
	char* szJobServerName = szText;
	char* szJob = strchr( szText , ' ' );
	if( szJob )
		*szJob++ = 0;
	else
	{
		Log("DJS>> Wrong JOB description!  <<");
		delete m_Workers[nWorkerID].m_pThread;
		m_Workers[nWorkerID].m_pThread = NULL;
		return -3;
	}

	char szExtendedJobServerName[1024];
#ifdef LINUX_VERSION
	strcpy_s( szExtendedJobServerName, 1024, LINUX_JOBSERVER_DIRECTORY );
	strcat_s( szExtendedJobServerName, 1024, szJobServerName );
//	strcpy_s( szExtendedJobServerName, 1024, szJobServerName );
#else
 #ifdef _DEBUG
	strcpy_s( szExtendedJobServerName, 1024, szJobServerName );
	strcat_s( szExtendedJobServerName, 1024, ".dll" );
 #else
	strcpy_s( szExtendedJobServerName, 1024,g_WINDOWS_JOBSERVER_DIRECTORY );
	strcat_s( szExtendedJobServerName, 1024, g_WINDOWS_JOBSERVER_SUB_DIRECTORY );
	strcat_s( szExtendedJobServerName, 1024, szJobServerName );
	strcat_s( szExtendedJobServerName, 1024, ".dll" );
 #endif
#endif
	Log( "Load Job Server %s",szExtendedJobServerName );
	SJobServerInfoEx* pInfo = GetServerInfo( szExtendedJobServerName );
	if( NULL == pInfo )
	{
		Log("DJS>> JobServer (%s) not found. <<", szExtendedJobServerName );
		return -2;		//can be a local network or other issue
	}

	m_Workers[nWorkerID].m_pThread = new cDJS_WorkerThread;
	if( NULL == m_Workers[nWorkerID].m_pThread )
	{
		Log("DJS>> Can't create the worker thread. Client shutdown.  <<");
		return -1;
	}
	m_Workers[nWorkerID].m_bExclusiveMode = pInfo->m_bExclusiveMode;

	//Set the job
	if( false == m_Workers[nWorkerID].m_pThread->SetJob( szExtendedJobServerName, szJob, g_szWorkPath, nWorkerID ) )
	{
		Log("DJS>> Wrong JOB description!  <<");
		delete m_Workers[nWorkerID].m_pThread;
		m_Workers[nWorkerID].m_pThread = NULL;
		return -3;													//Not fatal problem
	}

	//Start the thread
	if( false == m_Workers[nWorkerID].m_pThread->Init(nWorkerID) )
	{
		Log("DJS>> Can't init the worker thread. Client shutdown.  <<");
		return -2;
	}

	//copy the command string
	m_Workers[nWorkerID].m_Command.set( pCommand );
	m_Workers[nWorkerID].m_StartTime = GetTime();

	++pInfo->m_nCurrentNumberOfRunningThread;
	return 1;
}

//////////////////////////////////////////////////////////////////////////
void CDistributedJobService_Client::StopWorkers()
{
	int i;
	for( i = 0; i < m_nNumberOfUsableWorkerThread; ++i )
	{
		if( NULL != m_Workers[i].m_pThread )
		{
			if (Client_IsLoggedIn())
				Client_CommandComplete(&m_Workers[i].m_Command,false);
			m_Workers[i].m_pThread->Done();
			delete m_Workers[i].m_pThread;
		}
	}
	memset( m_Workers, 0, sizeof(SWorkerInfo)*MAX_WORKERTHREAD_NUMBER );
}

//////////////////////////////////////////////////////////////////////////
void CDistributedJobService_Client::StopWorker( const char *sJob )
{
	int i;
	for( i = 0; i < m_nNumberOfUsableWorkerThread; ++i )
	{
		if( NULL != m_Workers[i].m_pThread )
		{
			if (strcmp(m_Workers[i].m_Command.str,sJob) == 0)
			{
				Log( "Abort Job %s",sJob );

				if (Client_IsLoggedIn())
					Client_CommandComplete(&m_Workers[i].m_Command,false);

				m_Workers[i].m_pThread->Done();
				delete m_Workers[i].m_pThread;
				m_Workers[i].m_pThread = 0;
			}
		}
	}
}

//----------------------------------------------------------------------
// Manage the workers :)
//----------------------------------------------------------------------
int CDistributedJobService_Client::ManageWorkers()
{
	ServerStatus serverStatus;
	Client_GetServerStatus(serverStatus);
	if (!Client_IsLoggedIn() || (serverStatus.nJobsLeft == 0 && (GetTime()-m_dLastWorkingTime) > 5))
	{
		// When client is not logged in to server anymore we force all worked to stop.
		// When Server doesn`t have any jobs anymore to do, our job is not needed, and we need to stop workers.
		StopWorkers();
		return 1;
	}
	else
	{
		//
		m_dLastWorkingTime = GetTime();
	}
	int i;
	m_nAllocatedMemoryMB = 0;
	for( i = 0; i < m_nNumberOfUsableWorkerThread; ++i )
		if( NULL != m_Workers[i].m_pThread )
		{
			//finished the work..
			if( false == m_Workers[i].m_pThread->IsRunning() )
			{
				if( m_Workers[i].m_pThread->GetJobServerName() )
				{
					SJobServerInfoEx* pInfo = GetServerInfo( m_Workers[i].m_pThread->GetJobServerName() );
					if( pInfo )
						--pInfo->m_nCurrentNumberOfRunningThread;
				}

				bool bComplete = ( 0 == m_Workers[i].m_pThread->Done() );
				delete m_Workers[i].m_pThread;
				m_Workers[i].m_pThread = NULL;
				m_Workers[i].m_bExclusiveMode = false;
#ifndef EMULATION_ENABLED
				Client_CommandComplete(&m_Workers[i].m_Command,bComplete);
				SetNetBusy( false );																					//Ready to get a new command.
#endif
				Log("A job [%d] %s finished, status: %s, thread closed.",i,m_Workers[i].m_Command.str,(bComplete)?"Success":"Fail" );
			}
			else
				m_nAllocatedMemoryMB += m_Workers[i].m_pThread->GetUsedMemoryMB();
		}


	//Make decision about to enable more client...

	bool bExclusiveJob = false;

	//get the number of active thread & check the exclusive mode
	int nThreadNumber = 0;
	int nAllowedThreadNumber = m_nNumberOfUsableWorkerThread;
//	char* szExclusiveJobServerName = NULL;
	for( int i = 0; i < m_nNumberOfUsableWorkerThread; ++i )
		if( NULL != m_Workers[i].m_pThread )
		{
			if( m_Workers[i].m_pThread->GetJobServerName() )
			{
				SJobServerInfoEx* pInfo = GetServerInfo( m_Workers[i].m_pThread->GetJobServerName() );
				if( pInfo )
				{
					if (pInfo->m_bExclusiveMode)
						bExclusiveJob = true;
					nAllowedThreadNumber = pInfo->m_nMaxThread < nAllowedThreadNumber ? pInfo->m_nMaxThread : nAllowedThreadNumber;
				}
			}
			++nThreadNumber;
		}

	bool bBusy = false;

	//get the allowed maximum thread
	if( nThreadNumber >= nAllowedThreadNumber )
		bBusy = true;
	else
		//"predict" the new thread's memory allocation..
		if( nThreadNumber && m_nAllocatedMemoryMB )
		{
			int nPredictedMemoryMB = m_nAllocatedMemoryMB*(nThreadNumber+1) / nThreadNumber;
			if( nPredictedMemoryMB >= m_nFreeMemoryMB )
				bBusy = true;
		}

	if (bExclusiveJob)
		bBusy = true;

#ifndef EMULATION_ENABLED
		SetNetBusy(bBusy);
#endif

	return 1;
}


//----------------------------------------------------------------------
// Network management
//----------------------------------------------------------------------
int CDistributedJobService_Client::Run()
{
	FixedString Command;

	Sleep(1000);
	int nFreeWorker = CheckForFreeWorker();


	//if (DJS_GetAndLoadLibrary("\\\\DJS_SERVER\\DJS\\Versions\\Windows\\DJS_ShaderPrecacheJobServer.dll"))
	{
		//Log( "Job DLL Loaded OK" );
	}
//		Test();

#ifdef EMULATION_ENABLED
	//if there are free
	if( -1 != nFreeWorker )
	{
		if( g_nEmulatedCommand == MAX_EMULATEDSTRING )
		{
			//wait all the workers to finish
			int i;
			for( i = 0; i < m_nNumberOfUsableWorkerThread; ++i )
			{
				if( NULL != m_Workers[i].m_pThread )
					break;
			}

			if( i == m_nNumberOfUsableWorkerThread)
				return 0;
		}
		else
		{	

			strcpy_s( Command.str, Command.len, g_szEmulatedCommandString[g_nEmulatedCommand] );
			++g_nEmulatedCommand;

			//Check is there any new job
			int nRes = InitWorker( &Command, nFreeWorker );
			if( 1 != nRes )
				return nRes;
		}
	}
#else
	//if there are free
	if( -1 != nFreeWorker )
	{
#ifdef _DEBUG
		//printf("Freeworker:%d ", nFreeWorker );
#endif
		//Check is there any new job
		if( Client_GetCommand( &Command ) )
		{
			Log( "New command recieved: %s",Command.str );

			if (stricmp(Command.str,"update") == 0)
			{
				// Update itself by running install.bat from exe dir.
				Update();
				Client_CommandComplete(&Command,true );
			}
			if (strstr(Command.str,"abort") != 0)
			{
				if (strcmp(Command.str,"abort") == 0)
				{
					// Just abort.
					StopWorkers();
				}
				else
				{
					// Find worker who execute this command and abort it.
					StopWorker( Command.str + strlen("abort")+1 );
				}
			}
			else
			{
				// Normal command.
				int nRes = InitWorker( &Command, nFreeWorker );
				if( 1 != nRes )
				{
#ifdef _DEBUG
					printf("initworker failed.\n");
#endif
					//fatal error
					if( -1 == nRes )
						return nRes;

					//send back the problematic command.. maybe i haven't got the right jobserver or other problem
#ifndef EMULATION_ENABLED
					Client_CommandComplete(&Command,(nRes == -3) ? true : false );
#endif
				}
			}
		}
#ifdef _DEBUG
		//else
		//	printf("no command.\n");
#endif
	}
#endif
	ManageWorkers();
	ShowInfo();
#ifndef EMULATION_ENABLED
	NetFrame();
#endif
	return 0;
}

//----------------------------------------------------------------------
// Show info screen
//----------------------------------------------------------------------
void CDistributedJobService_Client::ShowInfo()
{
	char szText[1024];
	double dActualTime = GetTime();
	if( m_bSmallInfo )
#ifndef EMULATION_ENABLED
		if( dActualTime - m_dLastInfoTime >  2 )
#else
		if( dActualTime - m_dLastInfoTime >  10 )
#endif
		{

			for( int i = 0; i < m_nNumberOfUsableWorkerThread; ++i )
			{
				printf("%d. Thread: ", i);
				if( NULL == m_Workers[i].m_pThread )
					printf("Inactive");
				else
				{
					strcpy_s( szText, 1024, m_Workers[i].m_Command.str );
					char* szJobServerName = szText;
					char* szJob = strchr( szText , ' ' );
					if( szJob )
					{
						*szJob++ = 0;
						printf("Job: %s", szJob );
					}

					int nPercent = m_Workers[i].m_pThread->GetPercent();
					if( 0 != nPercent )
					{
						double dTimeRemaining =  (dActualTime-m_Workers[i].m_StartTime) / (double)nPercent * (double)(100-nPercent);
						printf(" %d% remaining %.0fs", nPercent, dTimeRemaining );
					}

					printf(" server: %s", szJobServerName );
				}
				printf("\n");
			}
			printf("\n");
		}
	else
		if( dActualTime - m_dLastInfoTime >  INFO_INTERVAL )
		{
			clrscr();
			printf("###############################################################################\n");
			printf("### Crytek's distributed job service - Client Version %2.2f                  ###\n", DJS_CLIENT_VERSION );
			printf("###############################################################################\n");
	#ifdef EMULATION_ENABLED
			printf("HostName: EMULATION \n");
	#else
			printf("HostName: %s \n", m_szClientName);
	#endif

			double dActualTime = GetTime();

			for( int i = 0; i < m_nNumberOfUsableWorkerThread; ++i )
			{
				printf("\n%d. Thread:\n", i);
				if( NULL == m_Workers[i].m_pThread )
					printf("    INACTIVE.\n\n\n");
				else
				{
					strcpy_s( szText, 1024, m_Workers[i].m_Command.str );
					char* szJobServerName = szText;
					char* szJob = strchr( szText , ' ' );
					if( szJob )
					{
						*szJob++ = 0;
						printf("    JOB: %s\n", szJob );
					}
					else
						printf("\n");

					int nPercent = m_Workers[i].m_pThread->GetPercent();
					if( 0 == nPercent )
						printf("    PERCENT: 0/100, TIME REMAINING: ---s\n");
					else
					{
						double dTimeRemaining =  (dActualTime-m_Workers[i].m_StartTime) / (double)nPercent * (double)(100-nPercent);
						printf("    PERCENT: %d/100, TIME REMAINING: %.0fs\n", nPercent, dTimeRemaining );
					}

					printf("    JOB SERVER: %s\n", szJobServerName );
				}
			}
		}
}


//----------------------------------------------------------------------
// Search a job server info
//----------------------------------------------------------------------
SJobServerInfoEx* CDistributedJobService_Client::GetServerInfo( const char* szJobServerName )		
{
	SJobServerInfoEx* pInfo;
	//Try to find the job service
	int i;
	for( i = 0; i < m_nJobServerInfoNumber; ++i )
	{
		if( 0 == _stricmp( m_JobServerInfos[i].m_szName, szJobServerName ) )
		{
			pInfo = &m_JobServerInfos[i];
			break;
		}
	}

	//not found
	if( i == m_nJobServerInfoNumber )
	{
		//Create a new one..
		SJobServerInfoEx* pNewInfoArray = new SJobServerInfoEx[ m_nJobServerInfoNumber+1 ];
		if( m_JobServerInfos )
			memcpy( pNewInfoArray, m_JobServerInfos, sizeof(SJobServerInfoEx)*m_nJobServerInfoNumber );

		if( m_JobServerInfos )
			delete m_JobServerInfos;
		m_JobServerInfos = pNewInfoArray;
		pInfo = &m_JobServerInfos[ m_nJobServerInfoNumber ];
		++m_nJobServerInfoNumber;
	}


	//update every time, more safe method in a highly changing word..

	//get infos from the dll...
	HMODULE JobServerDLL = DJS_GetAndLoadLibrary( szJobServerName );
	if (!JobServerDLL)
	{
		Log( " DJS_LoadLibrary( %s ) failed\n",szJobServerName );
		return NULL;
	}

	IJobServer::TGetInfoFunction GetJobServerInfo = (IJobServer::TGetInfoFunction)DJS_GetProcAddress( JobServerDLL, "GetJobServerInfo" );
	if( !GetJobServerInfo )
	{
		Log( " DJS_GetProcAddress( %d,\"GetJobServerInfo\" ) failed\n",JobServerDLL );
		DJS_FreeLibrary( JobServerDLL );
		return NULL;
	}

	SJobServerInfo Info;
	memset( &Info,0,sizeof(Info) );
	GetJobServerInfo( &Info );

	DJS_FreeLibrary( JobServerDLL );

	//include it
	memset( pInfo->m_szName, 0, 1024 );
	strcpy_s( pInfo->m_szName, 1024, szJobServerName );
	pInfo->m_nMaxThread = Info.m_nMaxThread;
//	pInfo->m_nMinMemoryPerThread = Info.m_nMinMemoryPerThread;
	pInfo->m_bExclusiveMode = Info.m_bExclusiveMode;
	pInfo->m_nCurrentNumberOfRunningThread = 0;


	return pInfo;
}

//////////////////////////////////////////////////////////////////////////
void CDistributedJobService_Client::Update()
{
#ifdef WIN32
	Log( "Updating..." );

	SHELLEXECUTEINFOA ExecInfo;
	ZeroMemory(&ExecInfo,sizeof(ExecInfo));
	ExecInfo.cbSize = sizeof(ExecInfo);
	ExecInfo.hwnd = NULL;

	//run the editor
	ExecInfo.lpFile = "Install.bat";
	ExecInfo.lpDirectory = g_EXE_DIRECTORY;
	ExecInfo.nShow = SW_HIDE;
	ExecInfo.hInstApp = 0;
	ExecInfo.fMask = SEE_MASK_CONNECTNETDRV | SEE_MASK_NOCLOSEPROCESS;

	if( false == ShellExecuteExA( &ExecInfo ) )
	{
		Log( "<ERROR> Failed to start Install.bat" );
		return;
	}
	CloseHandle( ExecInfo.hProcess );

	_exit(0);
#endif
}

//////////////////////////////////////////////////////////////////////////
#include "../Common/SimpleIni.h"
extern bool g_bForceRunFullMode;
void ReadIniFile()
{
	char sIniFile[256];
	strcpy_s(sIniFile,sizeof(sIniFile),"DJS.ini");
#ifdef WIN32
	char szExeFile[_MAX_PATH];
	GetModuleFileName(NULL,szExeFile,sizeof(szExeFile) );
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char fext[_MAX_EXT];
	_splitpath(szExeFile,drive,dir,NULL,NULL);
	_makepath_s(sIniFile,sizeof(sIniFile),drive,dir,"DJS","ini");

	_makepath_s(g_EXE_DIRECTORY,sizeof(g_EXE_DIRECTORY),drive,dir,NULL,NULL);
#endif

	strcpy_s(g_szWorkPath,sizeof(g_szWorkPath),g_EXE_DIRECTORY);

	CSimpleIni ini(false,false);
	if (0 == ini.LoadFile(sIniFile))
	{
		const char *pszVal;
		bool bHasMulti;
		pszVal = ini.GetValue( "", "server", 0, &bHasMulti );
		if (pszVal)
		{
			strcpy_s( g_DJS_CLIENT_SERVERNAME,sizeof(g_DJS_CLIENT_SERVERNAME),pszVal );
		}
		pszVal = ini.GetValue( "", "server_directory", 0, &bHasMulti );
		if (pszVal)
		{
			strcpy_s( g_WINDOWS_JOBSERVER_DIRECTORY,sizeof(g_WINDOWS_JOBSERVER_DIRECTORY),pszVal );
		}
		pszVal = ini.GetValue( "", "fullmode", 0, &bHasMulti );
		if (pszVal)
		{
			if (*pszVal != '0')
				g_bForceRunFullMode = true;
		}
		pszVal = ini.GetValue( "", "WorkPath", 0, &bHasMulti );
		if (pszVal)
		{
			if (*pszVal != '0')
			{
				strcpy_s( g_szWorkPath,sizeof(g_szWorkPath),pszVal );
				if (strlen(g_szWorkPath) > 0 && g_szWorkPath[strlen(g_szWorkPath)-1] == '\\') // test for ending slash
					g_szWorkPath[strlen(g_szWorkPath)-1] = 0;
			}
		}
	}

	Log( "Server: %s",g_DJS_CLIENT_SERVERNAME );
}