#ifndef DJS_WORKERTHREAD_H
#define DJS_WORKERTHREAD_H

#include "../Common/WorkerThread.h"

/*
	cDJS_WorkerThread - the thread which running a "JOB", this system running every time a new worker thread when a job
	arrived because the chunk of the job's are big, and it help to keep the system simple.
*/
class cDJS_WorkerThread : public cWorkerThread
{
public:
	cDJS_WorkerThread():m_nCPUID(0),m_nPercent(0),m_szJobServerName(NULL),m_szJob(NULL)							/// Constructor
	{ m_pJobServer = 0; }

	~cDJS_WorkerThread();

	bool		SetJob( const char* szJobServerName, const char* szJob,const char* szWorkPath, const int nCPUID );							/// Set the initial parameters for the worker thread
	UINT		ThreadStart();																																					/// The thread
	virtual DWORD	Done();

	int			GetPercent()																																						/// Give back the percent of the work finished
	{
		EnterCS();
		int nPercent = m_nPercent;
		LeaveCS();
		return nPercent;
	}

	const char*		GetJobServerName() const																													/// Give back the jobserver name
	{
		return m_szJobServerName;
	}

	int						GetUsedMemoryMB() const																														/// Give back the used/allocated memory in Mbytes
	{
		return m_nUsedMemoryMB;
	}

private:

	void		SetPercent( int nPercent)																																/// Set the percent from the jobserver
	{
		EnterCS();
		m_nPercent = nPercent;
		LeaveCS();
	}

	int			m_nPercent;																																						/// Percentage of the finished work
	int			m_nUsedMemoryMB;																																			/// How much memory this worker use
	char*		m_szJobServerName;																																		/// Name of the jobserver
	char*		m_szJob;																																							/// The job itself
	char*		m_szWorkPath;																																					/// Path where job must be executed
	int			m_nCPUID;																																							/// The CPU / Thread ID
	struct IJobServer* m_pJobServer;
};

#endif//DJS_WORKERTHREAD_H