#include "stdafx.h"
#include "DJS_Client.h"
#include "../Common/Service/osr_service.h"
#include <tlhelp32.h>

extern void ReadIniFile();

/*
	WINDOWS SERVICE verion:
	Application for the desktop pcs - check if the explorer.exe is running (somebody logged on to the pc)
	don't do anything, but if logged off, it start the client...

	LINUX & Debug version:
	Running a simple console application.
*/

#define	DJS_SYSTEMCHECKTIME	60


	bool g_bRunFullMode = true;
	bool g_bForceRunFullMode = false;
    bool g_bRunTestMode = true;

#ifdef WINDOWS_VERSION
	#include <ntsecapi.h>
	#include "../Common/Zockets/net.h"
	int is_stoped = FALSE;

	typedef LONG	NTSTATUS;
	typedef LONG	KPRIORITY;

	typedef struct _CLIENT_ID {
		DWORD	    UniqueProcess;
		DWORD	    UniqueThread;
	} CLIENT_ID, * PCLIENT_ID;

	typedef struct _VM_COUNTERS {
		SIZE_T	    PeakVirtualSize;
		SIZE_T	    VirtualSize;
		ULONG	    PageFaultCount;
		SIZE_T	    PeakWorkingSetSize;
		SIZE_T	    WorkingSetSize;
		SIZE_T	    QuotaPeakPagedPoolUsage;
		SIZE_T	    QuotaPagedPoolUsage;
		SIZE_T	    QuotaPeakNonPagedPoolUsage;
		SIZE_T	    QuotaNonPagedPoolUsage;
		SIZE_T	    PagefileUsage;
		SIZE_T	    PeakPagefileUsage;
	} VM_COUNTERS;

	typedef struct _SYSTEM_THREAD_INFORMATION {
		LARGE_INTEGER   KernelTime;
		LARGE_INTEGER   UserTime;
		LARGE_INTEGER   CreateTime;
		ULONG			WaitTime;
		PVOID			StartAddress;
		CLIENT_ID	    ClientId;
		KPRIORITY	    Priority;
		KPRIORITY	    BasePriority;
		ULONG			ContextSwitchCount;
		LONG			State;
		LONG			WaitReason;
	} SYSTEM_THREAD_INFORMATION, * PSYSTEM_THREAD_INFORMATION;


	typedef struct _SYSTEM_PROCESS_INFORMATION {
		ULONG           NextEntryDelta;         // offset to the next entry
		ULONG           ThreadCount;            // number of threads
		ULONG           Reserved1[6];           // reserved
		LARGE_INTEGER   CreateTime;             // process creation time
		LARGE_INTEGER   UserTime;               // time spent in user mode
		LARGE_INTEGER   KernelTime;             // time spent in kernel mode
		UNICODE_STRING  ProcessName;            // process name
		KPRIORITY       BasePriority;           // base process priority
		ULONG           ProcessId;              // process identifier
		ULONG           InheritedFromProcessId; // parent process identifier
		ULONG           HandleCount;            // number of handles
		ULONG           Reserved2[2];           // reserved
		VM_COUNTERS     VmCounters;             // virtual memory counters
#if _WIN32_WINNT >= 0x500
		IO_COUNTERS     IoCounters;             // i/o counters
#endif
		SYSTEM_THREAD_INFORMATION Threads[1];   // threads
	} _SYSTEM_PROCESS_INFORMATION;

	typedef struct _SYSTEM_BASIC_INFORMATION
	{
		DWORD dwUnknown1;
		ULONG uKeMaximumIncrement;
		ULONG uPhysicalPageSize;
		ULONG uMmNumberOfPhysicalPages;
		ULONG uMmLowestPhysicalPage;
		ULONG uMmHighestPhysicalPage;
		ULONG uAllocationGranularity;
		PVOID pLowestUserAddress;
		PVOID pMmHighestUserAddress;
		ULONG uKeActiveProcessors;
		BYTE bKeNumberProcessors;
		BYTE bUnknown2;
		WORD wUnknown3;
	} _SYSTEM_BASIC_INFORMATION;


typedef LONG (WINAPI *PROCNTQSI)(UINT,PVOID,ULONG,PULONG);
PROCNTQSI NtQuerySystemInformation;

#define SYSTEMPROCESSESANDTHREADSINFORMATION 5
#define MAX_BUFFER_SIZE 1024*64
unsigned char pBuffer[MAX_BUFFER_SIZE];
DWORD dwPhisicalMemoryMB = 0;


BOOL IsLocalSid( PSID ps )
{
	static PSID pComparisonSid = NULL;

	if ( pComparisonSid == NULL )
	{
		// build "BUILTIN\LOCAL" SID for comparison: S-1-2-0
		SID_IDENTIFIER_AUTHORITY sia = SECURITY_LOCAL_SID_AUTHORITY;
		AllocateAndInitializeSid( &sia, 1, 0, 0, 0, 0, 0, 0, 0, 0, &pComparisonSid );

	}

	return EqualSid( ps, pComparisonSid );
}



BOOL IsInteractiveSid( PSID ps )
{
	static PSID pComparisonSid = NULL;

	if ( pComparisonSid == NULL )
	{
		// build "BUILTIN\LOCAL" SID for comparison: S-1-5-4
		SID_IDENTIFIER_AUTHORITY sia = SECURITY_NT_AUTHORITY; // "-5-"
		AllocateAndInitializeSid( &sia, 1, 4, 0, 0, 0, 0, 0, 0, 0, &pComparisonSid );
	}

	return EqualSid( ps, pComparisonSid );
}



BOOL IsLogonSid( PSID ps )
{
	static SID_IDENTIFIER_AUTHORITY sia = SECURITY_NT_AUTHORITY;

	// a logon SID has: sia = 5, subauth count = 3, first subauth = 5
	// the following three lines test these three conditions
	if ( ! memcmp( GetSidIdentifierAuthority( ps ), &sia, sizeof sia )	&& // is sia == 5?
		*GetSidSubAuthorityCount( ps ) == 3								&& // is subauth count == 3?
		*GetSidSubAuthority( ps, 0 ) == 5									)  // first subauth == 5?
		return TRUE;
	else
		return FALSE;
}



// nearly straight from the SDK
BOOL Sid2Text( PSID ps, char *buf, int bufSize )
{
	PSID_IDENTIFIER_AUTHORITY psia;
	DWORD dwSubAuthorities;
	DWORD dwSidRev = SID_REVISION;
	DWORD i;
	int n, size;
	char *p;

	// Validate the binary SID.

	if ( ! IsValidSid( ps ) )
		return FALSE;

	// Get the identifier authority value from the SID.

	psia = GetSidIdentifierAuthority( ps );

	// Get the number of subauthorities in the SID.

	dwSubAuthorities = *GetSidSubAuthorityCount( ps );

	// Compute the buffer length.
	// S-SID_REVISION- + IdentifierAuthority- + subauthorities- + NULL

	size = 15 + 12 + ( 12 * dwSubAuthorities ) + 1;

	// Check input buffer length.
	// If too small, indicate the proper size and set last error.

	if ( bufSize < size )
	{
		SetLastError( ERROR_INSUFFICIENT_BUFFER );
		return FALSE;
	}

	// Add 'S' prefix and revision number to the string.

	size = wsprintf( buf, "S-%lu-", dwSidRev );
	p = buf + size;

	// Add SID identifier authority to the string.

	if ( psia->Value[0] != 0 || psia->Value[1] != 0 )
	{
		n = wsprintf( p, "0x%02hx%02hx%02hx%02hx%02hx%02hx",
			(USHORT) psia->Value[0], (USHORT) psia->Value[1],
			(USHORT) psia->Value[2], (USHORT) psia->Value[3],
			(USHORT) psia->Value[4], (USHORT) psia->Value[5] );
		size += n;
		p += n;
	}
	else
	{
		n = wsprintf( p, "%lu", ( (ULONG) psia->Value[5] ) +
			( (ULONG) psia->Value[4] << 8 ) + ( (ULONG) psia->Value[3] << 16 ) +
			( (ULONG) psia->Value[2] << 24 ) );
		size += n;
		p += n;
	}

	// Add SID subauthorities to the string.

	for ( i = 0; i < dwSubAuthorities; ++ i )
	{
		n = wsprintf( p, "-%lu", *GetSidSubAuthority( ps, i ) );
		size += n;
		p += n;
	}

	return TRUE;
}

void showSid( PSID ps )
{
	char textSid[MAX_PATH], user[MAX_PATH], domain[MAX_PATH];
	DWORD sizeUser, sizeDomain;
	SID_NAME_USE snu;
	const char *t;
	const char *sep = "\\"; // separator for domain\user display

	Sid2Text( ps, textSid, sizeof textSid );
	printf( "%s ", textSid );

	sizeUser = sizeof user;
	sizeDomain = sizeof domain;
	if ( ! LookupAccountSid( NULL, ps, user, &sizeUser, domain, &sizeDomain, &snu ) )
	{
		DWORD rc = GetLastError();

		if ( IsLogonSid( ps ) )
			printf( "(interactive logon session SID)" );
		else
			printf( "[LAS() error: %lu]", rc );
		return;
	}

	switch ( snu )
	{
	case SidTypeUser:
		t = "user";
		break;
	case SidTypeGroup:
		t = "group";
		break;
	case SidTypeDomain:
		t = "domain";
		break;
	case SidTypeAlias:
		t = "alias";
		break;
	case SidTypeWellKnownGroup:
		t = "well-known group";
		break;
	case SidTypeDeletedAccount:
		t = "deleted";
		break;
	case SidTypeInvalid:
		t = "invalid";
		break;
	case SidTypeUnknown:
		t = "unknown";
		break;
	case SidTypeComputer:
		t = "computer";
		break;
	default:
		t = "*?unknown?*";
		break;
	}

	if ( domain[0] == '\0' || user[0] == '\0' )
		sep = "";

	printf( "\"%s%s%s\" (%s)", domain, sep, user, t );
}


//----------------------------------------------------------------------
// Try to find the running shell 
//----------------------------------------------------------------------
bool FindTheShell(char* szShellName )
{
	HANDLE hSnapshot = CreateToolhelp32Snapshot(TH32CS_SNAPALL,0);
	if (!hSnapshot) 
		return true;

	PROCESSENTRY32 PE;
	ZeroMemory(&PE, sizeof(PROCESSENTRY32) );
	PE.dwSize = sizeof( PROCESSENTRY32 );

	bool bFound = false;

	DWORD dwRet = Process32First(hSnapshot,&PE);
	while( dwRet )
	{		
		if( _stricmp( PE.szExeFile, "explorer.exe" ) == 0 )
		{
			bFound = true;
			break;
		}
		ZeroMemory( &PE,sizeof( PROCESSENTRY32 ) );
		PE.dwSize = sizeof( PROCESSENTRY32 );
		dwRet = Process32Next(hSnapshot,&PE);
	}
	CloseHandle(hSnapshot);
	return bFound;
}

#ifdef WINDOWS_SERCIVE_VERSION

CDistributedJobService_Client* pDJS = NULL;
double	dLastShellTime = 0;

int nSleepNumber = 0;
//----------------------------------------------------------------------
// A manager funciton - neccessary for windows services
//----------------------------------------------------------------------
void ManageDJS()
{
	if( !g_bRunFullMode && !g_bForceRunFullMode)
	{
		//sleep mode, check the shell
		{
			nSleepNumber++;
			Sleep(1000);
			//if( nSleepNumber > DJS_SYSTEMCHECKTIME )
			{
				double dTime = GetTime();

				//check the shell every 60 minutes..
        DWORD dwWait = DJS_SYSTEMCHECKTIME;
        if (g_bRunTestMode)
          dwWait = 2;
				//if( dTime - dLastShellTime > 2 )
				{
					dLastShellTime = dTime;

					BOOL bOut = FALSE;
					SystemParametersInfo( SPI_GETSCREENSAVERRUNNING,0,&bOut,0 );

					if (!bOut && FindTheShell("EXPLORER.EXE"))
					{
						if( pDJS )
						{
							pDJS->Done();
							delete pDJS;
							pDJS = NULL;
						}
					}
					else
					{
						if( NULL == pDJS )
						{
							pDJS = new CDistributedJobService_Client;
							if( 0 == pDJS->Init(true,dwPhisicalMemoryMB) )
							{
								delete pDJS;
								pDJS = NULL;
							}
						}
					}
				}
			}
		}
	}
	else
	{
		//full mode - start the client immediately
		if( NULL == pDJS )
		{
			pDJS = new CDistributedJobService_Client;
			if( -1 == pDJS->Init(true,dwPhisicalMemoryMB) )
			{
				delete pDJS;
				pDJS = NULL;
			}
		}
	}

	if( pDJS )
		pDJS->Run();
	else
		Sleep(5000);

	if (!Client_IsLoggedIn())
	{
		Sleep(5000);

		delete pDJS;
		pDJS = NULL;
	}
}


//----------------------------------------------------------------------
// Entry point
//----------------------------------------------------------------------
int _tmain(int argc, _TCHAR* argv[])
{
	ReadIniFile();
#ifndef EMULATION_ENABLED
#ifndef _DEBUG 
	OSR_SERVICE_PARAMS params;

	memset((void *)&params,0,sizeof(params));
	strcpy_s((char *)params.ServiceLogin, STR_CHAR32,"");
	strcpy_s((char *)params.ServicePassword, STR_CHAR32,"");
	strcpy_s((char *)params.ServiceName, STR_CHAR32,"DJS_CLIENT");
	strcpy_s((char *)params.ServiceNameDisplay, STR_CHAR32,"DJS_CLIENT"); 

	params.ServiceAcceptedCommands = SERVICE_ACCEPT_STOP|SERVICE_ACCEPT_SHUTDOWN;
	params.ServiceDesiredAccess = SERVICE_ALL_ACCESS;
	params.ServiceStartType = SERVICE_AUTO_START;

	if( argc > 1)
	{
		if(stricmp(argv[1],"install") == 0)
		{
			ServiceInstall(&params);
			exit(0);
		}
		else
			if(stricmp(argv[1],"uninstall") == 0)
			{
				ServiceUninstall(&params);
				exit(0);
			}
			else
				if(stricmp(argv[1],"start") != 0)
					exit(-1);

			printf("Client is running. don't close this window!\n");
	}
	else
			if(ServiceStart(&params) == OSR_SUCCESS)
				g_bRunFullMode = false;
			else
				exit(-1);		

  FILE* file = fopen("C:\\DJS_test", "r");
  if (file)
  {
    fclose(file);
    g_bRunTestMode = true;
  }

	if( freopen_s( &file, "DJS_Client.log", "w", stdout) != NULL )
		setvbuf( stdout, NULL, _IONBF, 1024 );
#endif
#endif
	is_stoped = FALSE;
	pDJS = NULL;

	HANDLE Handle = GetCurrentThread();
	SetThreadPriority(Handle,THREAD_PRIORITY_BELOW_NORMAL);
	CloseHandle( Handle );

	NtQuerySystemInformation = (PROCNTQSI)GetProcAddress( GetModuleHandle("ntdll"),"NtQuerySystemInformation" );
	if (!NtQuerySystemInformation)
		return -1;
	else
	{
		_SYSTEM_BASIC_INFORMATION SystemInfo;
		ULONG nSize;
		if( NO_ERROR != NtQuerySystemInformation(0, &SystemInfo, sizeof(SystemInfo), &nSize) )
			return false;

		dwPhisicalMemoryMB = (SystemInfo.uPhysicalPageSize * SystemInfo.uMmNumberOfPhysicalPages) / (1024*1024);

	}

	dLastShellTime = 0;

	while(! is_stoped)
	{
		ManageDJS();
	}

	if( pDJS )
	{
		pDJS->Done();
		delete pDJS;
		pDJS = NULL;
	}

	return 1;
}

int OSR_CALL OSR_APP_START(int step)
{
	OutputDebugString("Start request");
	return OSR_SERVICE_DONE;
}

int OSR_CALL OSR_APP_STOP(int step)
{

	OutputDebugString("Stop request");
	is_stoped = TRUE;
	return OSR_SERVICE_DONE;
}

int OSR_CALL OSR_APP_PAUSE(int step)
{
	OutputDebugString("Pause request");
	if(step < 10)
	{
		OutputDebugString("Pause pending");
		Sleep(1000);
		return OSR_SERVICE_WAIT;

	}
	OutputDebugString("Pause request");
	return OSR_SERVICE_DONE;
}

int OSR_CALL OSR_APP_CONTINUE(int step)
{
	OutputDebugString("Continue request");
	return OSR_SERVICE_DONE;
}

int OSR_CALL OSR_APP_SHUTDOWN(int step)
{
	OutputDebugString("Shutdown request");
	return OSR_SERVICE_DONE;
}

#else

//----------------------------------------------------------------------
// Windows debug version entry point
//----------------------------------------------------------------------
int _tmain(int argc, _TCHAR* argv[])
{
	ReadIniFile();
#ifndef _DEBUG
#ifndef EMULATION_ENABLED
	FILE* file;
	if( freopen_s( &file, "DJS_Client.log", "w", stdout) != NULL )
		setvbuf( stdout, NULL, _IONBF, 1024 );
#endif
#endif

	HANDLE Handle = GetCurrentThread();
	SetThreadPriority(Handle,THREAD_PRIORITY_BELOW_NORMAL);
	CloseHandle( Handle );

	NtQuerySystemInformation = (PROCNTQSI)GetProcAddress( GetModuleHandle("ntdll"),"NtQuerySystemInformation" );

	if( NtQuerySystemInformation )
	{
		_SYSTEM_BASIC_INFORMATION SystemInfo;
		ULONG nSize;
		if( NO_ERROR != NtQuerySystemInformation(0, &SystemInfo, sizeof(SystemInfo), &nSize) )
			return false;

		dwPhisicalMemoryMB = (SystemInfo.uPhysicalPageSize * SystemInfo.uMmNumberOfPhysicalPages) / (1024*1024);
	}
	else
		return -1;


	CDistributedJobService_Client DJS;
	if( 1 != DJS.Init(false,dwPhisicalMemoryMB) )
		return -1;
	for(;;)
		DJS.Run();
	DJS.Done();

	return 1;
}


int OSR_CALL OSR_APP_START(int step)
{
	return OSR_SERVICE_DONE;
}

int OSR_CALL OSR_APP_STOP(int step)
{
	return OSR_SERVICE_DONE;
}

int OSR_CALL OSR_APP_PAUSE(int step)
{
	return OSR_SERVICE_DONE;
}

int OSR_CALL OSR_APP_CONTINUE(int step)
{
	return OSR_SERVICE_DONE;
}

int OSR_CALL OSR_APP_SHUTDOWN(int step)
{
	return OSR_SERVICE_DONE;
}
#endif

#else

//----------------------------------------------------------------------
// Linux version entry point
//----------------------------------------------------------------------
int _tmain(int argc, _TCHAR* argv[])
{
	ReadIniFile();
	CDistributedJobService_Client DJS;
	if( 1 != DJS.Init(false,1024) )
		return -1;
	for(;;)
		DJS.Run();
	DJS.Done();

	return 1;
}


int OSR_CALL OSR_APP_START(int step)
{
	return OSR_SERVICE_DONE;
}

int OSR_CALL OSR_APP_STOP(int step)
{
	return OSR_SERVICE_DONE;
}

int OSR_CALL OSR_APP_PAUSE(int step)
{
	return OSR_SERVICE_DONE;
}

int OSR_CALL OSR_APP_CONTINUE(int step)
{
	return OSR_SERVICE_DONE;
}

int OSR_CALL OSR_APP_SHUTDOWN(int step)
{
	return OSR_SERVICE_DONE;
}

#endif
