// Renderer.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "..\Common\IJobServer.h"
#include "Renderer.h"

#ifdef _MANAGED
#pragma managed(push, off)
#endif

//Based on the different requirements from the Linux & Windows (even when logged off) version here is the first part of the directories
#define LINUX_DIRECTORY	"./data/"
#define WINDOWS_DIRECTORY "\\\\DJS_SERVER\\DJS\\RAM\\"


#ifdef WIN32

BOOL APIENTRY DllMain( HMODULE hModule,
											DWORD  ul_reason_for_call,
											LPVOID lpReserved
											)
{
	return TRUE;
}
#endif //WIN32

//------------------------------------------------------------------------------------------------------------------
// Copy file function
//------------------------------------------------------------------------------------------------------------------
int CopyFile( const char* szSource, const char* szDestination )
{
	if( NULL == szSource || NULL == szDestination )
		return -1;

	char szCommand[1024];

	strcpy_s( szCommand, 1024, "copy ");
	strcat_s( szCommand, 1024, szSource );
	strcat_s( szCommand, 1024, " " );
	strcat_s( szCommand, 1024, szDestination );
	strcat_s( szCommand, 1024, " /Y" );

	return system( szCommand );
}


class CRendererJobServer : public IJobServer
{
public:
	CRendererJobServer( JobServerPlatform ePlatform ):m_ePlatform(ePlatform)
	{}

	virtual JobServerResult Init( const char* sJob,const char *sWorkPath )
	{
		if( 0 == strlen( sJob ) )
		{
			Renderer.Log("RAMJobServer: Job is a NULL string\n" );
			return JSRESULT_DATA_ERROR;
		}


		char szDirectory[1024];
		//generate datas from job
		memset( szDirectory,0,sizeof(char)*1024 );
		if( m_ePlatform == JSP_WINDOWS )
			strcpy_s( szDirectory, 1024, WINDOWS_DIRECTORY );
		else
			strcpy_s( szDirectory, 1024, LINUX_DIRECTORY );

		const char* pDirectoryStartpos = strstr( sJob, "\"" );
		if( NULL == pDirectoryStartpos )
		{
			Renderer.Log("RAMJobServer: Job (%s) haven't got a directory start pos.\n", sJob );
			return JSRESULT_DATA_ERROR;
		}
		++pDirectoryStartpos;

		const char* pDirectoryEndpos = strstr( pDirectoryStartpos, "\"" );

		if( NULL == pDirectoryEndpos )
		{
			Renderer.Log("RAMJobServer: Job (%s) haven't got a directory end pos.\n", sJob );
			return JSRESULT_DATA_ERROR;
		}

		if( pDirectoryStartpos == pDirectoryEndpos )
		{
			Renderer.Log("RAMJobServer: Job (%s) haven't got a directory.\n", sJob );
			return JSRESULT_DATA_ERROR;
		}

		//copy the directory
		char *pTemp2 = &szDirectory[ strlen(szDirectory) ];
		for( const char* pTemp = pDirectoryStartpos;  pTemp != pDirectoryEndpos; ++pTemp, ++pTemp2 )
			*pTemp2 = *pTemp;

		if( m_ePlatform == JSP_WINDOWS )
			*pTemp2 = '\\';
		else
			*pTemp2 = '/';

		pTemp2++;
		*pTemp2 = 0;

		//get the file id
		++pDirectoryEndpos;

/*
		if( m_ePlatform == JSP_WINDOWS )
		{
			char szFileName[1024];
			sprintf_s( szFileName, MAX_PATH, "%s\\octree.dat", szDirectory );
			CopyFile( szFileName, "c:\\octree.dat" );
		}
*/
		int iFileID = atoi( pDirectoryEndpos );
		if (errno == ERANGE)
		{
			Renderer.Log("RAMJobServer: Job (%s) haven't got a FileID.\n", sJob );
			return JSRESULT_DATA_ERROR;
		}

		return Renderer.Init( szDirectory, iFileID, 6,6,5, 0, 0);
	}
	virtual JobServerResult Tick()
	{
		return Renderer.Tick();
	}
	virtual JobServerResult Done()
	{
		Renderer.Done();
		return JSRESULT_OK;
	}

	virtual int GetUsedMemoryMB()
	{
		return Renderer.GetUsedMemoryMB();
	}

	virtual int GetPercent()
	{
		return Renderer.GetPercent();
	}

protected:
	cRenderer							Renderer;						//the renderer
	JobServerPlatform			m_ePlatform;				//Running platform
};


extern "C"
{
	JOBSERVER_API void DeleteJobServer( IJobServer* pJobServer )
	{
		if( pJobServer )
		{
			delete pJobServer;
		}
	}
	JOBSERVER_API IJobServer* CreateJobServer( int nThreadID, JobServerPlatform ePlatform, const int nIJobServerVersion )
	{
		if( IJOBSERVERVERSION != nIJobServerVersion )
			return NULL;

		return new CRendererJobServer(ePlatform);
	}

	JOBSERVER_API void GetJobServerInfo( SJobServerInfo* pInfo )
	{
		if( pInfo )
		{
			pInfo->m_nMaxThread = 4;
//			pInfo->m_nMinMemoryPerThread = 1024*1024*512;
		}
	}

};
#ifdef _MANAGED
#pragma managed(pop)
#endif

