#include "stdafx.h"
#include "JobQuelleManager.h"

extern void Log( const char* szFormat,... );

void CJobQuelle::InsertJob( CommandInfo& Command  )
{
	m_Jobs.push_back( Command );
}

void CJobQuelle::JobFinished( CommandInfo& Command)
{
	std::vector<CommandInfo>::iterator it, itEnd = m_PendingJobs.end();
	for(it = m_PendingJobs.begin(); it != itEnd; ++it )
	{
		if( it->guid == Command.guid )
			break;
	}

	//it's a false job, not care about it..
	if( it == m_PendingJobs.end() )
		return;

	//remove form the pending list
	m_PendingJobs.erase( it );

	//if not success send it again to the clients
	if (false == Command.success || false == Command.done)
	{
		InsertJob( Command );
		SortJobs();
	}
	else
	{
		//check the WAIT_SIGNAL(s) in the job in that case..
		if( m_PendingJobs.empty() )
		{
			bool bCheckAgain = true;
			while( bCheckAgain )
			{
				bCheckAgain = false;
				if( !m_Jobs.empty() )
				{
					if( 0 == _stricmp( m_Jobs[0].command.str, "RPC_WAITSIGNAL" ) )
					{
						m_Jobs.erase( m_Jobs.begin() );
						bCheckAgain = true;
					}
				}
			}
		}
	}
}

bool CJobQuelle::GetTheNextJobToSent( CommandInfo** pInfo,bool bGetPending )
{
	if (bGetPending)
	{
		static int nIntCounter = 0;
		if (m_PendingJobs.empty())
			return false;

		*pInfo = &m_PendingJobs[ nIntCounter % m_PendingJobs.size() ]; // get next one from pending.
		nIntCounter++;
		return true;
	}
	if( NULL == pInfo )
		return false;
	if( m_Jobs.empty() )
		return false;
	if( 0 == _stricmp( m_Jobs[0].command.str, "RPC_WAITSIGNAL" ) )
		return false;

	//manage it..
	m_PendingJobs.push_back( m_Jobs[0] );
	*pInfo = &m_PendingJobs[ m_PendingJobs.size()-1 ];
	m_Jobs.erase( m_Jobs.begin() );
	return true;
}

bool CJobQuelle::IsEmpty() const
{
	return m_Jobs.empty() && m_PendingJobs.empty();
}

void CJobQuelle::SortJobs()
{
	std::sort( m_Jobs.begin(), m_Jobs.end(), CJobQuelle::CompareJobs() );
}

int CJobQuelle::GetPendingJobNumber() const
{
	return (int)m_PendingJobs.size();
}

int CJobQuelle::GetLeftJobNumber() const
{
	return (int)m_Jobs.size();
}


void CJobQuelleManager::InsertNotRegisteredJob( const FixedString* pCommand )
{
	if( NULL == pCommand )
		return;

	//setup a default commandinfo
	CommandInfo CI;
	CI.done = false;
	CI.success = false;
	CI.iClient = -1;
	CI.timeStart = 0;
	CI.command.set( pCommand );
	CI.guid = m_GUID++;

	Log( "Job Added: %s",pCommand->str );

	//search a quelle for that commander
	std::vector<CJobQuelle>::iterator it, itEnd = m_Quelles.end();
	for( it = m_Quelles.begin(); it != itEnd; ++it )
	{
		if( it->GetCommanderGUID() == pCommand->CommanderGUID )
			break;
	}	

	if( it == m_Quelles.end() )
	{
		CJobQuelle NewQuelle;
		NewQuelle.SetCommanderGUID(  pCommand->CommanderGUID );
		NewQuelle.SetPriority( pCommand->Priority );
		m_Quelles.push_back( NewQuelle );

		m_Quelles[ m_Quelles.size()-1 ].InsertJob( CI );
		SortQuelles();
	}
	else	
		it->InsertJob( CI );
}

void CJobQuelleManager::JobFinished( CommandInfo &Command )
{
	//first: search the quelle..
	std::vector<CJobQuelle>::iterator it,itEnd = m_Quelles.end();
	for( it = m_Quelles.begin(); it != itEnd; ++it )
	{
		if( it->GetCommanderGUID() == Command.command.CommanderGUID )
			break;
	}	

	//something wrong.. no more quelle (it can happend when the server restarted...)
	if( it == m_Quelles.end() )
		return;

	it->JobFinished( Command );

	//if empty i can erase it...
	if( it->IsEmpty() )
		m_Quelles.erase( it );
}

bool CJobQuelleManager::GetTheNextJobToSent( CommandInfo** pInfo,bool bGetPending )
{
	//automatic handling of the priority (because of the sort)
	std::vector<CJobQuelle>::iterator itEnd = m_Quelles.end();
	for( std::vector<CJobQuelle>::iterator it = m_Quelles.begin(); it != itEnd; ++it )
	{
		if( it->GetTheNextJobToSent( pInfo,bGetPending ) )
			return true;
	}

	return false;
}

void CJobQuelleManager::ClearAllJob()
{
	//cleare everything
	m_Quelles.erase( m_Quelles.begin(), m_Quelles.end() );
}

int CJobQuelleManager::GetPendingJobNumber() const
{
	int nPendingJobNumber = 0;
	std::vector<CJobQuelle>::const_iterator itEnd = m_Quelles.end();
	for( std::vector<CJobQuelle>::const_iterator it = m_Quelles.begin(); it != itEnd; ++it )
	{
		nPendingJobNumber += it->GetPendingJobNumber();
	}

	return nPendingJobNumber;
}

int CJobQuelleManager::GetLeftJobNumber() const
{
	int nJobNumber = 0;
	std::vector<CJobQuelle>::const_iterator itEnd = m_Quelles.end();
	for( std::vector<CJobQuelle>::const_iterator it = m_Quelles.begin(); it != itEnd; ++it )
	{
		nJobNumber += it->GetLeftJobNumber();
	}

	return nJobNumber;
}

void CJobQuelleManager::SortQuelles()
{
	std::sort( m_Quelles.begin(), m_Quelles.end(), CJobQuelleManager::CompareQuelles() );
}


