// DJS_ExecJobServer.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "..\Common\IJobServer.h"
#include <time.h>
#include <math.h>

#define MAX_TASK_RUNNING_TIME_IN_SECONDS (2*60*60) // Max 2 hours per task

#ifdef _MANAGED
#pragma managed(push, off)
#endif

#ifdef WIN32

BOOL APIENTRY DllMain( HMODULE hModule,
											DWORD  ul_reason_for_call,
											LPVOID lpReserved
											)
{
	return TRUE;
}
#endif //WIN32

//////////////////////////////////////////////////////////////////////////
void Log( const char* szFormat,...)
{
	FILE *f;
	fopen_s( &f, "C:\\DJS_CLIENT\\DJS_ShaderJobServer.log", "at" );
	if( f )
	{
		char timestr[32];
		_strtime_s( timestr,sizeof(timestr) );

		char datestr[128];
		_strdate_s( datestr,sizeof(datestr) );

		va_list arglist;
		va_start(arglist, szFormat);
		char szBuf[1024];
		vsprintf_s( szBuf, 1024, szFormat, arglist);
		fprintf_s( f, "[%s][%s] %s\n",datestr,timestr,szBuf );
		fclose(f);
	}
}

//------------------------------------------------------------------------------------------------------------------
// Copy files and directories function
//------------------------------------------------------------------------------------------------------------------
int XCopy( const char* szSource, const char* szDestination, const bool bRecursive, const bool bKeepAttributes, const bool bCopyHiddenFile, const bool bOnlyNewFiles, const bool bOneFile, const char *szExclude )
{
	if( NULL == szSource || NULL == szDestination )
		return -1;

	char szCommand[1024];

	strcpy_s( szCommand, 1024, "xcopy ");
	strcat_s( szCommand, 1024, szSource );
	strcat_s( szCommand, 1024, " " );
	strcat_s( szCommand, 1024, szDestination );
	strcat_s( szCommand, 1024, " /Y /C /R" );
	if( !bOneFile )
		strcat_s( szCommand, 1024, " /I" );
	if( szExclude )
	{
		strcat_s( szCommand, 1024, " /exclude:" );
		strcat_s( szCommand, 1024, szExclude );
	}
	if( bRecursive )
		strcat_s( szCommand, 1024, " /E" );
	if( bKeepAttributes )
		strcat_s( szCommand, 1024, " /K" );

	if( bCopyHiddenFile )
		strcat_s( szCommand, 1024, " /H" );
	if( bOnlyNewFiles )
		strcat_s( szCommand, 1024, " /D" );

	Log( szCommand );
	int nResult = system( szCommand );
	if (nResult != 0)
	{
		Log( "<ERROR> ",szCommand );
	}
	return nResult;
}

//------------------------------------------------------------------------------------------------------------------
// Copy files and directories function
//------------------------------------------------------------------------------------------------------------------
int RoboCopy( const char* szSource, const char* szDestination,const char *szExclude=0 )
{
	if( NULL == szSource || NULL == szDestination )
		return -1;

	char szCommand[1024];

	strcpy_s( szCommand, 1024, "c:\\DJS_CLIENT\\robocopy ");
	strcat_s( szCommand, 1024, szSource );
	strcat_s( szCommand, 1024, " " );
	strcat_s( szCommand, 1024, szDestination );
	strcat_s( szCommand, 1024, " /MIR" ); // Mirror mode.
	strcat_s( szCommand, 1024, " /R:3" ); // Retry at max 10 times.
	strcat_s( szCommand, 1024, " /TEE" ); // Log to console
	strcat_s( szCommand, 1024, " /LOG:c:\\DJS_CLIENT\\robocopy.log" ); // Log to file
	strcat_s( szCommand, 1024, " /E" ); // recursive

	if (szExclude)
	{
		strcat_s( szCommand, 1024, " /XF " ); // Exclude some files
		strcat_s( szCommand, 1024, szExclude );
	}

	Log( szCommand );
	int nResult = system( szCommand );
	int nError = (nResult >= 8) ? 1 : 0; // Filter out not important errors.
	if (nResult == -1)
		nError = nResult;
	if (nError != 0)
	{
		Log( "<Error in RoboCopy %d> %s",nResult,szCommand );
	}
	return nError;
}

//------------------------------------------------------------------------------------------------------------------
// Copy file function
//------------------------------------------------------------------------------------------------------------------
int CopyFile( const char* szSource, const char* szDestination )
{
	if( NULL == szSource || NULL == szDestination )
		return -1;

	char szCommand[1024];

	strcpy_s( szCommand, 1024, "copy ");
	strcat_s( szCommand, 1024, szSource );
	strcat_s( szCommand, 1024, " " );
	strcat_s( szCommand, 1024, szDestination );
	strcat_s( szCommand, 1024, " /Y" );

	Log( szCommand );
	int nResult = system( szCommand );
	if (nResult != 0)
	{
		Log( "  <ERROR> ",szCommand );
	}
	return nResult;
}

//------------------------------------------------------------------------------------------------------------------
// del function
//------------------------------------------------------------------------------------------------------------------
int XDel( const char* szFiles, const bool bRecursive,bool bDelDirectories=false )
{
	if( NULL == szFiles )
		return -1;

	char szCommand[1024];

	strcpy_s( szCommand, 1024, "del ");
	strcat_s( szCommand, 1024, szFiles );
	if( bRecursive )
		strcat_s( szCommand, 1024, " /S" );
	strcat_s( szCommand, 1024, " /Q /F" );		//quiet mode, read-only file too...

	Log( szCommand );
	int nResult = system( szCommand );
	if (nResult != 0)
	{
		Log( "<ERROR> ",szCommand );
	}
	if (bDelDirectories)
	{
		strcpy_s( szCommand, 1024, "rmdir ");
		strcat_s( szCommand, 1024, szFiles );
		strcat_s( szCommand, 1024, " /S" );
		strcat_s( szCommand, 1024, " /Q" );
		Log( szCommand );
		int nRes2 = system( szCommand );
		if (nRes2 != 0)
			return nRes2;
	}

	return nResult;
}

//////////////////////////////////////////////////////////////////////////
int MakeDir( const char* szFolder )
{
	if( NULL == szFolder)
		return -1;

	char szCommand[1024];

	strcpy_s( szCommand, 1024, "mkdir ");
	strcat_s( szCommand, 1024, szFolder );

	Log( szCommand );
	int nResult = system( szCommand );
	if (nResult != 0)
	{
		Log( "<ERROR> ",szCommand );
	}
	return nResult;
}

class CExecJobServer : public IJobServer
{
public:
	time_t m_startTime;
	int m_nCPU;
	char spc_path[_MAX_PATH];
	SHELLEXECUTEINFOA ExecInfo;
	HANDLE m_hProcess;
	DWORD  m_processId;

	CExecJobServer( int nCPUId )
	{
		m_hProcess = 0;
		m_processId = 0;
		m_nCPU = nCPUId;
		ZeroMemory(&ExecInfo,sizeof(ExecInfo));
	}
	~CExecJobServer()
	{
		TerminateEditor();
	}
	void TerminateEditor()
	{
		if (m_hProcess)
		{
			HANDLE hProc = OpenProcess(PROCESS_TERMINATE,FALSE,m_processId);
			if (hProc)
			{
				TerminateProcess(hProc,1);
				CloseHandle(hProc);
			}
			CloseHandle(m_hProcess);
			m_hProcess = 0;
			m_processId = 0;
		}
	}

	const char* CombinePath( const char *path1,const char *path2 )
	{
		static char temp[_MAX_PATH];
		strcpy(temp,path1);
		strcat(temp,path2);
		return temp;
	}
	const char* SPC_PATH( const char *path )
	{
		static char temp[_MAX_PATH];
		strcpy(temp,spc_path);
		strcat(temp,path);
		return temp;
	}
	const char* REMOTE_TEMP_PATH( const char *path )
	{
		static char temp[_MAX_PATH];
		sprintf_s( temp, sizeof(temp), "%s\\Temp\\%03d\\", m_sDir, m_iFileID,path );
		return temp;
	}

	virtual JobServerResult Init( const char* sJob,const char *sWorkPath )
	{
		Log("");
		Log("");
		Log("----------------------------------------------------------------------");
    Log("INIT: '%s", sJob);

		sprintf_s( spc_path,"%s\\SPC_CPU%d\\",sWorkPath,m_nCPU );

		ZeroMemory(&ExecInfo,sizeof(ExecInfo));
		ExecInfo.cbSize = sizeof(ExecInfo);
		ExecInfo.hwnd = NULL;

		strcpy_s( m_sText, 1024, sJob );
		m_sDir = m_sText;
		char *sFileID = strchr( m_sText, ' ' );
		if( sFileID )
			*sFileID++ = 0;

    m_iFileID = atoi( sFileID );
		if (errno == ERANGE)
		{
			Log( "<ERROR> Invalid Job request: %s",sJob );
			return JSRESULT_INTERNAL_ERROR;
		}

		// copy the new build...
		char szFullPath[1024];
		sprintf_s( szFullPath, 1024, "%s\\SPC\\", m_sDir );
    Log("Copy path: '%s' -> '%s'", szFullPath, SPC_PATH("*.*") );
	  if (0 != RoboCopy( szFullPath, SPC_PATH("") ) )
		{
			return JSRESULT_INTERNAL_ERROR;
		}
		
	  //del the shader cache
	  if (-1 == XDel(SPC_PATH("game\\shaders\\cache\\*.*"), true))
		{
			return JSRESULT_INTERNAL_ERROR;
		}

		// Make cache folder.
		MakeDir( SPC_PATH("game\\shaders\\cache") );

    //copy the shader list file...
    sprintf_s( szFullPath, 1024, "%s\\Temp\\ShaderList_%03d.txt", m_sDir, m_iFileID );
    if (0 != CopyFile( szFullPath,SPC_PATH("game\\shaders\\cache\\ShaderList.txt")  ) )
		{
			return JSRESULT_INTERNAL_ERROR;
		}
		m_startTime = time(&m_startTime);

		STARTUPINFOA sinfo;
		PROCESS_INFORMATION procInfo;
		memset( &procInfo,0,sizeof(procInfo) );
		memset( &sinfo,0,sizeof(sinfo) );

		char sExe[1024];
		char sCommandLine[1024];
		strcpy_s( sExe,SPC_PATH("Bin32\\Editor.exe") );
		strcpy_s( sCommandLine,SPC_PATH("Bin32\\Editor.exe /PrecacheShaderList") );

		Log( "Starting shader precaching" );
		//Log( "%s %s",sExe,sCommandLine );
		Log( "%s",sCommandLine );

		int nFlags = 0;
		if (!CreateProcessA( NULL,sCommandLine,NULL,NULL,TRUE,nFlags,NULL,NULL,&sinfo,&procInfo ))
		{
			Log( "<ERROR> Failed to create Editor process" );
			return JSRESULT_INTERNAL_ERROR;
		}
		m_processId = procInfo.dwProcessId;
		m_hProcess = procInfo.hProcess;

		return JSRESULT_OK;
	}

	virtual JobServerResult Tick()
	{
		DWORD dwExitCode = 0;
		GetExitCodeProcess( m_hProcess,&dwExitCode );
		if (dwExitCode == STILL_ACTIVE)
		{
			time_t currTime;
			currTime = time(&currTime);

			double upTime = fabs(difftime(currTime,m_startTime));
			if (upTime > MAX_TASK_RUNNING_TIME_IN_SECONDS)
			{
				int minutes = upTime / 60;
				Log( "<ERROR> Task running longer then %d minutes, abort the task assumes it hanged",minutes );
				//////////////////////////////////////////////////////////////////////////
				// Terminate editor process.
				TerminateEditor();
				return JSRESULT_INTERNAL_ERROR;
			}

			Sleep(100);
			return JSRESULT_OK;
		}

		FILE *FP = 0;
    fopen_s( &FP,SPC_PATH("game\\shaders\\cache\\ShaderListDone"), "r");
    if (!FP)
		{
			Log( "<ERROR> ShaderListDone file was not created",dwExitCode );
			return JSRESULT_INTERNAL_ERROR;
		}
		fclose(FP);

		Log( "Shader Precaching Successed" );

		//////////////////////////////////////////////////////////////////////////
		//copy back the result
		//////////////////////////////////////////////////////////////////////////
		char szFullPath[1024];
  
		XDel( REMOTE_TEMP_PATH(""), true);

		if (0 != RoboCopy( SPC_PATH("game\\shaders\\cache"), REMOTE_TEMP_PATH(""),"*.cf*" ))
		{
			return JSRESULT_INTERNAL_ERROR;
		}

		char szSrcShaderList[1024];
		sprintf_s( szSrcShaderList, 1024, "%s\\Temp\\ShaderList_%03d.txt", m_sDir, m_iFileID );

		if (0 != CopyFile( szSrcShaderList,REMOTE_TEMP_PATH("") ) )
		{
			//return JSRESULT_INTERNAL_ERROR;
		}
		if (0 != CopyFile( SPC_PATH("Editor.log"),REMOTE_TEMP_PATH("")  ) )
		{
			//return JSRESULT_INTERNAL_ERROR;
		}

		Log( "Shader precaching job finished successfully" );

		return JSRESULT_FINISHED;
	}

	virtual JobServerResult Done()
	{
		// Force termination of the Editor.exe if it is still running
		TerminateEditor();

		return JSRESULT_OK;
	}

	virtual int GetUsedMemoryMB()
	{
		return 300;				//Sandbox using a big chunk of memory
	}

	virtual int GetPercent()
	{
		return 0;
	}

protected:
	char			m_sText[1024];
	char*			m_sDir;
	int				m_iFileID;
};


extern "C"
{
	JOBSERVER_API void DeleteJobServer( IJobServer* pJobServer )
	{
		if( pJobServer )
			delete pJobServer;
	}

	JOBSERVER_API IJobServer* CreateJobServer( int nThreadID, JobServerPlatform ePlatform, const int nIJobServerVersion )
	{
		if(ePlatform != JSP_WINDOWS || IJOBSERVERVERSION != nIJobServerVersion )
			return NULL;

		return new CExecJobServer(nThreadID);
	}

	JOBSERVER_API void GetJobServerInfo( SJobServerInfo* pInfo )
	{
		if( pInfo )
		{
			pInfo->m_bExclusiveMode = false;
			pInfo->m_nMaxThread = 8;
//			pInfo->m_nMinMemoryPerThread = 0;
		}
	}
};

#ifdef _MANAGED
#pragma managed(pop)
#endif

