#!/usr/bin/perl

#*************************************************************************
#Crytek Source File.
#Copyright (C), Crytek Studios, 2001-2007.
#-------------------------------------------------------------------------
#$Id$
#$DateTime$
#Description: Export a twiki page to Doc-O-Matic dtx topic file
#
#-------------------------------------------------------------------------
#History:
#- 07:03:2007: Created by Mathieu Pinard
#
#************************************************************************/ 

sub ConvertTwikiFile
{
	my $filename = shift;
	
	my $outfilename = $filename;
	$outfilename =~ s/\.txt$/\.dtx/;
	
	$filename =~ /\/([\w]+)\.txt$/;
	$topicname = $1;
	
	my $titlename = 0;
	my $isinsidetable = 0;
	
	print STDOUT $filename." --> ".$outfilename."\n";
	
	open(IN, $filename) || die "open: $!";
	open(OUT, ">$outfilename") || die "open: $!";
	
	print OUT "@@ ".$topicname."\n";
	
	my $numberedlist = 1;
	
	# process every line of the twiki file
	while ($line = <IN>)
	{
		while ($line =~ s/%ATTACHURLPATH%/$topicname/) {};
		
		while ($line =~ /<img(.*?)>/)
		{
			$imagetag = $1;
			if ($imagetag =~ /src=\"(.*?)\"/)
			{
				my $imagefilename = $1;
				$imagefilename =~ s/\//\_/;
				print OUT "<image ".$imagefilename.">";
				$line =~ s/<img(.*?)>//;
			}
		}
		
		# convert the bold text
		while ($line =~ s/(\*)([0-9a-zA-Z()'\[\]_\ \!\?]+)(\*)/<B>$2<\/B>/) {};
		
		# strip the twiki file header
		$line =~ s {^\%.*?\%} []gsx;
		
		# ignore when the text is requested to not create automatic links (todo)
		while ($line =~ s/!([\w]+)/$1/) {};
  	
  	# detect the topic headers
		if ($line =~ /\-\-\-[\+]+[\!]?/) 
		{
			if (not $titlename)
			{
				$line =~ /\-\-\-[\+]+[\!]?([0-9a-zA-Z()'\[\]_\ \!\+]+)/;
				$titlename = $1;
				print OUT "<TITLE ".$1.">\n";
			}
			
			$line =~ s/\-\-\-[\+]+[\!]?/*/;
			$line =~ s/\n/ *\n/;
  	}
	
		# convert the bold code text
		while ($line =~ s/(==)([0-9a-zA-Z()'!\[\]_\+]+)(==)\ /<C><B>$2<\/B><\/C>/) {};
	
		# convert the code text
		while ($line =~ s/(=)([0-9a-zA-Z()'\[\]_\ \!\+\\\/]+)(=)/<C>$2<\/C>/) {};
	
		# convert the bold+italic text
		while ($line =~ s/(\_\_)([0-9a-zA-Z()\'_\+]+)(\_\_)/<B><I>$2<\/I><\/B>/) {};
	
		# convert the italic text
		while ($line =~ s/(\_)([0-9a-zA-Z()\'_\+]+)(\_)/<I>$2<\/I>/) {};
	
		# convert the bold text
		while ($line =~ s/<verbatim>/<code>/) {};
		while ($line =~ s/<\/verbatim>/<\/code>/) {};

  	# convert the a separator
		while ($line =~ s/---[-]?//) {};
		
		# convert numbered lists
		if ($line =~ /^   1. /)
		{
			$line =~ s/^   1. /   $numberedlist. /;
			$numberedlist = $numberedlist + 1;
		}
		else
		{
			$numberedlist = 1;
		}
		
		#detect tables
		if ($line =~ /^\|/)
		{
			if (not $isInsideTable)
			{
				$isInsideTable = 1;
				print OUT "<TABLE>\n";
			}
			
			$line =~ s/^\|[\t\ ]?//;
			#$line =~ s/[\t\ ]?\|[\t\ ]?$/<\/td><\/tr>/;
			print OUT "<tr>";
			
			while ($line =~ s/([0-9a-zA-Z()<>\'\-_\.\t\ ;:,\\\/\?]+)\|//)
			{
				print OUT "<td>".$1."<\/td>"
			}
			
			print OUT $line."<\/tr>";
			
			#$line = "";
			
		}
		else
		{
			if ($isInsideTable)
			{
				print OUT "</TABLE>\n";
				$isInsideTable = 0;
			}
		}
     
  	# now we got our line ready for Doc-O-Matic
  	print OUT $line;
	}
	
	close(OUT) || die "close: $!";
	close(IN) || die "close: $!";
	
	$isInsideTable = 0;
}

sub ProcessDirectory
{
	my $directory = shift;
	
	use Fcntl ':mode';
	use File::stat;
	use DirHandle;
	
  my $dir = new DirHandle $directory;
  if (not $dir)
  {
  	return;
	}
	
	while (my $filename = $dir->read)
	{
		if ($filename =~ /.txt$/)
	  {
	  	my $path = $directory."/".$filename;
	  	ConvertTwikiFile($path);
	  }
	  else
	  {
	  	my $fs = stat($directory."/".$filename);
			if ($fs and S_ISDIR($fs->mode) and not $filename =~ /^\./)
			{
				ProcessDirectory($directory."/".$filename);
			}
		}
	}
	
	$dir->close;
}


my $PathToConvert;

if ($#ARGV > -1)
{
	$PathToConvert = $ARGV[0]; 
}
else
{
	$PathToConvert = ".";
}

ProcessDirectory($PathToConvert);
