#!/usr/bin/perl

#*************************************************************************
#Crytek Source File.
#Copyright (C), Crytek Studios, 2001-2007.
#-------------------------------------------------------------------------
#$Id$
#$DateTime$
#Description: Update the Doc-O-Matic documentation with twiki content
#
#-------------------------------------------------------------------------
#History:
#- 07:03:2007: Created by Mathieu Pinard
#
#************************************************************************/ 
$TwikiPath = "\\\\server41\\http\\twiki\\";
$TwikiLocalPath = "..\\Twiki\\";

#use ToolsConfig qw($TwikiLocalPath $TwikiPath PrepareDirectory);
use IO::File;
use File::Copy;
use File::Path;
use File::stat;

@tableHeaderSizes = ();
@table = ();

$thumbnailWidthSize = 400;
$thumbnailHeightSize = 300;


@allowedAttachmentType = (".max", ".bip", ".psd", ".tif", ".lyr", ".txt", ".lay", ".sft", ".grp", ".veg", ".mpg", ".seq", ".cgf",".cga",".chr", ".mtl", ".tod", ".xml", ".avi", ".wmv" );

#-------------------------------------------------------------------------
sub PrepareDirectory
{
	use File::Path;
	my $filename = shift;
	
	$filename =~ s/(..\\)//;
	my $path = "../";
	
	while ($filename =~ s/([\w.]+)\\//)
	{
		my $subdir = $1;
		$path = $path."/".$subdir;
		
		mkpath $path;
	}
}

#-------------------------------------------------------------------------
sub IsThumbnailNeeded
{
	my $filename = shift;
	
	my $imageVerbose = `identify $filename -verbose`;
	
	#print STDOUT "iv <$filename> <$imageVerbose>\n";
	
	if ($imageVerbose)
	{
		$imageVerbose =~ /[\s]+([\d]+)x([\d]+)[\s]+/;
		my $width = $1;
		my $height = $2;
		
		#print STDOUT "image: width=$width, height=$height\n";

		if ($width > $thumbnailWidthSize and $height > $thumbnailHeightSize)
		{
			return 1;
		}
	}
	
	return 0;
}

#-------------------------------------------------------------------------
sub ScanForWarnings
{
	$line = shift;
	
	if ($line =~ /(^|\s|\W)Far[\s]?Cry($|\s|\W)/i)
	{
		print STDOUT "FC warning: ".$line."\n";
	}
	
	if ($line =~ /(^|\s|\W)half[\-]?life($|\s|\W)/i)
	{
		print STDOUT "competitor warning: ".$line."\n";
	}
	
	if ($line =~ /(^|\s|\W)DOOM($|\s|\W)/i)
	{
		print STDOUT "competitor warning: ".$line."\n";
	}
	
	if ($line =~ /(^|\s|\W)Unreal($|\s|\W)/i)
	{
		print STDOUT "competitor warning: ".$line."\n";
	}
	
	if ($line =~ /server4/i)
	{
		print STDOUT "link warning: ".$line."\n";
	}
}

#-------------------------------------------------------------------------
sub FeedTable
{
	my $table = shift;
	my $line = shift;

	$isInsideTable = $isInsideTable + 1;
	$line =~ s/^\|//;
	
	my $idx = 0;
	my $row = $#table + 1;
	@table[$row] = ();
			
	#while ($line =~ s/([0-9a-zA-Z()<>\'\-_\.\s;:,\\\/\?*]+)\|//)
	while ($line =~ s/(.*?)\|//)
	{
		my $newstuff;
		my $stuff = $1;
		
		if ($stuff =~ /^[\s]?(.*?)[\s]?$/)
		{
			$newstuff = $1;
			
			$newstuff =~ s/^[\s]+//;
			$newstuff =~ s/[\s]+$//;
			
			if (length($newstuff) == 0)
			{
				#$newstuff = "-";
			}
		}
		
		$table[$row][$idx] = $newstuff;
		$idx = $idx + 1;
	}
}

#-------------------------------------------------------------------------
sub PrintTable
{
	my $OUT = shift;
	my $table = shift;
	
	@tableHeaderSizes = ();
	
	for $row (0..$#table)
	{
    for $col (0..$#{$table[$row]})
    {
    	my $cell = $table[$row][$col];
    	
    	if ($tableHeaderSizes[$col] < length($cell))
    	{
    		$tableHeaderSizes[$col] = length($cell);
    	}
  	}
	}
	
	print $OUT "<TABLE>\n";
	
	for $row (0..$#table)
	{
    for $col (0..$#{$table[$row]})
    {
    	my $cell = $table[$row][$col];

			if ($row > 0)
			{
				$cell =~ s/\*(.*?)\*/$1/;
				print $OUT $cell;
			}
    		
			my $extraspace = $tableHeaderSizes[$col] - length($cell);
			for $i (0..$extraspace)
			{
				print $OUT "\ ";
    	}
    	
    	print $OUT "\ ";
  	}
  	
  	print $OUT "\n";
  	
  	if ($row == 0)
  	{
  		my $isRowAnHeader = 1;
  		
  		for $col (0..$#{$table[$row]})
    	{
    		if ($table[$row][$col] =~ /[\w]+/ and not $table[$row][$col] =~ /<B>.*?<\/B>/i)
    		{
    			$isRowAnHeader = 0;
    		}
    	}
  		
  		if ($isRowAnHeader)
  		{
  			for $col (0..$#tableHeaderSizes)
	    	{
	    		for $i (1..$tableHeaderSizes[$col])
	    		{
						print $OUT "\-";
	    		}
	    		
	    		print $OUT "\  ";
	    	}
	    	
	    	print $OUT "\n";
  		}
  	}
	}
	
	print $OUT "</TABLE>\n";
}

#-------------------------------------------------------------------------
sub ConvertTwikiFile
{
	my $filename = shift;
	my $outputDir = shift;
	
	print STDOUT "ConvertTwikiFile() with <$filename>\n\n\n";
	
	my $outfilename = $filename;
	$outfilename =~ s/\.txt$/\.dtx/i;
	
	$filename =~ /[\/\\]?([\w\-\_]+)\.txt$/i;
	my $topicname = $1;
	
	$filename =~ /(Twiki[\\\/]+Data[\\\/]+)(.*?)\.txt$/i;
	my $relativeName = $2.$3;
	$relativeName =~ s/\\/\//;
	
	my $topicTitle = 0;
	my $isinsidetable = 0;
	my $isInsideInternal = 0;
	my $line;
	my $wordexpr = "[0-9a-zA-Z()<>'\[\]-\.;:\ \t\!\+\\\/]+";
	
	my $IN = new IO::File;
	my $OUT = new IO::File;
	
	if (not open($IN, "$filename"))
	{
		print STDOUT "openening Twiki topic <$filename>: $!";
		return;
	}
	
	open($OUT, ">$outfilename") || die "openening DTX output: $!";
	
	print $OUT "@@ ".$topicname."\n";
	
	my $numberedlist = 1;
	
	# process every line of the twiki file
	while ($line = <$IN>)
	{
		my $indentation;
		
		$line =~ s/[Emit\s\\]{0}<([\/]?)blockquote[.*?]\>/<Emit \<$1blockquote\>>/ig;
		
		# convert numbered lists
		if ($line =~ s/^([\s]+)(1\.)([\s]+)//)
		{
			$indentation = $1.$numberedlist."\.".$3;
			$numberedlist = $numberedlist + 1;
		}
		else
		{
			$numberedlist = 1;
			
			if ($line =~ s/(^[\ \t]+\*[\ \t]+)//)
			{
				$indentation = $1;
			}
		}
		
		# we convert html <br> tags to new lines
		while ($line =~ s/<br.*?>/\n/i) {};
		while ($line =~ s/\%br\%/\n/i) {};
		while ($line =~ s/\%N%//) {};
		while ($line =~ s/\%TODO%//) {};
		
		while ($line =~ s/([^\\])[\\]{1,1}([^\\])/$1\\\\$2/) {};
		
		# convert the bold text
		while ($line =~ s/([\s]+|^|[\s]+[\W]{1})(\*)(.*?)(\*)([$|[\s]+|[\W]{1}[\s]+)/$1<B>$3<\/B>$5/) 
		{
			my $text = $3;
			my $newtext = $3;
			
			$text =~ s/([\(\)<])/\\$1/g;
			$text =~ s/\+/\\\+/g;
			$newtext =~ s/([\(\)<])/\\$1/g;
			$line =~ s/$text/$newtext/;
		};
		
		# convert the bold code text
		while ($line =~ s/([\s]+|^|[\s]+[\W]{1})(==)(.*?)(==)([$|[\s]+|[\W]{1}[\s]+)/$1<C><B>$3<\/B><\/C>$5/) {};
	
		# convert the code text
		while ($line =~ s/([\s]+|^|[\s]+[\W]{1}|\(|\))(=)(.*?)(=)([$|[\s]+|[\W]{1}[\s]+|\(|\))/$1<C>$3<\/C>$5/) {};
	
		# convert the bold+italic text
		while ($line =~ s/([\s]+|^|[\s]+[\W]{1})(\_\_)(.*?)(\_\_)([$|[\s]+|[\W]{1}[\s]+)/$1<B><I>$3<\/I><\/B>$5/) {};
	
		# convert the italic text
		while ($line =~ s/([\s]+|^|[\s]+[\W]{1}|\()(\_)(.*?)(\_)(\)|[$|[\s]+|[\W]{1}[\s]+)/$1<I>$3<\/I>$5/) {};
	
		# convert the code text
		$line =~ s/<verbatim>//gi;
		$line =~ s/<\/verbatim>//gi;
		$line =~ s/%CODE%/<code>/sgm;
		$line =~ s/\%ENDCODE\%/<\/code>/sgm;
		
		# strip author tags
		$line =~ s/^--[\ \t]+.*?$//;
		
		# discards the anchors, for now
		$line =~ s/^\#([\w]+)($|[\w]+)/<EMIT \\<a name=\\\"$1\\\"\\>\\<\/a\\>>/;
		
		# discards the automatic table of content, for now
		while ($line =~ s/%TOC%//) {};
		
		# ignore when the text is requested to not create automatic links (todo)
		while ($line =~ s/!([\w]+)/$1/) {};
		$line =~ s/<noautolink>//gi;
		$line =~ s/<\/noautolink>//gi;
  	
  	# detect the topic headers
		if ($line =~ /^---[-]*([\+]+)[!]?[!]?[\s]*(.*?)[\s]+$/) 
		{
			$headingLevel = length($1);
			$headingText = $2;
			
			$headingText =~ s/<(.*?)>//g;
			
			#print "heading <$headingText> <$headingLevel>\n";
			
			$line =~ s/---[-]?[\+]+[!]?[!]?/<EMIT \\<h$headingLevel\\>><autolink OFF>/;
			$line =~ s/\n/<autolink ON><EMIT \\<\\\/h$headingLevel\\>>\n/;
			
			if ($topicTitle == 0)
			{
				$topicTitle = 1;
				print $OUT "<TITLE $headingText>\n";
			}
  	}
  	
  	# convert quotation marks
		while ($line =~ s/&\#8216;//) {};
		while ($line =~ s/&\#8217;//) {};
		while ($line =~ s/&\#8220;//) {};
		while ($line =~ s/&\#8221;//) {};
		
		# convert dash symbols
		while ($line =~ s/&\#8211;//) {};
		while ($line =~ s/&\#8212;//) {};
		while ($line =~ s/&\#8230;//) {};
		
		while ($line =~ s/&nbsp;/\ /) {};
		while ($line =~ s/&\#9635;//) {};
		while ($line =~ s/&\#9650;//) {};
		while ($line =~ s/&\#9635;//) {};
		
		while ($line =~ s/&\#956;/Mu/) {};
		
		while ($line =~ s/&\#[\d]+;/ /) {};

  	# convert the a separator
		while ($line =~ s/---[-]?([\s]+|$)/<Emit <hr\\>>/) {};
		
		#convert alignments
		while ($line =~ s/<center>/<align center>/i) {};
		while ($line =~ s/<\/center>/<\/align>/i) {};
		
		#convert color tags
		while ($line =~ s/%RED%/<color Red>/) {};
		while ($line =~ s/%BLUE%/<color Blue>/) {};
		
		while ($line =~ s/%YELLOW%/<color Yellow>/) {};
		while ($line =~ s/%ORANGE%/<color Orange>/) {};
		while ($line =~ s/%PINK%/<color Pink>/) {};
		while ($line =~ s/%PURPLE%/<color Purple>/) {};
		while ($line =~ s/%TEAL%/<color Teal>/) {};
		while ($line =~ s/%NAVY%/<color Navy>/) {};
		while ($line =~ s/%AQUA%/<color Aqua>/) {};
		while ($line =~ s/%LIME%/<color Lime>/) {};
		while ($line =~ s/%GREEN%/<color Green>/) {};
		while ($line =~ s/%OLIVE%/<color Olive>/) {};
		while ($line =~ s/%MAROON%/<color Maroon>/) {};
		while ($line =~ s/%BROWN%/<color Brown>/) {};
		while ($line =~ s/%BLACK%%/<color Black>/) {};
		while ($line =~ s/%GRAY%/<color Gray>/) {};
		while ($line =~ s/%SILVER%/<color Silver>/) {};
		while ($line =~ s/%WHITE%/<color White>/) {};
		
		while ($line =~ s/%ENDCOLOR%/<\/color>/) {};
		
		# add trademark to CryENGINE
		while ($line =~ s/(\s|^|\W)Cry[\s]?ENGINE([0-9]?)(\s|[\'])/$1CryENGINE\&reg;$2$3/i) {}
		while ($line =~ s/(\s|^|\W)Cry[\s]?Photoshop([0-9]?)(\s|&|[\'])/$Photoshop\&reg;$2$3/i) {}
		
		# parse links
				
		for $i(0..$#allowedAttachmentType)
		{
			while ($line =~ s/\[\[(.*?$allowedAttachmentType[$i])\]\[(.*?)\]\]/<EXTLINK $1>$2<\/EXTLINK>/i) {};
			while ($line =~ s/\[\[(.*?$allowedAttachmentType[$i])\][\[\]]?\]/<EXTLINK $1>$1<\/EXTLINK>/i) {};
		}
		
		while ($line =~ s/\[\[http:\/\/(.*?)\]\[(.*?)\]\]/<EXTLINK http:\/\/$1>$2<\/EXTLINK>/i) {};
		while ($line =~ s/\[\[(.*?)\]\[(.*?)\]\]/<LINK $1,$2>/) {};
		while ($line =~ s/\[\[(.*?)\]\]/<LINK $1>/) {};
		
		# find anchor links
		while ($line =~ s/<LINK \#([\w]+),([\w]+)>/<EMIT \\<a href=\\\"\#$1\\\"\\>$2\\<\/a\\>>/i) {};
		
		ScanForWarnings($line);
		
		while ($line =~ s/([\s]+|^)\%ATTACHURL\%[\\\/]+(.*?)(\.jpg|\.gif|\.png)([\s]+|$)/$1<image $topicname\_$2$3>$4/i) { }
		
		while ($line =~ s/%ATTACHURLPATH%[\\\/]?/$topicname\_/) {};
		
		if ($line =~ /%ATTACHURL%/ and not $line =~ /<img(.*?)>/i)
		{
			while ($line =~ s/(%ATTACHURL%)\/([\w\.\_-]+)(\.jpg|\.gif|\.png)([\ \t]?[\n]?)/$topicname\_$2$3$4/i) {};
			
			for $i(0..$#allowedAttachmentType)
			{
				while ($line =~ s/(%ATTACHURL%)\/(.*?)($allowedAttachmentType[$i])([\ \t]?[\n]?)/Attachments\/$relativeName\/$2$3$4/i) {}
			}
		}
		
		while ($line =~ /<img[\s]+(.*?)>/i)
		{
			$imagetag = $1;
			if ($imagetag =~ /src=\"(.*?)\"/i)
			{
				my $imagefilename = $1;
				
				$imagefilename =~ s/\//\_/;
				$imagefilename =~ s/\%ATTACHURL\%/$topicname/;
				
				$line =~ s/<img .*?>/<image $imagefilename>/i;
			}
		}
		
		my $imageTag;
		while ($line =~ /<image ([\w\d]+)\.([\w]{3})>/)
		{
			my $imageFilename = $1;
			my $imageFilenameExt = $2;
			
			$imageTag = "";
			
			if (IsThumbnailNeeded($outputDir.$imageFilename.".".$imageFilenameExt))
			{
				$imageTag = "<EMIT <a href=\"$imageFilename.$imageFilenameExt\"\\><img src=\"$imageFilename"."_thumb".".$imageFilenameExt\"\\></a\\><br\\>>";
			}
			else
			{
				$imageTag = "<EMIT <img src=\"$imageFilename.$imageFilenameExt\"\\><br\\>>";
			}
			
			#print STDOUT "imageTag = <$imageTag>\n";
			$line =~ s/<image ([\w\d]+)\.([\w]{3})>/$imageTag/;
		}
		
		if ($isInsideInternal)
		{
			if ($line =~ s/.*?\%ENDINTERNAL\%//)
			{
				$isInsideInternal = 0;
			}
			else 
			{
				$line = "";
				$indentation = "";
			}
		}
		else
		{
			while ($line =~ s/\%INTERNAL\%.*?$\%ENDINTERNAL\%//) {}
			if ($line =~ s/\%INTERNAL\%//)
			{
				$isInsideInternal = 1;
			}
		}
		
		#detect tables
		if ($line =~ /^\|/)
		{
			FeedTable($table, $line);
			$line = "";
		}
		else
		{
			if ($isInsideTable)
			{
				PrintTable($OUT, $table);
				$isInsideTable = 0;
				$#table = -1;
				$#tableHeaderSizes = -1;
			}
		}
			
		while ($line =~ s/\%INCLUDE{\"(.*?)\"}\%//)
		{
			my $incFilename = $1;
			print STDOUT "\nincluding <$incFilename>\n\n";
			
			$incFilename =~ /([\w\\]+)\.txt$/i;
			my $incTopic = $1;
			
			my $outIncFile = $outfilename;
			
			my $incDirPrefix;
			print STDOUT "incFilename = <$incFilename> <$filename> <$path>\n";
			if ($incFilename	 =~ /(\\|\/)/)
			{
				$incDirPrefix = "";
				print STDOUT "choice 0: <$incDirPrefix> <$filename>\n";
			}
			else
			{
				if ($incFilename =~ /([\w\d]+)\.(.*?)$/)
				{
					$incDirPrefix = "$1\\\\";
					$incTopic = $2;
					
					print STDOUT "choice 2: <$incDirPrefix> <$filename>\n";
				}
				elsif ($filename =~ /Data\\(.*?)(\\|\.)(.*?)$/)
				{
					$incDirPrefix = $1;
					$incFilename = $2;
					if ($incDirPrefix)
					{
						$incDirPrefix = $incDirPrefix."\\";
					}
					print STDOUT "choice 1: <$incDirPrefix> <$filename>\n";
				}
				else
				{
					print STDOUT "choice none...\n";
				}
				
			}
			
			my $srcTwikiIncFile = $TwikiPath."Data\\".$incDirPrefix.$incTopic.".txt";
			print STDOUT "srcTwikiIncFile = <$srcTwikiIncFile>\n";
		
			my $outIncFile = $TwikiLocalPath."Data\\".$incDirPrefix.$incTopic.".txt";
			print STDOUT "outIncFile = <$outIncFile>\n";
			
			print $srcTwikiIncFile."\n";
			print $outIncFile."\n";
			
			copy($srcTwikiIncFile, $outIncFile);
			CopyAttachments($incDirPrefix.$incTopic, $outputDir);
			ConvertTwikiFile($outIncFile, $outputDir);
			print STDOUT "finished converting...\n";
			
			my $IncIN = new IO::File;
			
			$outIncFile =~ /^(.*?)\.txt/i;
			if (open($IncIN, "$1.dtx"))
			{
				while ($IncLine = <$IncIN>)
				{
					if (not $IncLine =~ /$@@/ and not $IncLine =~ /<Title/i)
					{
						print $OUT $IncLine;
					}
				}
				
				close($IncIn)
			}
		}
		
		# strip the twiki file header
		$line =~ s {^\%.*?\%} []gsx;
     
  	# now we got our line ready for Doc-O-Matic
  	print $OUT $indentation.$line;
	}
	
	if ($isInsideTable)
	{
		PrintTable($OUT, $table);
		$isInsideTable = 0;
		$#table = -1;
		$#tableHeaderSizes = -1;
	}
	
	close($IN) || die "close: $!";
	
	$isInsideTable = 0;
}

#-------------------------------------------------------------------------
sub IsValidAttachmentType
{
	my $path = shift;
		
	for $i(0..$#allowedAttachmentType)
	{
		if ($path =~ /$allowedAttachmentType[$i]/i)
		{
			return 1;
		}
	}
	
	return 0;
}

#-------------------------------------------------------------------------
sub IsDestinationOutdated
{
	my $sourceFilename = shift;
	my $destFilename = shift;
	
	if (not -e $destFilename)
	{
		return 1;
	}
	
	if (stat($sourceFilename).mtime > stat($destFilename).mtime)
	{
		return 1;
	}

	return 1;
}

#-------------------------------------------------------------------------
sub CopyAttachments
{
	my $topicname = shift;
	my $outputDir = shift;
	
	my $filename = $TwikiLocalPath."Data\\$topicname.txt";
	
	print STDOUT "CopyAttachments() topic = <$topicname>\n";
	
	my $twikIN = new IO::File;
	if (not open($twikIN, $filename))
	{
		print STDOUT "error openening <$filename> for the attachments: $!";
		return;
	}
	
	my $line;
	while ($line = <$twikIN>)
	{
		if ($line =~ /\%META:FILEATTACHMENT/)
		{
			if ($line =~ /path=\"(.*?)\"/)
			{
				my $attachpath = $1;
				
				$line =~ /name=\"(.*?)\"/;
				my $attachname = $1;
				
				print STDOUT "attachment: <$attachname> \n";
				
				if ($attachpath =~ /\.jpg/i or $attachpath =~ /\.gif/i or $attachpath =~ /\.png/i or $attachpath =~ /\.bmp/i)
				{
					my $sourcefile = $TwikiPath."pub\\".$topicname."\\".$attachname;
					my $prefix = $topicname;
					
					$prefix =~ /\\[\w\W]+\\(%.*?)/;
					#my $destinationfile = $TwikiLocalPath."Attachments\\".$prefix."\_".$attachname;
					
					$destinationfile = $prefix;
					$destinationfile =~ s/(.*?)\\//;
					$destinationfile = $outputDir.$destinationfile."\_".$attachname;
					#print STDOUT "prefix <$prefix> attachname <$attachname>\n";
					
					#print STDOUT "source: <$sourcefile>\n";
					#print STDOUT "dest  : <$destinationfile>\n";
					
					#if (IsDestinationOutdated($destinationfile, $sourcefile))
					
					{
						PrepareDirectory($destinationfile);
						copy($sourcefile, $destinationfile);
						
						my $imageVerbose;
						print STDOUT "image.. <$destinationfile>\n";
						if (IsThumbnailNeeded($destinationfile))
						{
							my $thumbFilename = $prefix;
							$thumbFilename =~ s/(.*?)\\//;
							$thumbFilename = $outputDir.$thumbFilename."\_".$attachname;
							$thumbFilename =~ s/\.([\w]+$)/_thumb\.$1/;

							#print STDOUT "thumb: <$thumbFilename>\n";
							my $newsize = $thumbnailWidthSize."x".$thumbnailHeightSize;
							my $toolOutput = `convert $destinationfile -resize $newsize $thumbFilename`;
							#print STDOUT "toolOutput: <$toolOutput>\n"
						}
					}
				}
				elsif (IsValidAttachmentType($attachpath))
				{
					my $sourcefile = $TwikiPath."pub\\".$topicname."\\".$attachname;
					my $prefix = $topicname;
					
					$prefix =~ /\\[\w\W]+\\(%.*?)/;
					my $destinationfile = $outputDir."\\Attachments\\".$prefix."\\".$attachname;
					
					if (IsDestinationOutdated($destinationfile, $sourcefile))
					{
						PrepareDirectory($destinationfile);
						copy($sourcefile, $destinationfile);
					}
				}
				else
				{
					print STDOUT "warning: Unknown attachment type <".$attachpath.">\n";
				}
			}
		}
	}
	
	close($twikIN) || print STDOUT "close: $!";
}

#-------------------------------------------------------------------------
sub FindDoxOutputDir
{
	my $doxFilename = shift;
	my $targetName = shift;
	#[Configurations\Web Help\{D3A588E0-9472-11D3-BDD1-0080C8BA053D}\General]
	#OutputDir=..\AssetCreationGuide
	
	my $doxIN = new IO::File;
	open($doxIN, $doxFilename) || die "open: $!";
	
	my $isInsideSection = 0;
	my $outputDir;
	my $line;
	
	while ($line = <$doxIN> and not ($isInsideSection and not $line =~ /\=/))
	{
		if ($line =~ /^\[Configurations\\$targetName\\(.*?)\\General\]/)
		{
			$isInsideSection = 1;
		}
		
		if ($isInsideSection)
		{
			if ($line =~ /^OutputDir[\s]?=[\s]?(.*?)$/)
			{
				$outputDir = $1."\\";
			}
		}
	}
	
	close($doxIN);
	
	return $outputDir;
}

#-------------------------------------------------------------------------
sub UpdateDoxProject
{
	my $doxFilename = shift;
	my $outputConfigName = shift;
	
	my $outputDir = FindDoxOutputDir($doxFilename, $outputConfigName);
	if ($outputDir)
	{
		PrepareDirectory($outputDir);
		#PrepareDirectory($outputDir."\\Attachments\\");
	}
	else
	{
		print STDOUT "Error: could not find output dir...\n";
		die;
	}
	
	my $doxIN = new IO::File;
	open($doxIN, $doxFilename) || die "open: $!";
	
	PrepareDirectory($TwikiLocalPath."Data\\");
	
	my $line;

	while ($line = <$doxIN>)
	{
		#File10=..\Twiki\Data\Art\ArtAssetCreationGuideline.dtx
		if ($line =~ /\.dtx/i)# and $l =~ /Twiki/i)
		{
			$line =~ /\\Twiki\\Data\\([\w\\\-]+)\.dtx$/i;
			
			my $topic = $1;
			if ($topic)
			{
				my $sourcefile = $TwikiPath."Data\\".$topic.".txt";
				my $destinationfile = $TwikiLocalPath."Data\\".$topic.".txt";
				
				PrepareDirectory($destinationfile);
				print STDOUT $destinationfile."\n";
				copy($sourcefile, $destinationfile);
				
				CopyAttachments($topic, $outputDir);
				ConvertTwikiFile($destinationfile, $outputDir);
			}
		}
	}
	
	close($doxIN) || die "close: $!";
}

#-------------------------------------------------------------------------
my $sourcefile = $ARGV[0];
my $param = $ARGV[1];

print STDOUT $sourcefile."\n";

if ($sourcefile =~ /\.dox$/)
{
	UpdateDoxProject($sourcefile, $param);
}
if ($sourcefile =~ /\.txt$/)
{
	$sourcefile =~ /\\([\w]+)\\([\w]+).[\w]+$/;
	CopyAttachments($1."\\".$2, $param);
	ConvertTwikiFile($sourcefile, $param);
}
