#include "stdafx.h"
#include "EngineSettingsManager.h"
#include "EditorDialog.h"


IMPLEMENT_DYNAMIC(CEditorDialog, CDialog)


//////////////////////////////////////////////////////////////////////////
CEditorDialog::CEditorDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CEditorDialog::IDD, pParent)
{
}


//////////////////////////////////////////////////////////////////////////
void CEditorDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_32BIT_CHECK, m_bPrefer32Bit);
}


//////////////////////////////////////////////////////////////////////////
BEGIN_MESSAGE_MAP(CEditorDialog, CDialog)
END_MESSAGE_MAP()


//////////////////////////////////////////////////////////////////////////
void CEditorDialog::Create(UINT temp, CWnd* parent, CEngineSettingsManager* settingsManager)
{
	m_settingsManager = settingsManager;
	CDialog::Create(temp, parent);
}


//////////////////////////////////////////////////////////////////////////
BOOL CEditorDialog::OnInitDialog()
{
	CDialog::OnInitDialog();	
	m_bPrefer32Bit.SetCheck(m_settingsManager->GetValue<string>("EDT_Prefer32Bit")=="true" ? BST_CHECKED : BST_UNCHECKED);
	return TRUE;
}


//////////////////////////////////////////////////////////////////////////
bool CEditorDialog::IsPrefer32Bit()
{
	return m_bPrefer32Bit.GetCheck() == BST_CHECKED;
}

