#include "stdafx.h"
#include "EngineSettingsManagerApp.h"
#include "EngineSettingsManagerDlg.h"


#include "Utils.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


//////////////////////////////////////////////////////////////////////////
CEngineSettingsManagerDlg::CEngineSettingsManagerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CEngineSettingsManagerDlg::IDD, pParent)
{
	m_hIcon = NULL;//AfxGetApp()->LoadIcon(IDI_CE2_ICON);

	char* moduleName = NULL;
	char* moduleFileName = NULL;

	if (__argc>2)
	{
		moduleName = __argv[1];
		moduleFileName = __argv[2];
	}

	m_settingsManager = new CEngineSettingsManager(moduleName, moduleFileName);
}


//////////////////////////////////////////////////////////////////////////
void CEngineSettingsManagerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_SETTINGS_TAB, m_tcSettings);
}


//////////////////////////////////////////////////////////////////////////
BEGIN_MESSAGE_MAP(CEngineSettingsManagerDlg, CDialog)
	ON_NOTIFY(TCN_SELCHANGING, IDC_SETTINGS_TAB, &OnSelchangingTab)
	ON_NOTIFY(TCN_SELCHANGE, IDC_SETTINGS_TAB, &OnSelchangeTab)
	ON_COMMAND(IDOK, OnOkButtonClicked)
END_MESSAGE_MAP()


//////////////////////////////////////////////////////////////////////////
BOOL CEngineSettingsManagerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_settingsManager->SetParentDialog((unsigned long)m_hWnd);


	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	// when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	m_tcSettings.Create(m_settingsManager);
	
	return TRUE;
}


//////////////////////////////////////////////////////////////////////////
void CEngineSettingsManagerDlg::OnSelchangingTab(NMHDR* pNMHDR, LRESULT* pResult)
{
	m_tcSettings.DeactivateTabDialog(m_tcSettings.GetCurSel());
	*pResult = 0;
}


//////////////////////////////////////////////////////////////////////////
void CEngineSettingsManagerDlg::OnSelchangeTab(NMHDR* pNMHDR, LRESULT* pResult)
{
	m_tcSettings.ActivateTabDialog(m_tcSettings.GetCurSel());
	*pResult = 0;
}


//////////////////////////////////////////////////////////////////////////
void CEngineSettingsManagerDlg::OnOkButtonClicked()
{
	m_tcSettings.PollSettings();

	m_settingsManager->StoreData();
	PostQuitMessage(0);
}
