#include "stdafx.h"
#include "EngineSettingsManager.h"
#include "SettingsTab.h"


#include "Utils.h"


IMPLEMENT_DYNAMIC(CSettingsTab, CTabCtrl)


//////////////////////////////////////////////////////////////////////////
void CSettingsTab::Create(CEngineSettingsManager* settingsManager)
{
	m_settingsManager = settingsManager;

	InsertItem(0, "Engine", 0);
	InsertItem(1, "Editor", 0);
	InsertItem(2, "ResourceCompiler", 0);

	m_settingsDialog = new CSettingsDialog();
	m_rcDialog = new CRCDialog();
	m_editorDialog = new CEditorDialog();

	m_settingsDialog->Create(IDD_SETTINGSDIALOG, this, settingsManager);
	m_rcDialog->Create(IDD_RC_DIALOG, this, settingsManager);
	m_editorDialog->Create(IDD_EDITOR_DIALOG, this, settingsManager);

	m_tabDialogs[0] = m_settingsDialog;
	m_tabDialogs[1] = m_editorDialog;
	m_tabDialogs[2] = m_rcDialog;

	ActivateTabDialog(0);
}


//////////////////////////////////////////////////////////////////////////
BEGIN_MESSAGE_MAP(CSettingsTab, CTabCtrl)
END_MESSAGE_MAP()


//////////////////////////////////////////////////////////////////////////
void CSettingsTab::ActivateTabDialog(int nSel)
{
	CRect l_rectClient;
	CRect l_rectWnd;

	GetClientRect(l_rectClient);
	AdjustRect(FALSE,l_rectClient);
	GetWindowRect(l_rectWnd);
	ScreenToClient(l_rectWnd);
	l_rectClient.OffsetRect(l_rectWnd.left,l_rectWnd.top);

	m_tabDialogs[nSel]->SetWindowPos(&wndTop, l_rectClient.left-1, l_rectClient.top, l_rectClient.Width(), l_rectClient.Height(), SWP_SHOWWINDOW);
	m_tabDialogs[nSel]->ShowWindow(SW_SHOW);
}


//////////////////////////////////////////////////////////////////////////
void CSettingsTab::DeactivateTabDialog(int nSel)
{
	m_tabDialogs[nSel]->ShowWindow(SW_HIDE);
}


//////////////////////////////////////////////////////////////////////////
void CSettingsTab::PollSettings()
{
	m_settingsManager->SetRootPath(m_settingsDialog->GetRootPath().GetBuffer());

	m_settingsManager->SetKey("RC_ShowWindow", m_rcDialog->IsShowWindow());
	m_settingsManager->SetKey("RC_HideCustom", m_rcDialog->IsHideCustom());
	m_settingsManager->SetKey("RC_Parameters", m_rcDialog->GetParams().GetBuffer());

	m_settingsManager->SetKey("EDT_Prefer32Bit", m_editorDialog->IsPrefer32Bit());
}
