#pragma once


#include "EngineSettingsManager.h"
#include "SettingsDialog.h"
#include "RCDialog.h"
#include "EditorDialog.h"


//////////////////////////////////////////////////////////////////////////
// Contains setting dialogs of all categories in a tab view
class CSettingsTab : public CTabCtrl
{
	DECLARE_DYNAMIC(CSettingsTab)

public:
	void Create(CEngineSettingsManager* settingsManager);

	void ActivateTabDialog(int nSel);
	void DeactivateTabDialog(int nSel);

	// stores settings of all dialogs to EngineSettingsManager
	void PollSettings();

protected:
	DECLARE_MESSAGE_MAP()

private:
	CEngineSettingsManager* m_settingsManager;

	CSettingsDialog* m_settingsDialog;
	CRCDialog* m_rcDialog;
	CEditorDialog* m_editorDialog;
	CDialog* m_tabDialogs[3];
};
