#include "StdAfx.h"
#include "Utils.h"


//////////////////////////////////////////////////////////////////////////
BOOL CUtils::BrowseForFolder(HWND hWnd, LPCTSTR szInitialPath, LPTSTR szPath, LPCTSTR szTitle)
{
	TCHAR szDisplay[MAX_PATH];

	CoInitialize(NULL);

	BROWSEINFO bi = { 0 };
	bi.hwndOwner = hWnd;
	bi.pszDisplayName = szDisplay;
	bi.lpszTitle = szTitle;
	bi.ulFlags = BIF_RETURNONLYFSDIRS | BIF_NEWDIALOGSTYLE;
	bi.lpfn = NULL;
	bi.lParam = (LPARAM)szInitialPath;

	LPITEMIDLIST pidl = SHBrowseForFolder(&bi);

	if (pidl != NULL)
	{
		BOOL retval = SHGetPathFromIDList(pidl, szPath);
		CoTaskMemFree(pidl);
		CoUninitialize();
		return TRUE;
	}

	szPath[0] = 0;
	CoUninitialize();
	return FALSE;
}
