//#include "stdafx.h"														// for precompiled headers (has to be in first place)
#include "ProcessorClock.h"										// CProcessorClock
#include <assert.h>														// assert()
#include "TimeValue.h"												// CTimeValue


LARGE_INTEGER CProcessorClock::m_PerformanceFrequency;




// constructor
CProcessorClock::CProcessorClock()
{
	Init();
}

// destructor
CProcessorClock::~CProcessorClock()
{
}


CTimeValue CProcessorClock::GetActualTime() const
{
	CTimeValue ret;

	LARGE_INTEGER b;

	assert(m_PerformanceFrequency.QuadPart);			// forgot to call Init() ?

	if(QueryPerformanceCounter(&b))
	{
		ret.SetRaw( (1000*1024*(b.QuadPart-m_PerformanceLevelStart.QuadPart)) / m_PerformanceFrequency.QuadPart );

		return ret;
	}

	assert(0);		// no PerformanceCounter available
	return ret;
}


/*
DWORD CProcessorClock::GetActualTime()
{
	LARGE_INTEGER b;

	if(m_PerformanceFrequency.QuadPart==0)
		Init();	// call Init

	if(QueryPerformanceCounter(&b))
	{
		return((DWORD)((1000*(b.QuadPart-m_PerformanceLevelStart.QuadPart))/(m_PerformanceFrequency.QuadPart)));
	}

	assert(0);		// no PerformanceCounter available
	return 0;
}


DWORD CProcessorClock::GetActualTime1ms()
{
	LARGE_INTEGER b;

	if(m_PerformanceFrequency.QuadPart==0)
		Init();	// call Init

	if(QueryPerformanceCounter(&b))
	{
		return((DWORD)((1000*(b.QuadPart-m_PerformanceLevelStart.QuadPart))/(m_PerformanceFrequency.QuadPart)));
	}

	assert(0);		// no PerformanceCounter available
	return 0;
}
*/


// initialization
bool CProcessorClock::Init()
{
	if(m_PerformanceFrequency.QuadPart==0)
	{
		QueryPerformanceFrequency(&m_PerformanceFrequency);		// no error check here

		m_PerformanceLevelStart.QuadPart=0;
		return(QueryPerformanceCounter(&m_PerformanceLevelStart)!=0);
	}

	return(true);
}


/*
__int64	CProcessorClock::GetActualTimeAccurate()
{
	LARGE_INTEGER b;

	if(QueryPerformanceCounter(&b))
		return b.QuadPart;

	assert(0);		// no PerformanceCounter available
	return 0;
}


// (CurrentTime - )/m_PerformanceFrequency
DWORD CProcessorClock::CalcDifference1ms( __int64 inDeltaTime )
{
	DWORD ms=(DWORD)((1000*inDeltaTime)/(m_PerformanceFrequency.QuadPart));
	
	if(ms>0)return ms;
		else return 1;
}

*/