#pragma once

#include <windows.h>
#include <winnt.h>


class CTimeValue;

class CProcessorClock  
{
public:

	//! constructor
	CProcessorClock();

	//! destructor
	virtual ~CProcessorClock();

	//! Init (set time=0)
	//! \return true=success, false=failed(no CPU with PerformanceCounter)
	bool Init();
/*
	//! get ms value
	DWORD GetActualTime();		

	//! get 1/100 ms value
	DWORD GetActualTime1ms();		

	//! get time in the internal precicion (use with GetDifference1ms() )
	__int64 GetActualTimeAccurate();
*/

	CTimeValue GetActualTime() const;

	//! (CurrentTime - )/m_PerformanceFrequency
	//! \return difference time in 1/100 ms (minimum=1)
//	static DWORD CalcDifference1ms( __int64 inDeltaTime );

private: // -------------------------------------------------------------

	static LARGE_INTEGER		m_PerformanceFrequency;					//!< CPU ticks per second
	LARGE_INTEGER						m_PerformanceLevelStart;				//!< CPU start time
};


