#include "stdafx.h"
#include "FarCryConfiguratorDlg.h"
#include "SystemConfiguration.h"
#include "GameOptionsPage.h"
#include "VideoOptionsPage.h"
#include "VideoAdvOptionsPage.h"
#include "SoundOptionsPage.h"
#include "Helpers.h"

// include resource IDs of english version, for all other languages the IDs MUST BE THE SAME!!!
#include "..\FarCryConfigEng\resource.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif



const int c_nLogoWidth( 134 );        
const int c_nOffset( 7 );
const int c_nButtonWidth( 80 );
const int c_nButtonHeight( 24 );



CFarCryConfiguratorDlg::CFarCryConfiguratorDlg( CSystemConfiguration& kSysConfig, bool bGrayCancel, CWnd* pParent )
: CPropertySheet( IDS_APP_TITLE, pParent, 0 ) 
, m_hIcon( AfxGetApp()->LoadIcon( IDR_MAINFRAME ) )
, m_kSysConfig( kSysConfig )
, m_bGrayCancel( bGrayCancel )
{
	for( int i( 0 );  i < NUM_CONFIGPAGES; ++i )
	{
		m_pkConfigPage[ i ] = 0;
	}

	InitSystemConfiguration();
	CreatePages();
}



CFarCryConfiguratorDlg::~CFarCryConfiguratorDlg()
{
	for( int i( 0 );  i < NUM_CONFIGPAGES; ++i )
	{
		SafeRelease( m_pkConfigPage[ i ] );
	}
}



void 
CFarCryConfiguratorDlg::InitSystemConfiguration()
{
#ifndef CAN_ADJUST_GORE	
	m_kSysConfig.SetValue( "g_gore", "0" );
	m_kSysConfig.SetValue( "cl_installshieldversion", "46" );
#else
	m_kSysConfig.SetValue( "cl_installshieldversion", "44" );
#endif // #ifdef CAN_ADJUST_GORE
}



void
CFarCryConfiguratorDlg::CreatePages()
{
	// avoid multiple stacks of tabs
	EnableStackedTabs( FALSE );

	m_pkConfigPage[ CPG_GAME ] = new CGameOptionsPage( m_kSysConfig );
	AddPage( m_pkConfigPage[ CPG_GAME ] );

	m_pkConfigPage[ CPG_VIDEO ] = new CVideoOptionsPage( m_kSysConfig );
	AddPage( m_pkConfigPage[ CPG_VIDEO ] );

	m_pkConfigPage[ CPG_VIDEOADV ] = new CVideoAdvOptionsPage( m_kSysConfig );
	AddPage( m_pkConfigPage[ CPG_VIDEOADV ] );

	m_pkConfigPage[ CPG_SOUND ] = new CSoundOptionsPage( m_kSysConfig );
	AddPage( m_pkConfigPage[ CPG_SOUND ] );
}



void 
CFarCryConfiguratorDlg::DoDataExchange( CDataExchange* pDX )
{
	CPropertySheet::DoDataExchange( pDX );
}



BEGIN_MESSAGE_MAP( CFarCryConfiguratorDlg, CPropertySheet )
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
END_MESSAGE_MAP()



void
CFarCryConfiguratorDlg::MoveWindowElement( HWND hWnd )
{
	CRect rectOld;
	::GetWindowRect( hWnd, &rectOld );
	ScreenToClient( &rectOld );
	::SetWindowPos( hWnd, 0, rectOld.left + c_nLogoWidth, rectOld.top, rectOld.Width (), rectOld.Height (), SWP_NOZORDER | SWP_NOACTIVATE );
}



BOOL 
CFarCryConfiguratorDlg::OnInitDialog()
{
	BOOL bResult( CPropertySheet::OnInitDialog() );

	///// debug code only....
	//CFont* pNewFont = new CFont();
	//pNewFont->CreateFont( 12, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, 
	//	DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, ANTIALIASED_QUALITY, 
	//	FF_DONTCARE, _T( "MS Mincho" ) );

	//GetTabControl()->SetFont( pNewFont );
	//
	//for( int j( 0 ); j < NUM_CONFIGPAGES; ++j )
	//{
	//	SetActivePage( m_pkConfigPage[ j ] );
	//	
	//	m_pkConfigPage[ j ]->SetFont( pNewFont );

	//	for( int i( 1000 ); i < 1038; ++i )
	//	{
	//		CWnd* p( m_pkConfigPage[ j ]->GetDlgItem( i ) );
	//		if( 0 != p )
	//		{
	//			p->SetFont( pNewFont );
	//		}
	//	}
	//}
	///// debug code ends

	// set icons
	SetIcon( m_hIcon, TRUE );
	SetIcon( m_hIcon, FALSE );

	// resize main window to allow logo to fit in
	CRect rectWnd;
	GetWindowRect( rectWnd );
	ScreenToClient( rectWnd );
	SetWindowPos( 0, 0, 0, rectWnd.Width() + c_nLogoWidth, rectWnd.Height(), SWP_NOMOVE | SWP_NOZORDER | SWP_NOACTIVATE );

	// reposition tab control
	HWND hWnd( (HWND) GetTabControl()->m_hWnd );
	assert( 0 != hWnd );
	MoveWindowElement( hWnd );

	// reposition initially visible page
	hWnd = (HWND) m_pkConfigPage[ m_psh.nStartPage ]->m_hWnd; 
	assert( 0 != hWnd );
	MoveWindowElement( hWnd );

	// hide property sheet buttons
	int propSheetButtons[] = { ID_APPLY_NOW, IDHELP };
	for( int i( 0 ); i < sizeof( propSheetButtons ) / sizeof( propSheetButtons[ 0 ] ); ++i )
	{
		hWnd = ::GetDlgItem( m_hWnd, propSheetButtons[ i ] );
		if( 0 != hWnd )
		{
			::ShowWindow( hWnd, SW_HIDE );
		}
	}

	// rearrange IDOK and IDCANCEL
	CRect rectClient;
	GetClientRect( rectClient );

	hWnd = ::GetDlgItem( m_hWnd, IDOK );
	if( 0 != hWnd )
	{
		CString strButtonText;
		strButtonText.LoadString( IDS_PLAY );
		::SetWindowText( hWnd, strButtonText );
		::MoveWindow( hWnd, rectClient.Width() - 2 * (  c_nOffset + c_nButtonWidth ),
							rectClient.Height() - c_nOffset - c_nButtonHeight, c_nButtonWidth, c_nButtonHeight, TRUE );
	}

	hWnd = ::GetDlgItem( m_hWnd, IDCANCEL );
	if( 0 != hWnd )
	{
		CString strButtonText;
		strButtonText.LoadString( IDS_QUIT );
		::SetWindowText( hWnd, strButtonText );
		::MoveWindow( hWnd, rectClient.Width() - ( c_nOffset + c_nButtonWidth ), 
							rectClient.Height() - c_nOffset - c_nButtonHeight, c_nButtonWidth, c_nButtonHeight, TRUE );
		
		if( false != m_bGrayCancel )
		{
			::EnableWindow( hWnd, FALSE );
		}
	}

	// if needed, run through all pages to perform auto detection of optimal settings
	if( false != m_kSysConfig.IsInitialConfig() )
	{
		MessageBox( LoadString( IDS_PERFORM_AUTODETECT ), LoadString( IDS_APP_TITLE ), MB_OK | MB_ICONINFORMATION );

		for( int i( 0 ); i < NUM_CONFIGPAGES; ++i )
		{
			SetActivePage( m_pkConfigPage[ i ] );
		}		
	}

	// finally set start page
	SetActivePage( m_pkConfigPage[ CPG_START ] );

	// center dialog
	CenterWindow ();

	return( bResult );
}



void 
CFarCryConfiguratorDlg::OnPaint() 
{
	if( FALSE != IsIconic() )
	{
		CPaintDC dc( this ); 

		SendMessage( WM_ICONERASEBKGND, reinterpret_cast< WPARAM >( dc.GetSafeHdc() ), 0 );

		int cxIcon( GetSystemMetrics( SM_CXICON ) );
		int cyIcon( GetSystemMetrics( SM_CYICON ) );
		
		CRect rect;
		GetClientRect( &rect );
		int x( ( rect.Width() - cxIcon + 1 ) / 2 );
		int y( ( rect.Height() - cyIcon + 1 ) / 2 );

		dc.DrawIcon( x, y, m_hIcon );
	}
	else
	{
		CPaintDC dc( this ); 

		CBitmap bmp;
		if( FALSE != bmp.LoadBitmap( IDB_LOGO ) )
		{
			BITMAP bmpInfo;
			bmp.GetBitmap( &bmpInfo );

			CDC dcMemory;
			dcMemory.CreateCompatibleDC( &dc );

			CBitmap* pOldBitmap( dcMemory.SelectObject( &bmp ) );

			CRect rect;
			GetClientRect( &rect );
			dc.BitBlt( rect.left + c_nOffset, rect.top + c_nOffset, bmpInfo.bmWidth, bmpInfo.bmHeight, &dcMemory, 0, 0, SRCCOPY );
			
			dcMemory.SelectObject( pOldBitmap );
		}
	}
}



HCURSOR 
CFarCryConfiguratorDlg::OnQueryDragIcon()
{
	return( static_cast< HCURSOR >( m_hIcon ) );
}



INT_PTR 
CFarCryConfiguratorDlg::DoModal()
{
	INT_PTR res( CPropertySheet::DoModal() );
	if( IDOK == res )
	{
		// serialize system config
		// all activated pages have already updated the cvars assigned to them (see OnOK() of appropriate pages)
		m_kSysConfig.SerializeSystemConfig();
	}	
	return( res );
}
