#include "StdAfx.h"
#include "FarCryRegistry.h"
#include "LanguageID.h"

#include <vector>



// product code of Far Cry
const TCHAR c_pcProductCode[] = _T( "{D6DBDC2A-E72C-4284-B6AD-6B3B61B4DABC}" );


// key and value
const TCHAR c_pcInstallRegKey[] = _T( "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" )
									   _T( "{D6DBDC2A-E72C-4284-B6AD-6B3B61B4DABC}" );

const TCHAR c_pcInstallRegValue[] = _T( "InstallLocation" );

// location of IDriver (version for InstallShield DevStudio 9)
const TCHAR c_pcIDriverRegValue[] = _T( "TypeLib\\{C17E7E12-9C20-4B9C-A225-F79292C58BC9}\\1.0\\0\\win32" );



const unsigned int c_wow64Flags[] = 
{
	KEY_WOW64_64KEY,
	0
};



using namespace std;



static bool 
FindFile( const tstring& strFilePath )
{
	bool bRet( false );
#ifdef UNICODE
	FILE* f( _wfopen( strFilePath.c_str(), _T( "rb" ) ) );
#else
	FILE* f( fopen( strFilePath.c_str(), _T( "rb" ) ) );
#endif
	if( 0 != f )
	{
		bRet = true;
		fclose( f );
	}
	return( bRet );
}



static bool
Is64BitWindows()
{
	OSVERSIONINFOEX sOsVersionInfoEx;

	ZeroMemory( &sOsVersionInfoEx,  sizeof( OSVERSIONINFOEX ) );
	sOsVersionInfoEx.dwOSVersionInfoSize = sizeof( OSVERSIONINFOEX );

	BOOL bOsVersionInfoEx( GetVersionEx ( (OSVERSIONINFO*) &sOsVersionInfoEx ) );
	if( FALSE == bOsVersionInfoEx )
	{
		sOsVersionInfoEx.dwOSVersionInfoSize = sizeof( OSVERSIONINFO );
		if( FALSE == GetVersionEx( (OSVERSIONINFO*) &sOsVersionInfoEx ) ) 
		{
			// both win32 calls to get os version info have failed!
			return( false );
		}
	}
	return( 5 <= sOsVersionInfoEx.dwMajorVersion && 2 <= sOsVersionInfoEx.dwMinorVersion );
}



bool 
FarCryRegistry::IsInstalled()
{
	// check registry if Far Cry's has been installed already
	bool bRet( false );	
	HKEY hKey;

	for( int i( 0 ); false == bRet && i < sizeof( c_wow64Flags ) / sizeof( c_wow64Flags[ 0 ] ); ++i )
	{
		if( ERROR_SUCCESS == RegOpenKeyEx( HKEY_LOCAL_MACHINE, c_pcInstallRegKey, 0, c_wow64Flags[ i ] | KEY_READ, &hKey ) )
		{
			bRet = true;
			RegCloseKey( hKey );
		}
	}
	return( bRet );
}



bool 
FarCryRegistry::GetFarCryInstallationFolder( tstring& strInstallationFolder )
{
	bool bRet( false );	
	HKEY hKey;

	for( int i( 0 ); false == bRet && i < sizeof( c_wow64Flags ) / sizeof( c_wow64Flags[ 0 ] ); ++i )
	{
		if( ERROR_SUCCESS == RegOpenKeyEx( HKEY_LOCAL_MACHINE, c_pcInstallRegKey, 0, c_wow64Flags[ i ] | KEY_READ, &hKey ) )
		{
			DWORD dwSizeStr( 0 );
			DWORD dwRegType( REG_SZ );
			if( ERROR_SUCCESS == RegQueryValueEx( hKey, c_pcInstallRegValue, 0, &dwRegType, 0, &dwSizeStr ) )
			{
				vector< unsigned char > colInstallLocation( dwSizeStr );
				if( ERROR_SUCCESS == RegQueryValueEx( hKey, c_pcInstallRegValue, 0, &dwRegType, &colInstallLocation[ 0 ], &dwSizeStr ) )
				{
					strInstallationFolder = (TCHAR*) &colInstallLocation[ 0 ];				

					bRet = true;
				}						
				RegCloseKey( hKey );
			}
		}
	}
	return( bRet );
}



bool 
FarCryRegistry::GetIDriverFilePath( tstring& strIDriverFilePath )
{
	bool bRet( false );
	HKEY hKey;

	for( int i( 0 ); false == bRet && i < sizeof( c_wow64Flags ) / sizeof( c_wow64Flags[ 0 ] ); ++i )
	{
		if( ERROR_SUCCESS == RegOpenKeyEx( HKEY_CLASSES_ROOT, c_pcIDriverRegValue, 0, c_wow64Flags[ i ] | KEY_READ, &hKey ) )
		{
			DWORD dwSizeStr( 0 );
			DWORD dwRegType( REG_SZ );
			if( ERROR_SUCCESS == RegQueryValueEx( hKey, 0, 0, &dwRegType, 0, &dwSizeStr ) )
			{
				vector< unsigned char > colIDriverFilePath( dwSizeStr );
				if( ERROR_SUCCESS == RegQueryValueEx( hKey, 0, 0, &dwRegType, &colIDriverFilePath[ 0 ], &dwSizeStr ) )
				{
					strIDriverFilePath = (TCHAR*) &colIDriverFilePath[ 0 ];				

					bRet = true;
				}						
				RegCloseKey( hKey );
			}
		}
	}
	return( bRet );
}



bool 
FarCryRegistry::GetInstallCmd( tstring& strInstallCmd )
{
	// assume that FarCryAutoCD is in the same directory on CD/DVD as setup.exe 
	if( false == Is64BitWindows() )
	{
		strInstallCmd = _T( "Setup32.exe" );
	}
	else
	{
		strInstallCmd = _T( "Setup64.exe" );
	}		
	return( true );
}



bool
FarCryRegistry::GetLaunchCmd( tstring& strLaunchCmd, tstring& strLaunchWorkingDir )
{
	bool bRet( false );
	if( false != GetFarCryInstallationFolder( strLaunchWorkingDir ) )
	{
		if( false == Is64BitWindows() )
		{
			strLaunchCmd = _T( "Bin32\\FarCry.exe" );
		}
		else
		{
			strLaunchCmd = _T( "Bin64\\FarCry.exe" );
		}		
		if( false != FindFile( strLaunchWorkingDir + strLaunchCmd ) )
		{
			bRet = true;
		}
	}
	return( bRet );
}



bool
FarCryRegistry::GetUninstallCmd( tstring& strUninstallCmd, tstring& strUninstallParam1 )
{
	bool bRet( false );

	// get file path for IDriver.exe
	if( false != GetIDriverFilePath( strUninstallCmd ) )
	{
		// set uninstall parameters
		strUninstallParam1 = tstring( _T( "/M" ) ) + tstring( c_pcProductCode );
		bRet = true;
	}
	return( bRet );
}



bool 
FarCryRegistry::GetReadmePath( tstring& strReadmePath )
{
	TCHAR c_readmeRelPath[]( _T( "Support\\Readme.txt" ) );

	bool bSearchOnCD( true );
	if( false != IsInstalled() && false != GetFarCryInstallationFolder( strReadmePath ) )
	{
		// game is installed, search for readme in game folder
		strReadmePath += c_readmeRelPath;
		if( false != FindFile( strReadmePath ) )
		{			
			bSearchOnCD = false;
		}
	}

	// readme not found, try CD/DVD
	if( false != bSearchOnCD )
	{
		TCHAR c_readmeRelPathUS[]( _T( "Support\\Readme (US).txt" ) );
		TCHAR c_readmeRelPathUK[]( _T( "Support\\Readme (UK).txt" ) );
		TCHAR c_readmeRelPathFR[]( _T( "Support\\Readme (FR).txt" ) );
		TCHAR c_readmeRelPathDE[]( _T( "Support\\Readme (DE).txt" ) );
		TCHAR c_readmeRelPathIT[]( _T( "Support\\Readme (IT).txt" ) );
		TCHAR c_readmeRelPathJP[]( _T( "Support\\Readme (JP).txt" ) );
		TCHAR c_readmeRelPathES[]( _T( "Support\\Readme (ES).txt" ) );
		TCHAR c_readmeRelPathPL[]( _T( "Support\\Readme (PL).txt" ) );

		switch( GetPrimaryLanguageID() )
		{
		case 0x07:
			{
				strReadmePath = c_readmeRelPathDE;
				break;
			}		
		case 0x09:
			{
				if( 0x0809 == ( GetFullLanguageID() & 0xFFFF ) )
				{
					strReadmePath = c_readmeRelPathUK;
				}
				else
				{
					strReadmePath = c_readmeRelPathUS;
				}				
				break;
			}
		case 0x0c:
			{
				strReadmePath = c_readmeRelPathFR;
				break;
			}		
		case 0x0a:
			{
				strReadmePath = c_readmeRelPathES;
				break;
			}		
		case 0x10:
			{
				strReadmePath = c_readmeRelPathIT;
				break;
			}		
		case 0x11:
			{
				strReadmePath = c_readmeRelPathJP;
				break;
			}		
		case 0x15:
			{
				strReadmePath = c_readmeRelPathPL;
				break;
			}		
		default:
			{
				strReadmePath = c_readmeRelPathUS;
			}			
		}				
	}
	return( true );
}



bool 
FarCryRegistry::GetManualPath( tstring& strManualPath )
{
	TCHAR c_manualRelPath[]( _T( "Support\\Manual\\Far Cry User Manual.pdf" ) );

	bool bSearchOnCD( true );
	if( false != IsInstalled() && false != GetFarCryInstallationFolder( strManualPath ) )
	{
		// game is installed, search for manual in game folder
		strManualPath += c_manualRelPath;
		if( false != FindFile( strManualPath ) )
		{
			bSearchOnCD = false;
		}
	}

	// manual not found, try CD/DVD
	if( false != bSearchOnCD )
	{
		TCHAR c_manualRelPathUS[]( _T( "Support\\Manual\\Far Cry User Manual (US).pdf" ) );
		TCHAR c_manualRelPathUK[]( _T( "Support\\Manual\\Far Cry User Manual (UK).pdf" ) );
		TCHAR c_manualRelPathFR[]( _T( "Support\\Manual\\Far Cry User Manual (FR).pdf" ) );
		TCHAR c_manualRelPathDE[]( _T( "Support\\Manual\\Far Cry User Manual (DE).pdf" ) );
		TCHAR c_manualRelPathIT[]( _T( "Support\\Manual\\Far Cry User Manual (IT).pdf" ) );
		TCHAR c_manualRelPathJP[]( _T( "Support\\Manual\\Far Cry User Manual (JP).pdf" ) );
		TCHAR c_manualRelPathES[]( _T( "Support\\Manual\\Far Cry User Manual (ES).pdf" ) );
		TCHAR c_manualRelPathPL[]( _T( "Support\\Manual\\Far Cry User Manual (PL).pdf" ) );

		switch( GetPrimaryLanguageID() )
		{
		case 0x07:
			{
				strManualPath = c_manualRelPathDE;
				break;
			}		
		case 0x09:
			{
				if( 0x0809 == ( GetFullLanguageID() & 0xFFFF ) )
				{
					strManualPath = c_manualRelPathUK;
				}
				else
				{
					strManualPath = c_manualRelPathUS;
				}				
				break;
			}
		case 0x0c:
			{
				strManualPath = c_manualRelPathFR;
				break;
			}		
		case 0x0a:
			{
				strManualPath = c_manualRelPathES;
				break;
			}		
		case 0x10:
			{
				strManualPath = c_manualRelPathIT;
				break;
			}		
		case 0x11:
			{
				strManualPath = c_manualRelPathJP;
				break;
			}		
		case 0x15:
			{
				strManualPath = c_manualRelPathPL;
				break;
			}		
		default:
			{
				strManualPath = c_manualRelPathUS;
				break;
			}			
		}				
	}
	return( true );
}



bool 
FarCryRegistry::GetRegisterCmd( tstring& strRegisterCmd, tstring& strRegisterParam1, tstring& strRegisterParam2, tstring& strRegisterWorkingDir )
{
	bool bRet( false );

	tstring strWorkingDir;
	if( false != GetFarCryInstallationFolder( strWorkingDir ) )
	{
		// get working folder for registration tool 
		strRegisterWorkingDir = strWorkingDir + _T( "Register\\" );		

		// aim for US/Canadian registration tool first
		strRegisterCmd = _T( "RegistrationReminder.exe" );
		if( false == FindFile( strRegisterWorkingDir + strRegisterCmd ) )
		{
			// couldn't find US/Canadian registration tool, try European one
			strRegisterCmd = _T( "regsetup.exe" );
			if( false != FindFile( strRegisterWorkingDir + strRegisterCmd ) )
			{
				strRegisterParam1 = _T( "" );
				strRegisterParam2 = _T( "" );
				bRet = true;
			}
		}
		else
		{
			strRegisterParam1 = _T( "-i 272" );
			strRegisterParam2 = _T( "-g Far Cry" );
			//strRegisterParam1 = _T( "-g Far Cry" );
			//strRegisterParam2 = _T( "" );
			bRet = true;
		}
	}
	return( bRet );
}




bool 
FarCryRegistry::GetWebLinkPath( tstring& strWeblinkPath )
{
	TCHAR c_weblinkRelPath[]( _T( "Support\\FarCry.url" ) );

	bool bSearchOnCD( true );
	if( false != IsInstalled() && false != GetFarCryInstallationFolder( strWeblinkPath ) )
	{
		// game is installed, search for web link in game folder
		strWeblinkPath += c_weblinkRelPath;
		if( false != FindFile( strWeblinkPath ) )
		{			
			bSearchOnCD = false;
		}
	}

	// web link not found, try CD/DVD
	if( false != bSearchOnCD )
	{
		TCHAR c_webLinkRelPathUS[]( _T( "Support\\FarCry (US).url" ) );
		TCHAR c_webLinkRelPathUK[]( _T( "Support\\FarCry (UK).url" ) );
		TCHAR c_webLinkRelPathFR[]( _T( "Support\\FarCry (FR).url" ) );
		TCHAR c_webLinkRelPathDE[]( _T( "Support\\FarCry (DE).url" ) );
		TCHAR c_webLinkRelPathIT[]( _T( "Support\\FarCry (IT).url" ) );
		TCHAR c_webLinkRelPathJP[]( _T( "Support\\FarCry (JP).url" ) );
		TCHAR c_webLinkRelPathES[]( _T( "Support\\FarCry (ES).url" ) );
		TCHAR c_webLinkRelPathPL[]( _T( "Support\\FarCry (PL).url" ) );

		switch( GetPrimaryLanguageID() )
		{
		case 0x07:
			{
				strWeblinkPath = c_webLinkRelPathDE;
				break;
			}		
		case 0x09:
			{
				if( 0x0809 == ( GetFullLanguageID() & 0xFFFF ) )
				{
					strWeblinkPath = c_webLinkRelPathUK;
				}
				else
				{
					strWeblinkPath = c_webLinkRelPathUS;
				}				
				break;
			}
		case 0x0c:
			{
				strWeblinkPath = c_webLinkRelPathFR;
				break;
			}		
		case 0x0a:
			{
				strWeblinkPath = c_webLinkRelPathES;
				break;
			}		
		case 0x10:
			{
				strWeblinkPath = c_webLinkRelPathIT;
				break;
			}		
		case 0x11:
			{
				strWeblinkPath = c_webLinkRelPathJP;
				break;
			}		
		case 0x15:
			{
				strWeblinkPath = c_webLinkRelPathPL;
				break;
			}		
		default:
			{
				strWeblinkPath = c_webLinkRelPathUS;
				break;
			}			
		}

		if( false == FindFile( strWeblinkPath ) )
		{
			strWeblinkPath = _T( "http://www.farcry-thegame.com" );
		}
	}
	return( true );
}
