#pragma once

#include <math.h>

#include <string>
#include <map>
#include <istream>



typedef std::string SysConfigKey;
typedef std::string SysConfigValue;



inline bool 
IsEqual( const SysConfigValue& rhs, const SysConfigValue& lhs )
{
	return( 0 == stricmp( rhs.c_str(), lhs.c_str() ) && rhs.size() == lhs.size() );
}



inline bool 
IsEqual( const SysConfigValue& rhs, double lhs )
{
	double val( atof( rhs.c_str() ) );
	return( fabs( val - lhs ) < 1e-6 );
}



inline bool 
IsLessEqual( const SysConfigValue& rhs, double lhs )
{
	double val( atof( rhs.c_str() ) );
	return( val <= lhs );
}



inline bool 
IsBiggerEqual( const SysConfigValue& rhs, double lhs )
{
	double val( atof( rhs.c_str() ) );
	return( val >= lhs );
}



inline bool 
IsLess( const SysConfigValue& rhs, double lhs )
{
	double val( atof( rhs.c_str() ) );
	return( val < lhs );
}



inline bool 
IsBigger( const SysConfigValue& rhs, double lhs )
{
	double val( atof( rhs.c_str() ) );
	return( val > lhs );
}



class CSystemConfiguration
{
public:
	static void PatchLanguageFromSetup( const SysConfigValue& newLanguage );

public:
	CSystemConfiguration( const std::string& strSysConfigFilePath );
	~CSystemConfiguration();

	void SerializeSystemConfig();
	bool IsInitialConfig() const;	

	void SetValue( const SysConfigKey& key, const SysConfigValue& value );
	SysConfigValue GetValue( const SysConfigKey& key ) const;

private:
	typedef std::map< SysConfigKey, SysConfigValue > SysConfigMap;

private:
	static void SetSystemCfgFileAttributes( const std::string& strSysConfigFilePath );

private:
	void Parse( std::istream& kStream );
	void InitDefaultValues();
	void ParseSystemConfig();
	void DetermineInitialConfigStatus();

private:
	std::string m_strSysConfigFilePath;
	SysConfigMap m_colCCVars;
	bool m_bIsInitialConfig;
};
