#pragma once

#include "ConfigComboBox.h"



class CSystemConfiguration;



class CVideoAdvOptionsPage : public CPropertyPage
{
public:
	CVideoAdvOptionsPage( CSystemConfiguration& kSysConfig );
	virtual ~CVideoAdvOptionsPage();
	virtual BOOL OnInitDialog();
	virtual void OnOK();

	void UpdateSystemConfig();

protected:
	DECLARE_MESSAGE_MAP()

	virtual void DoDataExchange( CDataExchange* pDX );

	afx_msg void OnBnClickedAutoDetect();
	afx_msg void OnBnClickedVeryHigh();
	afx_msg void OnBnClickedHigh();
	afx_msg void OnBnClickedMedium();
	afx_msg void OnBnClickedLow();
	afx_msg void OnBnClickedCustomize();

private:
	DECLARE_DYNAMIC( CVideoAdvOptionsPage )

	void DetectConfigs();

private:
	CSystemConfiguration& m_kSysConfig;

	CConfigComboBox m_kTextureQualityCtrl;
	CConfigComboBox m_kTextureFilterQualityCtrl;
	CConfigComboBox m_kAnisotropicFilteringLevelCtrl;
	CConfigComboBox m_kParticleCountCtrl;
	CConfigComboBox m_kSpecialEffectsQualityCtrl;
	CConfigComboBox m_kEnvironmentQualityCtrl;
	CConfigComboBox m_kShadowQualityCtrl;
	CConfigComboBox m_kWaterQualityCtrl;
	CConfigComboBox m_kLightingQualityCtrl;
};
