#include "stdafx.h"
#include <conio.h>								// getchar()
#include <algorithm>							// STL sort
#include "ImageVerifier.h"				// CImageVerifier
#include "ColorImage.h"						// CColorImage
#include "HTMLWriter.h"						// CHTMLWriter
#include <io.h>										// __finddata64_t
#include "ASCIIFile.h"						// IO_GetFileSize()
#include <time.h>									// _strdate_s



//////////////////////////////////////////////////////////////////////////
// the paths must have trailing slash
// 
// Example usage:
//    std::vector<std::string> RefFiles,SrcFiles;
//    ScanDirectoryRecursive(std::string(szRefDir)+"/","","*.*",RefFiles,true);
static bool ScanDirectoryRecursive( const std::string &root,const std::string &path,const std::string &file,std::vector<std::string> &files, bool recursive )
{
	__finddata64_t c_file;
	intptr_t hFile;

	bool anyFound = false;

	std::string fullPath = root + path + file;
	if ( (hFile = _findfirst64( fullPath.c_str(), &c_file )) != -1L )
	{
		// Find the rest of the files.
		do {
			if (!(c_file.attrib & _A_SUBDIR))
			{
				anyFound = true;

				if(stricmp(c_file.name,"Thumbs.db")!=0)					// ignore this
					files.push_back( path + c_file.name );
			}
		}	while (_findnext64( hFile, &c_file ) == 0);
		_findclose( hFile );
	}

	if (recursive)
	{
		fullPath = root + path + "*.*";
		if( (hFile = _findfirst64( fullPath.c_str(), &c_file )) != -1L )
		{
			// Find directories.
			do {
				if (c_file.attrib & _A_SUBDIR)
				{
					// If recursive.
					if (c_file.name[0] != '.')
					{
						if (ScanDirectoryRecursive( root,path + c_file.name + "\\",file,files,recursive ))
							anyFound = true;
					}
				}
			}	while (_findnext64( hFile, &c_file ) == 0);
			_findclose( hFile );
		}
	}

	return anyFound;
}

void CompareFile( CImageVerifier &iv, CHTMLWriter &htmlSummary, CHTMLWriter &htmlDetails, const char *szRefDir, const char *szSrcDir, const char *szFile )
{
	std::string sSrc=std::string(szSrcDir)+"/"+szFile;
	std::string sRef=std::string(szRefDir)+"/"+szFile;

	iv.Setup(sRef.c_str(),sSrc.c_str());

	CResult result;

	if(!iv.GetRef())
		result.AddError("Failed to load Reference");
	if(!iv.GetSrc())
		result.AddError("Failed to load Source");

	uint32 dwId = iv.GetUniqueId();

	htmlDetails.Add("<a name=\"LABEL%d\">",dwId);						// define to label
	htmlDetails.Add("<b>File</b>: %s ",szFile);
	htmlDetails.Add("</a>");

	htmlDetails.Add("<a href=\"%s\">Reference</a> ",sRef.c_str());
	htmlDetails.Add("<a href=\"%s\">Source</a>",sSrc.c_str());
	htmlDetails.AddLine("");

	uint32 dwSrcSize = IO_GetFileSize(sSrc.c_str());
	uint32 dwRefSize = IO_GetFileSize(sRef.c_str());

	if(dwSrcSize!=dwRefSize)
		result.AddError("Size is different (src=%d ref=%d)",dwSrcSize,dwRefSize);

	htmlDetails.AddLine("<b>Errors</b>: %s\n",result.GetErrors());

	CColorImage diff;

	if(iv.GetSrc() && iv.GetRef())
	{
		iv.ImageDifference(diff,result);
		htmlDetails.AddLine("<b>Difference</b>: %f %%\n",result.m_fDifference*100.0f);
	}
	if(iv.GetRef())htmlDetails.AddImage(*iv.GetRef(),"reference");
//	htmlDetails.AddLine("");
	if(iv.GetSrc())htmlDetails.AddImage(*iv.GetSrc(),"source");
//	htmlDetails.AddLine("");
	if(diff.IsValid())htmlDetails.AddImage(diff,"difference");
	htmlDetails.AddLine("");
	htmlDetails.AddLine("");
	htmlDetails.AddLine("");


	if(!result.IsError())
	{
		htmlSummary.AddLine("<b>File</b>: %s\n",szFile);
		//		htmlSummary.Add("<a href=\"#%s\">... Ok</a>",szFile);
	}
	else
	{
		htmlSummary.Add("<b>File</b>: %s\n",szFile);
		htmlSummary.AddLine("<a href=\"#LABEL%d\"> ... failed</a>",dwId);		// jump to label
	}

}


int main(int argc, char * argv[])
{
	if(argc!=4)
	{
		printf("Image Verifier (command line tool)\n");
		printf("\n");
		printf("USAGE: ImageVerifier <reference_directory> <source_directory> <output>\n");
		printf("\n");
		printf("output will be saved to current directory\n");
		printf("\n");
		printf("\n\n                                                 <RETURN>\n");
		getchar();
		return 0;
	}

	CImageVerifier iv;

	char *szRefDir = argv[1];
	char *szSrcDir = argv[2];
	char *szOutput = argv[3];

	CHTMLWriter htmlSummary(szOutput,"Summary");
	CHTMLWriter htmlDetails(szOutput,"Details");

	htmlSummary.AddHeadline("ImageVerifier Results:");	
	htmlSummary.AddLine("(best viewed with Internet Explorer or Firefox as BMP format is used)");
	htmlSummary.AddLine("");

	std::vector<std::string> RefFiles,SrcFiles;

	ScanDirectoryRecursive(std::string(szRefDir)+"/","","*.*",RefFiles,true);
	ScanDirectoryRecursive(std::string(szSrcDir)+"/","","*.*",SrcFiles,true);

	std::sort(RefFiles.begin(),RefFiles.end());
	std::sort(SrcFiles.begin(),SrcFiles.end());

	char tmpbuf[128];

	_strdate_s( tmpbuf, 128 );

	htmlSummary.AddLine("<b>Date:</b> %s",tmpbuf);
	htmlSummary.AddLine("");
	htmlSummary.AddLine("<b>RefDir</b>: %s (%d files)",szRefDir,(int)RefFiles.size());
	htmlSummary.AddLine("<b>SrcDir</b>: %s (%d files)",szSrcDir,(int)SrcFiles.size());
	htmlSummary.AddLine("");


	std::vector<std::string>::const_iterator itRef=RefFiles.begin(), endRef=RefFiles.end();
	std::vector<std::string>::const_iterator itSrc=SrcFiles.begin(), endSrc=SrcFiles.end();
	for(;;)
	{
		char szLastChar[] = { 255, 255, 255, 0 };		// to map end() to last string

		std::string sRef=szLastChar;		 if(itRef!=endRef)sRef=*itRef;
		std::string sSrc=szLastChar;		 if(itSrc!=endSrc)sSrc=*itSrc;

		if(sRef==sSrc)
		{
			if(sRef==szLastChar)
				break;

			printf("CmpFile: %s\n",sRef.c_str());
			CompareFile(iv,htmlSummary,htmlDetails,szRefDir,szSrcDir,sRef.c_str());
			++itRef;++itSrc;
			continue;
		}
	
		if(sRef<sSrc)
		{
			printf("skip RefFile: %s\n",sRef.c_str());
			htmlSummary.AddLine("<a href=\"%s\">File skipped (not in Src): %s</a>\n",(std::string(szRefDir)+"/"+sRef).c_str(),sRef.c_str());
			++itRef;
		}
		else
		{
			printf("skip SrcFile: %s\n",sSrc.c_str());
			htmlSummary.AddLine("<a href=\"%s\">File skipped (not in Ref): %s</a>\n",(std::string(szSrcDir)+"/"+sSrc).c_str(),sSrc.c_str());
			++itSrc;
		}
	}

	htmlSummary.AddLine("<br><br><br>----------------------------------------------------------------------------------------------------------------");
	htmlSummary.AddLine("<br><br><br>");
	htmlSummary.Add(htmlDetails);

	// add empty space to the end
	htmlSummary.AddLine("<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>");
	htmlSummary.SaveHTML((std::string(szOutput)+".htm").c_str(),(std::string("ImageVerifier ")+szOutput).c_str());

	printf("\n\n                                                 <RETURN>\n");
	getchar();

	return 0;
}

