using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace InternetSimulator
{
	/// <summary>
	/// Summary description for AdapterForm.
	/// </summary>
	public class AdapterForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ListView lvAdapters;
		private System.Windows.Forms.Button btnOK;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public AdapterForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.lvAdapters = new System.Windows.Forms.ListView();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.btnOK = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// lvAdapters
			// 
			this.lvAdapters.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						 this.columnHeader2,
																						 this.columnHeader1});
			this.lvAdapters.Location = new System.Drawing.Point(8, 16);
			this.lvAdapters.Name = "lvAdapters";
			this.lvAdapters.Size = new System.Drawing.Size(480, 192);
			this.lvAdapters.TabIndex = 0;
			this.lvAdapters.View = System.Windows.Forms.View.Details;
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "IP";
			this.columnHeader2.Width = 100;
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "AdapterName";
			this.columnHeader1.Width = 350;
			// 
			// btnOK
			// 
			this.btnOK.Location = new System.Drawing.Point(8, 224);
			this.btnOK.Name = "btnOK";
			this.btnOK.TabIndex = 1;
			this.btnOK.Text = "&OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// AdapterForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(496, 269);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.btnOK,
																		  this.lvAdapters});
			this.Name = "AdapterForm";
			this.Text = "AdapterForm";
			this.ResumeLayout(false);

		}
		#endregion

		public void SetSelection(string name)
		{
			foreach(ListViewItem lvi in lvAdapters.Items)
			{
				foreach(ListViewItem.ListViewSubItem si in lvi.SubItems)
				{
					if(si.Text==name)
					{
						lvi.Selected=true;
					}
				}
			}
		}
		public string GetSelection()
		{
			if(lvAdapters.SelectedItems.Count!=0)
			{
				return lvAdapters.SelectedItems[0].SubItems[1].Text;
				
			}
			
			return "No Device Selected";
		}
		public void AddAdapter(string name, string ip)
		{
			ListViewItem lvi=new ListViewItem();
			lvi.SubItems.Add(name);
			lvi.Text=ip;
			lvAdapters.Items.Add(lvi);
			
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			DialogResult=DialogResult.OK;
		}
	}
}
