// Adapters.h : Declaration of the CAdapters

#pragma once
#include "resource.h"       // main symbols


#include <vector>

interface IAdapter;

typedef std::vector<_variant_t > AdaptersVec;
// IAdapters
[
	object,
	uuid("1248E09E-F5C0-4B6E-ACCF-A8327DE566FC"),
	dual,	helpstring("IAdapters Interface"),
	pointer_default(unique)
]
__interface IAdapters : IDispatch
{
	[propget, helpstring("Returns number of items in collection.")]
	HRESULT Count([out, retval] long* retval);

	[propget, id(DISPID_VALUE), helpstring("Given an index, returns an item in the collection.")]
	HRESULT Item([in] long Index, [out, retval] VARIANT* retval);

	[propget, restricted, id(DISPID_NEWENUM),
		helpstring("returns an enumerator for the collection.")]	// Must be propget. 
	HRESULT _NewEnum([out, retval] IUnknown** retval);	
};



// CAdapters

[
	coclass,
	threading("single"),
	support_error_info("IAdapters"),
	aggregatable("never"),
	vi_progid("NetSim.Adapters"),
	progid("NetSim.Adapters.1"),
	version(1.0),
	uuid("07DAA0FE-89D3-424C-951B-686C930B1138"),
	helpstring("Adapters Class")
]
class ATL_NO_VTABLE CAdapters : 
	public IAdapters
{
public:
	CAdapters()
	{
	}


	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct();
	
	void FinalRelease() 
	{
	}

public:
	STDMETHOD(get_Count)(long* retval);
	STDMETHOD(get_Item)(long Index, VARIANT* retval);
	STDMETHOD(get__NewEnum)(IUnknown** retval);
private:
	AdaptersVec m_vAdapters;
};

