// Bridge.h : Declaration of the CBridge

#pragma once
#include "resource.h"       // main symbols
#include "comutil.h"

#include "IPBridgeImpl.h"

interface IDevice;

_COM_SMARTPTR_TYPEDEF(IDevice, __uuidof(IDevice));

// IBridge
[
	object,
	uuid("60EF66D9-A656-4AF6-9332-049F73AC06DE"),
	dual,	helpstring("IBridge Interface"),
	pointer_default(unique)
]
__interface IBridge : IDispatch
{
	[id(1), helpstring("method Start")] HRESULT Start(void);
	[id(2), helpstring("method Stop")] HRESULT Stop(void);
	[propget, id(3), helpstring("property devTargetSide")] HRESULT devTargetSide([out, retval] IDevice** pVal);
//	[propput, id(3), helpstring("property devTargetSide")] HRESULT devTargetSide([in] IDispatch* newVal);
	[propget, id(4), helpstring("property devSourceSide")] HRESULT devSourceSide([out, retval] IDevice** pVal);
//	[propput, id(4), helpstring("property devSourceSide")] HRESULT devSourceSide([in] IDispatch* newVal);
	[propget, id(5), helpstring("property TargetIP")] HRESULT TargetIP([out, retval] BSTR* pVal);
	[propput, id(5), helpstring("property TargetIP")] HRESULT TargetIP([in] BSTR newVal);
};



// CBridge

[
	coclass,
	threading("apartment"),
	support_error_info("IBridge"),
	aggregatable("never"),
	vi_progid("NetSim.Bridge"),
	progid("NetSim.Bridge.1"),
	version(1.0),
	uuid("F123D08B-8E53-47D4-A777-FF7DD75C9B84"),
	helpstring("Bridge Class")
]
class ATL_NO_VTABLE CBridge : 
	public IBridge
{
public:
	CBridge()
	{
	}


	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct();
	
	
	void FinalRelease() 
	{
	}

public:

	STDMETHOD(Start)(void);
	STDMETHOD(Stop)(void);
	STDMETHOD(get_devTargetSide)(IDevice** pVal);

public:
	STDMETHOD(get_devSourceSide)(IDevice** pVal);
public:
	STDMETHOD(get_TargetIP)(BSTR* pVal);
	STDMETHOD(put_TargetIP)(BSTR newVal);
private:
	_bstr_t m_bstrTargetSideDevice;
	_bstr_t m_bstrSourceSideDevice;
	_bstr_t m_bstrTargetIP;
	IDevicePtr m_pTargetSideDevice;
	IDevicePtr m_pSourceSideDevice;
	DeviceConfig m_dcTargetSideConfig;
	DeviceConfig m_dcSourceSideConfig;
	CIPBridgeImpl m_IPBridge;
};

