#ifndef _PROTOCOLSDEFS_H_
#define _PROTOCOLSDEFS_H_
/* Ethernet protocol ID's */
#define	ETHERTYPE_IP		0x0008		/* IP */
#define	ETHERTYPE_ARP		0x0608		/* Address resolution */
#define	ETHERTYPE_REVARP	0x3580		/* Reverse ARP */


#define ETH_ALEN		6
#define IP_ALEN			4

struct ether_addr
{
  char ether_addr_octet[ETH_ALEN];
};

/* 10Mb/s ethernet header */
struct ether_header
{
  unsigned char	ether_dhost[ETH_ALEN];	/* destination eth addr	*/
  unsigned char	ether_shost[ETH_ALEN];	/* source ether addr	*/
  unsigned short ether_type;		    /* packet type ID field	*/
};




#endif _PROTOCOLSDEFS_H_