#pragma once
#include <string>									// std::string
#include "tinyxml/tinyxml.h"			// TiXmlDocument
#include <map>										// STL map<>


class CExcelWorksheetRef
{
public:
	// constructor
	CExcelWorksheetRef();	

	void SetRef( TiXmlNode *nodeTableWorksheet );	

	// only works on empty worksheets, overwriting cells does not work reliably
	// dwX 0..
	// dwY 0..
	void SetStringValueAt( const uint32 dwX, const uint32 dwY, const char *szString,
		const char *szStyleID=0 );

	// only works on empty worksheets, overwriting cells does not work reliably
	// dwX 0..
	// dwY 0..
	void SetValueAt( const uint32 dwX, const uint32 dwY, const float fValue,
		const char *szStyleID=0 );

	// dwX 0..
	// dwY 0..
	std::string GetValueAt( const uint32 dwX, const uint32 dwY );

	// gracefully ignores the call if ref is not set yet
	void SetColumWidth( const uint32 dwX, const float fExtend );


	void ComputeExtend();

	void ExtendByOneLine();

	// call ComputeExtend() before
	uint32 GetWidth();

	// call ComputeExtend() before
	uint32 GetHeight();

	//	void InsertColumn( const uint32 dwX );

	operator bool() const 
	{
		return m_nodeTableWorksheet!=0;
	}


	// Arguments:
	//   szStyleID - can be 0
	uint32 FindLineBasedOnKey( const std::string sLevelKey, const std::string sEntryKey, const char *szStyleID=0 );

//	void ReadLineAssignments();

	// not case sensitive
	uint32 FindColumn( const char *szColumnName, const uint32 dwDefault=0xffffffff );
	
private: // ----------------------------------------------------------------------------------

	TiXmlNode *											m_nodeTableWorksheet;					//

	std::map<std::string,uint32>		m_LineAssignment;							// [key]=line number, e.g. ["Meshes.Count"] = 10
	uint32													m_dwCurrentLine;							//
	uint32													m_dwLastDestX;								//
	uint32													m_dwLastDestY;								//

	// -----------------------------------------------------------------------------------------

	// creates cells if they don't exist
	// dwX 0..
	// dwY 0..
	TiXmlNode *FindTableCell( const uint32 dwX, const uint32 dwY );

	// useful if you add data to a new worksheet
	void ResetLineAssignments();
};








