#pragma once

#include "tinyxml/tinyxml.h"		// TiXmlDocument
#include <string>								// std::string


class CLevelStats
{
public:
	CLevelStats();

	// Arguments:
	//   szFilename - must not be 0
	bool Load( const char *szFilename );

	//   szFilename - must not be 0
	bool Save( const char *szFilename );

	// Returns:
	//   success e.g. false (not an excel file?)
	bool CopyAndClean( const CLevelStats &rhs );

	// Arguments
	//   szName - must not be 0
	TiXmlNode *WorksheetRef( const char *szName );

	void CreateWorksheet( const char *szName );

	bool IsCreated() const { return m_bCreated; }

private: // -------------------------------------------------------------

	bool								m_bCreated;
	TiXmlDocument				m_Doc;						//

	// --------------------------------------------------

};

