#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: May 2, 2007
## Description: GNU-make based build system
#############################################################################

# Settings specific to the CryCG code analysis and instrumentation tool.

# Filename extension for the generated index files.
ifndef EXT_CCG
 EXT_CCG := ccg
endif

# Filename extension for the generated dependency files.
ifndef EXT_D
 EXT_D := d
endif
ifdef EXT_D_TMP
 ext_d := $(EXT_D_TMP)
else
 ext_d := $(EXT_D)
endif

CRYCG := $(MAKE_TOOLS_BINDIR)/crycg

# FIXME:
# The -R option makes crycg read back the generated CCG file and compare the
# tree hash and CRCs to verify that the serialization worked as expected.
# This increases the running time by a few seconds and should be removed after
# a testing period.
CRYCGFLAGS := \
	-c $(MAKE_ROOT)/Tools/crycg.conf -R \
	-CInputCompiler.C:$(MAKE_TOOLS_BINDIR)/gcc-crycg/bin/gcc \
	-CInputCompiler.C++:$(MAKE_TOOLS_BINDIR)/gcc-crycg/bin/g++ \
	-CSystemIncludeDir:$(MAKE_ROOT)/Tools/crycg/include \
	-CTmpDir:$(BUILD_TEMP) \
	-DTARGET=$(TARGET) -DBUILD_ROOT=$(BUILD_ROOT)
ifneq ($(MKOPTION_VERBOSE),1)
 CRYCGFLAGS += -CLogLevel:notice
endif
ifdef OPTION_PS3_CRYCGFLAGS
 CRYCGFLAGS += $(OPTION_PS3_CRYCGFLAGS)
 $(warning user specified flags for crycg: $(OPTION_PS3_CRYCGFLAGS))
endif

SCAN_CXX = \
	$(CRYCG) scan/c++ $(CRYCGFLAGS) -o '$(3)' \
	  -- $(CFLAGS_SCAN) $(CXXFLAGS_SCAN) $(CPPFLAGS_SCAN) $(4) \
	  -MP -MMD \
	  -MF '$(patsubst %.$(EXT_CCG),%.$(ext_d),$(3))' \
	  -MQ '$(3)' \
	  -o '$(patsubst %.$(EXT_CCG),%.s,$(3))' \
	  '$(2)' && rm -f '$(patsubst %.$(EXT_CCG),%.s,$(3))'

SCAN_C = \
	$(CRYCG) scan/c $(CRYCGFLAGS) -o '$(3)' \
	  -- $(CFLAGS_SCAN) $(CXXFLAGS_SCAN) $(CPPFLAGS_SCAN) $(4) \
	  -MP -MMD \
	  -MF '$(patsubst %.$(EXT_CCG),%.$(ext_d),$(3))' \
	  -MQ '$(3)' \
	  -o '$(patsubst %.$(EXT_CCG),%.s,$(3))' \
	  '$(2)' && rm -f '$(patsubst %.$(EXT_CCG),%.s,$(3))'

SCAN_MODULE_NAME = $(addsuffix .ccgindex,$(1))

SCAN_PROGRAM_NAME = $(addsuffix .ccgindex,$(1))

SCAN_MODULE_CLEAN = \
	$(call SCAN_MODULE_NAME,$(1)) \
	$(addsuffix .elt,$(1))

SCAN_PROGRAM_CLEAN = \
	$(call SCAN_PROGRAM_NAME,$(1)) \
	$(addsuffix .elt,$(1))

# Convert the output filename of a scan pass to the name of the associated
# element file.
SCAN_OUTPUT_TO_ELEMENT = $(patsubst %.ccgindex,%.elt,$(1))

SCANINDEX_MODULE = \
	$(CRYCG) index $(CRYCGFLAGS) -o '$(1)' $(2)

SCANINDEX_PROGRAM = \
	$(CRYCG) index $(CRYCGFLAGS) \
	  -o '$(1)' \
	  -E '$(call SCAN_OUTPUT_TO_ELEMENT,$(1))' \
	  $(2)

# Arch/CryCG.mk
# vim:ts=8:sw=2

