#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Jul 31, 2006
## Description: GNU-make based build system
#############################################################################

# GCC specific settings.

# Filename extension for compiled object files.
ifndef EXT_O
 EXT_O := o
endif

# Filename extension for precompiled header files.
ifndef EXT_PCH
 EXT_PCH := h.gch
endif

# Add -fPIC for shared modules.  However, on PS3 PPU, -fPIC may _not_ be used.
ifeq ($(OPTION_MODULE_LINKMODE),shared)
 ifneq ($(ARCH),PS3-cell)
  ARCH_CFLAGS += -fPIC
 endif
endif

# Filename extension for generated dependency files.
ifndef EXT_D
 EXT_D := d
endif
ifdef EXT_D_TMP
 ext_d := $(EXT_D_TMP)
else
 ext_d := $(EXT_D)
endif

# Support for ccache and distcc.
ifeq ($(MKOPTION_CCACHE),1)
 CCACHE ?= ccache
 ifeq ($(MKOPTION_DISTCC),1)
  # Note: The CCACHE_PREFIX environment variable (typically used to invoke
  # 'distcc' from 'ccache') causes problems with the compilers from the Cell
  # SDK, so we're simply embedding the 'distcc' call into the 'ccache' call.
  DISTCC ?= distcc
  CCACHE_PREFIX := $(DISTCC)
  export CCACHE_PREFIX
  CPREFIX := $(CCACHE)
 else
  CPREFIX := $(CCACHE)
 endif
else
 ifeq ($(MKOPTION_DISTCC),1)
  DISTCC ?= distcc
  CPREFIX := $(DISTCC)
 endif
endif
CPREFIX ?=
ifeq ($(MKOPTION_DISTCC),1)
 # Distributed builds do not gain from PCHs, so we'll disable them when
 # building with DISTCC.
 MKOPTION_NOPCH := 1
 # For distributed builds, we must rely on the compiler being in the
 # executable search path of the machine running the compiler.
 CPREFIX_CXX := $(CPREFIX) $(notdir $(CXX))
 CPREFIX_CC := $(CPREFIX) $(notdir $(CC))
else
 CPREFIX_CXX := $(CPREFIX) $(CXX)
 CPREFIX_CC := $(CPREFIX) $(CC)
endif

# Compile functions.
COMPILE_CXX = \
	$(CPREFIX_CXX) $(CFLAGS) $(CXXFLAGS) $(CPPFLAGS) $(4) \
	  -MP -MMD \
	  -MF '$(patsubst %.$(EXT_O),%.$(ext_d),$(3))' \
	  -MQ '$(3)' \
	  -c '$(2)' -o '$(3)'
COMPILE_C = \
	$(CPREFIX_CC) $(CFLAGS) $(CPPFLAGS) $(4) \
	  -MP -MMD \
	  -MF '$(patsubst %.$(EXT_O),%.$(ext_d),$(3))' \
	  -MQ '$(3)' \
	  -c '$(2)' -o '$(3)'
COMPILE_PCH = \
	$(CXX) -w $(CFLAGS) $(CXXFLAGS) $(CPPFLAGS) $(4) \
	  -MP -MMD \
	  -MF '$(patsubst %.$(EXT_PCH),%.h.$(ext_d),$(3))' \
	  -MQ '$(3)' \
	  -c '$(2)' -o '$(3)'

# 'module' projects.
LINK_MODULE_NAME_shared = $(addsuffix .so,$(1))
LINK_MODULE_NAME_static = $(addsuffix .o,$(1))
ifeq ($(OPTION_MODULE_LINKMODE),shared)
 # When linking a module to a shared object, we'll include the project
 # specific libraries but skip the rest.  Everyting in $(LDLIBS) will be
 # linked to the final program executable, so there's no need to add this
 # here.
 COMPILE_MODULE_NAME :=
 COMPILE_MODULE :=
 LINK_MODULE_NAME = $(LINK_MODULE_NAME_shared)
 LINK_MODULE = $(CXX) $(PROJECT_LDFLAGS) -shared $(LDSFLAGS) -o $(1) $(2) \
	$(PROJECT_LDLIBS)
endif # OPTION_MODULE_LINKMODE == shared
ifeq ($(OPTION_MODULE_LINKMODE),static)
 # Static linking using 'ld -r'.
 COMPILE_MODULE_NAME :=
 COMPILE_MODULE :=
 LINK_MODULE_NAME = $(LINK_MODULE_NAME_static)
 # Note that we don't add libraries to the invocation when linking a module
 # statically.
 LINK_MODULE = $(LD) -r $(LDRFLAGS) $(PROJECT_LDFLAGS) -o '$(1)' $(2)
endif # OPTION_MODULE_LINKMODE == static
ifndef LINK_MODULE
 $(error Unrecognized module link mode '$(OPTION_MODULE_LINKMODE)')
endif

# 'program' projects.
COMPILE_PROGRAM_NAME :=
COMPILE_PROGRAM :=
LINK_PROGRAM_NAME = $(1)
LINK_PROGRAM = $(CXX) $(LDFLAGS) -o '$(1)' $(2) $(LDLIBS)

# Some GCC specifics.
ARCH_CPPFLAGS += -D__COUNTER__=__LINE__
ifneq ($(STAGE),gccxml)
 ARCH_CPPFLAGS += -Winvalid-pch
endif

# User specific code enabled via USER_$(USERNAME).
ifneq ($(OPTION_USER),)
 ARCH_CPPFLAGS += -DUSER_$(shell echo -n '$(OPTION_USER)' |tr a-z A-Z)
endif

# Handle build options.
ifeq ($(OPTION_DEBUG),1)
 ifneq ($(OPTION_NODEBUGSYM),1)
  ARCH_CFLAGS += -g
  ARCH_LDFLAGS += -g
  ARCH_LDRFLAGS += -g
 endif
endif # OPTION_DEBUG

ARCH_CFLAGS += -fvisibility=hidden

ifeq ($(OPTION_GPROF),1)
 ARCH_CFLAGS += -pg
 ARCH_LDFLAGS += -pg
 ARCH_CPPFLAGS += -D__GPROF__
endif
ifneq ($(OPTION_DEBUG),1)
 ifneq ($(OPTION_NODEBUGSYM),1)
  ARCH_CFLAGS += -g
 endif
endif # !OPTION_DEBUG

ifeq ($(OPTION_RELEASE),1)
 ARCH_XFLAGS += -O3
endif

# Indicate that the compiler is GCC.
COMPILER_IS_GCC := 1

# Arch/GCC.mk
# vim:ts=8:sw=8

