#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Jul 31, 2006
## Description: GNU-make based build system
#############################################################################

# Architecture specific makefile for Linux systems in general.

# Build tools.
CC := cc
CXX := c++
GCCXML := gccxml
MAKEDEPEND := makedepend

COMPRESS := gzip
EXT_Z := .gz

TOUCH := touch
MKDIR_P := mkdir -p
PERL := perl

# Warning flags.
warn_cflags := -Wformat -Wmissing-braces -Wreturn-type \
	-Wno-multichar -Wsequence-point
ifneq ($(STAGE),gccxml)
warn_cxxflags := -Wno-invalid-offsetof
else
warn_cxxflags :=
endif

# Architecture specific command flags.
ARCH_CFLAGS := $(warn_cflags)
ARCH_CXXFLAGS := $(warn_cxxflags) \
	-fpermissive -fms-extensions -fno-rtti -fno-exceptions
ARCH_CPPFLAGS := -DLINUX -DENABLE_TYPE_INFO
ARCH_CXXFLAGS_module := -fvisibility=hidden -fvisibility-inlines-hidden
ARCH_LDFLAGS :=
ARCH_LDLIBS := -ldl -lpthread -lncurses
ARCH_XFLAGS :=

include $(MAKE_ROOT)/Arch/GCC.mk

# Arch/Linux.mk
# vim:ts=8:sw=8

