#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Jul 31, 2006
## Description: GNU-make based build system
#############################################################################

# Architecture specific makefile for PS3.

# Default option values.
default_OPTION_PS3_GCSECTIONS := 1
default_OPTION_PS3_SNTUNER := 0
default_OPTION_PS3_GCMHUD := 0
default_OPTION_PS3_GCMDEBUG := 0
default_OPTION_PS3_SPU_PROFILE := 0
default_OPTION_PS3_NOMEMMAN := 1
default_OPTION_PS3_NOPRXEXPORTPICKUP := 1
default_OPTION_PS3_PRXSTRIP := 1
default_OPTION_PS3_SPU_SNDEBUG := 1
default_OPTION_PS3_SPU_NO_BRANCH_HINT := 0

# Select the CELL SDK to be used.
# We'll the Cell SDK from Code/SDKs/PS3, even if $(CELL_SDK) is specified (via
# environment or explicit override request).
# If you really want to use another Cell SDK, point $(CELL_SDK) to the
# alternative SDK and set $(CELL_SDK_OVERRIDE) to 1.
set_cell_sdk := 0
override_cell_sdk := 0
ifneq ($(origin CELL_SDK),undefined)
 ifeq ($(CELL_SDK_OVERRIDE),1)
  $(warning CELL_SDK override requested, using CELL_SDK=$(CELL_SDK))
 else
  set_cell_sdk := 1
  override_cell_sdk := 1
 endif
else
 set_cell_sdk := 1
endif

ifeq ($(set_cell_sdk),1)
 ifneq ($(origin DEPOT_MAIN),undefined)
  cell_sdk := $(DEPOT_MAIN)/Code/SDKs/PS3/cell
 else
  cell_sdk := $(CODE_ROOT)/SDKs/PS3/cell
 endif
 #ifeq ($(override_cell_sdk),1)
 # ifneq ($(cell_sdk),$(CELL_SDK))
 #  $(warning using CELL_SDK=$(cell_sdk))
 # endif
 #endif
 CELL_SDK := $(cell_sdk)
endif # set_cell_sdk

export CELL_SDK

cell_tooldir := $(CELL_SDK)/$(HOST_BINDIR)

# Build tools (PPU).
CC := $(cell_tooldir)/ppu/bin/ppu-lv2-gcc
CXX := $(cell_tooldir)/ppu/bin/ppu-lv2-g++
LD := $(cell_tooldir)/ppu/bin/ppu-lv2-ld
OBJCOPY := $(cell_tooldir)/ppu/bin/ppu-lv2-objcopy
STRIP := $(cell_tooldir)/ppu/bin/ppu-lv2-strip
NM := $(cell_tooldir)/ppu/bin/ppu-lv2-nm
AR := $(cell_tooldir)/ppu/bin/ppu-lv2-ar
RANLIB := $(cell_tooldir)/ppu/bin/ppu-lv2-ranlib

# Build tools for PRX support.
STRIP_PRX := $(cell_tooldir)/bin/ppu-lv2-prx-strip

# Build tools (SPU).
CC_SPU := $(cell_tooldir)/spu/bin/spu-lv2-gcc
CXX_SPU := $(cell_tooldir)/spu/bin/spu-lv2-g++
LD_SPU := $(cell_tooldir)/spu/bin/spu-lv2-ld
NM_SPU := $(cell_tooldir)/spu/bin/spu-lv2-nm

# Generic CELL SDK build tools.
MAKE_FSELF := $(cell_tooldir)/bin/make_fself

# Other build tools.
PERL := perl -I'$(MAKE_ROOT)/Tools'

# Build tools info (PPU).
gcc_version_tool := \
	$(PERL) $(MAKE_ROOT)/Tools/gcc_version.pl -a ppu-lv2 -m -p GCC_
ifdef MKOPTION_PS3_GCC_VERSION
 GCC_VERSION := $(MKOPTION_PS3_GCC_VERSION)
else
 $(eval $(shell $(gcc_version_tool) -qversion $(CC)))
endif
ifdef MKOPTION_PS3_GCC_LIBDIR
 GCC_LIBDIR := $(MKOPTION_PS3_GCC_LIBDIR)
else
 $(eval $(shell $(gcc_version_tool) -qlibdir $(CC)))
endif
ifdef MKOPTION_PS3_GCC_LIBEXECDIR
 GCC_LIBEXECDIR := $(MKOPTION_PS3_GCC_LIBEXECDIR)
else
 $(eval $(shell $(gcc_version_tool) -qlibexecdir $(CC)))
endif

# Warning flags.
warn_cflags := -Wformat -Wmissing-braces -Wreturn-type \
	-Wno-multichar -Wsequence-point
warn_cxxflags := -Wno-invalid-offsetof

# Architecture specific command flags.
ARCH_CFLAGS_COMMON = $(warn_cflags) -fsigned-char
ARCH_CFLAGS = \
	-fsigned-char -mminimal-toc -maltivec -mno-gen-microcode
ARCH_CFLAGS_SPU_COMMON = \
	-ffixed-70 -ffixed-71 \
	-ffixed-73 -ffixed-74 -ffixed-75 \
	-ffixed-76 -ffixed-77 -ffixed-78 \
	-ffixed-79 \
	-mdouble=fast
	
# If to use the spu profiling lib, define flags for PPU and SPU
ifeq ($(OPTION_PROFILE),1)	
	ifeq ($(OPTION_PS3_SPU_PROFILE),1)
		ARCH_CFLAGS_SPU_COMMON += -DDO_SPU_PROFILING
		ARCH_CFLAGS += -DDO_SPU_PROFILING
	endif	
endif	

ARCH_CFLAGS_SPU = $(ARCH_CFLAGS_SPU_COMMON)
ARCH_CFLAGS_SPUJOB = $(ARCH_CFLAGS_SPU_COMMON) -fPIC
ARCH_CFLAGS_SCAN =

ARCH_CXXFLAGS_COMMON = \
	$(warn_cxxflags) \
	-fpermissive -fms-extensions -fno-rtti -fno-exceptions
	
ARCH_CXXFLAGS = 
ARCH_CXXFLAGS_SPU =
ARCH_CXXFLAGS_SPUJOB = 
ARCH_CXXFLAGS_SCAN =

#ifneq "$(MKOPTION_PS3_SPU_GCC_VERSION)" "4.0.2"
#	ARCH_CXXFLAGS_SPUJOB += -fwhole-program
#endif

ifeq "$(OPTION_WHOLE_PROJECT)" "1"
#	ARCH_CXXFLAGS += -fwhole-program
endif

ARCH_CPPFLAGS_COMMON = \
	-DPS3 -DNO_VECIDX -DENABLE_TYPE_INFO
ifeq ($(OPTION_PS3_OPTIMIZED_CODE),1)
 ARCH_CPPFLAGS_COMMON += -DPS3OPT
endif
ARCH_CPPFLAGS =
ARCH_CPPFLAGS_SPU = -D__SPU__
ARCH_CPPFLAGS_SPUJOB = \
	-DSPU_CACHE_MISS_USE_ASM \
	-D_SPU_JOB -include SPU/SPUJob.h
ifneq ($(OPTION_PS3_SPU_NO_BRANCH_HINT),1)	
	ARCH_CPPFLAGS_SPUJOB += -DSUPP_BRANCH_HINTS
else	
	ARCH_CPPFLAGS_SPUJOB += -msafe-hints
endif
	
ARCH_CPPFLAGS_SCAN = -D__SPU__ -D__CRYCG__
ifneq ($(OPTION_PS3_SPU_ASSERT),1)
 ARCH_CPPFLAGS_SPUJOB += -D_NO_SPU_ASSERT
endif
ifneq ($(OPTION_PS3_SPUCACHE_ASSERT),1)
 ARCH_CPPFLAGS_SPUJOB += -D_NO_SPU_CACHE_ASSERT
endif
ifneq ($(OPTION_PS3_SPUCACHE_HAZARD_CHECK),1)
 ARCH_CPPFLAGS_SPUJOB += -D_NO_SPU_CACHE_HAZ_CHECK
endif

ARCH_LDFLAGS = \
	-L$(GCC_LIBDIR)/fno-exceptions/fno-rtti \
	-L$(CELL_SDK)/target/ppu/lib/fno-exceptions/fno-rtti
ARCH_LDRFLAGS =
ARCH_LDLIBS =

ARCH_XFLAGS_COMMON =
ARCH_XFLAGS =
ARCH_XFLAGS_SPU_COMMON =
ARCH_XFLAGS_SPU = $(ARCH_XFLAGS_SPU_COMMON)
ARCH_XFLAGS_SPUJOB = $(ARCH_XFLAGS_SPU_COMMON)
ARCH_XFLAGS_SCAN =
ifneq ($(OPTION_DEBUG),1)
 ARCH_XFLAGS = -Os -ffast-math -fstrict-aliasing -fschedule-insns2
 ARCH_CPPFLAGS_COMMON += -DNDEBUG
endif
ifeq ($(OPTION_DEBUG),1)
 #OPTION_PS3_NOMEMMAN := 1
endif
#scan should optimize regardless of actuall backend optimization flags
ARCH_XFLAGS_SCAN += -O3 -fno-inline
ifneq ($(OPTION_PS3_SPU_NOOPTIMIZE),1)
 ARCH_CPPFLAGS_COMMON += -DPS3_SPUOPT
 ARCH_XFLAGS_SPU_COMMON += \
	-O3 -ffast-math -finline-functions-called-once \
	-fgcse-after-reload -fstrict-aliasing -fomit-frame-pointer \
	-DPS3_SPUOPT
 ifeq ($(OPTION_DEBUG),1)
  ARCH_CPPFLAGS_SPU += -DNDEBUG
  ARCH_CPPFLAGS_SPUJOB += -DNDEBUG
  ARCH_CPPFLAGS_SCAN += -DNDEBUG
 endif
else
 ARCH_XFLAGS_SPU_COMMON += \
  -O0 -finline-functions -fdefault-inline -fif-conversion -fif-conversion2\
  -funit-at-a-time -fmerge-constants
endif

# Memory manager.
ifndef OPTION_PS3_NOMEMMAN
 OPTION_PS3_NOMEMMAN = $(default_OPTION_PS3_NOMEMMAN)
endif
ifeq ($(OPTION_PS3_NOMEMMAN),1)
 ARCH_CPPFLAGS_COMMON += -DNOT_USE_CRY_MEMORY_MANAGER
endif

# PS3 job manager.
ifdef DEPOT_MAIN
 ps3_jobman_dir := $(DEPOT_MAIN)/Code/Tools/PS3JobManager
else
 ps3_jobman_dir := $(CODE_ROOT)/Tools/PS3JobManager
endif
ARCH_CPPFLAGS_COMMON += -I$(ps3_jobman_dir)

ifeq ($(OPTION_PS3_SPU_SNDEBUG),1)
 ARCH_XFLAGS_SPU_COMMON += -g -DSUPP_SN -I$(ps3_jobman_dir)/lib
 ARCH_CPPFLAGS_COMMON += -DSUPP_SN
endif

# SN Systems build tools.
SPUMODGEN := \
	$(DEPOT_MAIN)/Code/Tools/PS3JobManager/lib/$(HOST_BINDIR)/spumodgen

# SNTuner support.
ifndef OPTION_PS3_SNTUNER
 OPTION_PS3_SNTUNER := $(default_OPTION_PS3_SNTUNER)
endif
ARCH_LDFLAGS_program += -L$(ps3_jobman_dir)/lib
ps3_link_prof_stub := 0
ifeq ($(OPTION_GPROF),1)
 ps3_link_prof_stub := 1
endif
ifeq ($(OPTION_PROFILE),1)
 ps3_link_prof_stub := 1
endif
ifeq ($(OPTION_DEBUG),1)
 ps3_link_prof_stub := 1
endif
ifeq ($(ps3_link_prof_stub),1)
 ARCH_LDLIBS_program += -Wl,--whole-archive -lprof_stub -Wl,--no-whole-archive
endif
ps3_jobman_lib := cryjobmanspu
ifeq ($(OPTION_PS3_SPU_PROFILE),1)
  ps3_jobman_lib := cryjobmanspu_profile
endif	
ARCH_LDLIBS_program += -l$(ps3_jobman_lib)
ARCH_LIBDEPS_program += $(ps3_jobman_dir)/lib/lib$(ps3_jobman_lib).a
ifeq ($(OPTION_PS3_SNTUNER),1)
 ARCH_CPPFLAGS += -DSNTUNER
 ARCH_LDLIBS_program += -lsntuner
endif
ARCH_LDLIBS_program += -lsn

# GCM HUD support.
ifndef OPTION_PS3_GCMHUD
 OPTION_PS3_GCMHUD := $(default_OPTION_PS3_GCMHUD)
endif
ifeq ($(OPTION_PS3_GCMHUD),1)
 ARCH_CPPFLAGS_COMMON += -DCRY_USE_GCM_HUD
endif

ifeq ($(OPTION_PS3_GCMDEBUG),1)
 ARCH_CPPFLAGS_COMMON += -DCELL_GCM_DEBUG
endif

# GCM command buffer checking.
gcmdebug_cmdbuffercheck :=
ifndef OPTION_PS3_GCMDEBUG_CMDBUFFERCHECK
 OPTION_PS3_GCMDEBUG_CMDBUFFERCHECK := 0
 gcmdebug_cmdbuffercheck := 0
else
 ifeq ($(OPTION_PS3_GCMDEBUG_CMDBUFFERCHECK),1)
  # Basic checking.
  gcmdebug_cmdbuffercheck := 1
 else
  ifeq ($(OPTION_PS3_GCMDEBUG_CMDBUFFERCHECK),2)
   gcmdebug_cmdbuffercheck := 2
  endif
 endif
endif
ifeq ($(gcmdebug_cmdbuffercheck),)
 $(warning Invalid value for OPTION_PS3_GCMDEBUG_CMDBUFFERCHECK)
 gcmdebug_cmdbuffercheck := 0
endif

ifneq ($(gcmdebug_cmdbuffercheck),0)
 ARCH_CPPFLAGS_COMMON += -DGCM_DEBUG_CMDBUFFER
 ifeq ($(gcmdebug_cmdbuffercheck),2)
  ARCH_CPPFLAGS_COMMON += -DGCM_DEBUG_CMDBUFFER_FULL
 endif
endif

ifndef OPTION_PS3_NOPRXEXPORTPICKUP
 OPTION_PS3_NOPRXEXPORTPICKUP := $(default_OPTION_PS3_NOPRXEXPORTPICKUP)
endif
ifndef OPTION_PS3_PRXSTRIP
 OPTION_PS3_PRXSTRIP := $(default_OPTION_PS3_PRXSTRIP)
endif

# For PS3 the generated program file has the extension .elf (following the
# Cell SDK convention).
PROGRAM_NAME = $(addsuffix .elf,$(1))

DEFAULT_STAGES := compile link

# Arch/PS3-cell.mk
# vim:ts=8:sw=2

