#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Wed Jun 27, 2007
## Description: GNU-make based build system
#############################################################################

# PRX support.
ifeq ($(OPTION_PS3_PRX),1)
 ifeq ($(PROJECT_PS3_PRX),1)
  ifneq ($(OPTION_PS3_PRX_$(TARGET)),1)
   $(error PRX config mismatch for target $(TARGET))
  endif
 else # PROJECT_PS3_PRX
  ifeq ($(OPTION_PS3_PRX_$(TARGET)),1)
   $(error PRX config mismatch for target $(TARGET))
  endif
 endif # PROJECT_PS3_PRX
else # else OPTION_PS3_PRX
 ARCH_CPPFLAGS += -DPS3_NOPRX
endif # else OPTION_PS3_PRX

ifeq ($(OPTION_PS3_PRX_$(TARGET)),1)
 ARCH_CPPFLAGS += -DPS3_PRX
 OPTION_MODULE_LINKMODE := shared
 ifeq ($(PROJECT_TYPE),module)
  PROJECT_SOURCES_CPP_ADD += $(TARGET)_PRX.cpp
 endif # PROJECT_TYPE == module
else
 ARCH_CPPFLAGS += -D_LIB
 OPTION_MODULE_LINKMODE := static
endif
export OPTION_MODULE_LINKMODE

ifeq ($(PROJECT_TYPE),module)
 PROJECT_STUB_SOURCES_CPP += $(TARGET)_PRX.cpp
endif

output_suffix :=
ifeq ($(origin OPTION_PS3_OUTPUT_SUFFIX),undefined)
 ifeq ($(OPTION_DEBUG),1)
  output_suffix := $(output_suffix)_debug
 endif
 ifeq ($(OPTION_PROFILE),1)
  output_suffix := $(output_suffix)_profile
 endif
 ifeq ($(OPTION_GPROF),1)
  output_suffix := $(output_suffix)_gprof
 endif
else
 output_suffix := $(OPTION_PS3_OUTPUT_SUFFIX)
endif
ifeq ($(strip $(OPTION_PS3_OUTPUT_DIR)),)
 output_dir := $(CODE_ROOT)/../BinPS3
else
 output_dir := $(OPTION_PS3_OUTPUT_DIR)
endif

ARCH_CPPFLAGS += -DPS3_OUTPUT_SUFFIX=\"$(output_suffix)\"

# When building on Windows we'll need to fix the generated dependency files
# for Cygwin.  We'll do that by extending the COMPILE_* functions.
ifeq ($(HOST_SYSTEM),Windows)
 option_fixdeps := 1
else
 option_fixdeps := 0
endif

ifeq ($(option_fixdeps),1)
 EXT_D_TMP := d_
endif

include $(MAKE_ROOT)/Arch/GCC.mk
include $(MAKE_ROOT)/Arch/CryCG.mk
include $(MAKE_ROOT)/Arch/PRX.mk

ifeq ($(OPTION_PS3_PRX_$(TARGET)),1)
 ifneq ($(COMPILER_IS_GCC),1)
  $(error PRX supported only with GCC)
 endif
endif

# Support for SPU compiling.  The SPU compiler relevant variables and
# functions are tagged with an _SPU suffix.
ifeq ($(MKOPTION_DISTCC),1)
 # For distributed builds, we must rely on the compiler being in the
 # executable search path of the machine running the compiler.
 CPREFIX_CXX_SPU := $(CPREFIX) $(notdir $(CXX_SPU))
 CPREFIX_CC_SPU := $(CPREFIX) $(notdir $(CC_SPU))
else
 CPREFIX_CXX_SPU := $(CPREFIX) $(CXX_SPU)
 CPREFIX_CC_SPU := $(CPREFIX) $(CC_SPU)
endif
ifeq ($(COMPILER_IS_GCC),1)
 # Note that SPU compilation does not create dependency files.
 COMPILE_CXX_SPU = \
	$(CPREFIX_CXX_SPU) \
	  $(CFLAGS_SPU) $(CXXFLAGS_SPU) $(CPPFLAGS_SPU) $(4) \
	  -c '$(2)' -o '$(3)'
 COMPILE_C_SPU = \
	$(CPREFIX_CC_SPU) \
	  $(CFLAGS_SPU) $(CPPFLAGS_SPU) $(4) \
	  -c '$(2)' -o '$(3)'
 COMPILE_CXX_SPUJOB = \
	$(CPREFIX_CXX_SPU) \
	  $(CFLAGS_SPUJOB) $(CXXFLAGS_SPUJOB) $(CPPFLAGS_SPUJOB) $(4) \
	  -c '$(2)' -o '$(3)'
 COMPILE_C_SPUJOB = \
	$(CPREFIX_CC_SPU) \
	  $(CFLAGS_SPUJOB) $(CPPFLAGS_SPUJOB) $(4) \
	  -c '$(2)' -o '$(3)'
else # else COMPILER_IS_GCC
 $(warning SPU compilation currently only supported with GCC)
 COMPILE_C_SPU := echo 'not supported' >&2; false
 COMPILE_CXX_SPU := echo 'not supported' >&2; false
 COMPILE_C_SPUJOB := echo 'not supported' >&2; false
 COMPILE_CXX_SPUJOB := echo 'not supported' >&2; false
endif # else COMPILER_IS_GCC

ifeq ($(option_fixdeps),1)
 fixdeps := $(PERL) "$(MAKE_ROOT)/Tools/fixdeps.pl"
 ifdef CYGWIN_BASEDIR
  fixdeps += -b '$(CYGWIN_BASEDIR)'
 endif
 
 # Note: The '&&' is appended to the COMPILE_* functions unquoted.  The
 # 'fixdeps' part of the command is _not_ passed to the $(BUILD) script and
 # will not be echoed, even if 'MKOPTION_VERBOSE' is set.

 COMPILE_CXX += && $(fixdeps) \
	<'$(patsubst %.$(EXT_O),%.$(EXT_D_TMP),$(3))' \
	>'$(patsubst %.$(EXT_O),%.$(EXT_D),$(3))' \
	&& rm -f '$(patsubst %.$(EXT_O),%.$(EXT_D_TMP),$(3))'

 COMPILE_C += && $(fixdeps) \
	<'$(patsubst %.$(EXT_O),%.$(EXT_D_TMP),$(3))' \
	>'$(patsubst %.$(EXT_O),%.$(EXT_D),$(3))' \
	&& rm -f '$(patsubst %.$(EXT_O),%.$(EXT_D_TMP),$(3))'

 COMPILE_PCH += && $(fixdeps) \
	<'$(patsubst %.$(EXT_PCH),%.h.$(EXT_D_TMP),$(3))' \
	>'$(patsubst %.$(EXT_PCH),%.h.$(EXT_D),$(3))' \
	&& rm -f '$(patsubst %.$(EXT_PCH),%.h.$(EXT_D_TMP),$(3))'

 SCAN_CXX += && $(fixdeps) \
	<'$(patsubst %.$(EXT_CCG),%.$(EXT_D_TMP),$(3))' \
	>'$(patsubst %.$(EXT_CCG),%.$(EXT_D),$(3))' \
	&& rm -f '$(patsubst %.$(EXT_CCG),%.$(EXT_D_TMP),$(3))'

 SCAN_C += && $(fixdeps) \
	<'$(patsubst %.$(EXT_CCG),%.$(EXT_D_TMP),$(3))' \
	>'$(patsubst %.$(EXT_CCG),%.$(EXT_D),$(3))' \
	&& rm -f '$(patsubst %.$(EXT_CCG),%.$(EXT_D_TMP),$(3))'
endif # option_fixdeps == 1

# The name of the (generated) SPU jobs makefile.  The file is generated in the
# post-scan step.
SPUJOBS_MK = $(BUILD_ROOT)/Lib/SPUJobs.mk

# Setup the post-scan steps.
PROJECT_POSTSCAN = $(SILENT) :
ifeq ($(PROJECT_TYPE),program)
 PROJECT_POSTSCAN += \
	&& mkdir -p $(dir $(SPUJOBS_MK)) \
	&& rm -f $(SPUJOBS_MK) \
	&& $(_BUILD_SILENT) $(PERL) '$(MAKE_ROOT)/Tools/postscan.pl' \
	  -E $(call SCAN_OUTPUT_TO_ELEMENT,$(PROJECT_OUTPUT)) \
	  -m $(SPUJOBS_MK) \
	  -t $(TARGET) \
	  -P '$$(BUILD_ROOT)=$(BUILD_ROOT)' \
	  -P '$$(CODE_ROOT)=$(CODE_ROOT)' \
	  -P '$$(PROJECT_CODE)=$(PROJECT_CODE)' \
	&& $(MAKE) \
	  -f "$(COMMON_MK)" \
	  $(MAKE_FLAGS) \
	  $(COMMON_ARGS) \
	  EXEC_PROJECT_POSTSCAN=1 \
	  _exec_project_postscan

 SCAN_CLEAN_$(TARGET) += $(SPUJOBS_MK)
endif # PROJECT_TYPE == program

# For all support stages, the variable $(EXEC_PROJECT_POST) indicate that a
# post stage step is executing.
ifdef EXEC_PROJECT_POSTSCAN
 EXEC_PROJECT_POST := scan
endif
ifdef EXEC_PROJECT_POSTCOMPILE
 EXEC_PROJECT_POST := compile
endif
ifdef EXEC_PROJECT_POSTLINK
 EXEC_PROJECT_POST := link
endif

SPUJOB_REPOSITORY := $(BUILD_ROOT)/Lib/SPURepository.bin

# The post scan is driven by make ($(MAKE) invocation in $(PROJECT_POSTSCAN)).
# The make action is implemented by the _project_postscan target.
#
# At the time the post-scan make invocation is performed, the 'SPUJobs.mk'
# makefile exists.  For all other post-$(STAGE) make invocations, we'll do a
# -include, so the 'compile' and 'link' stages still work even if the build
# does not require a 'scan' stage.
ifdef EXEC_PROJECT_POST

 # $(ps3_jobman_dir) is defined 'PS3-cell.mk'.
 spujob_deps := $(ps3_jobman_dir)/SPU/SPUJob.h
 SPUJOB_JOB_DEPS := $(spujob_deps)
 SPUJOB_PAGE_DEPS := $(spujob_deps)

 ifdef EXEC_PROJECT_POSTSCAN
  # Generated by '$(MAKE_ROOT)/Tools/postscan.pl'.
  include $(SPUJOBS_MK)
 else
  -include $(SPUJOBS_MK)
 endif

 genspujob = $(PERL) '$(MAKE_ROOT)/Tools/genspujob.pl' -i $(PROJECT_OUTPUT)
 ifeq ($(MKOPTION_VERBOSE),1)
  genspujob += -v
 endif
 ifeq ($(HOST_SYSTEM),Windows)
  genspujob += -c
  ifdef CYGWIN_BASEDIR
   genspujob += -b '$(CYGWIN_BASEDIR)'
  endif
 endif
 genspujob += -DTARGET=$(TARGET)
 genspujob += -DBUILD_ROOT=$(BUILD_ROOT)
 genpage = '$(MAKE_TOOLS_BINDIR)/PageGen'

 ifeq ($(OPTION_PS3_SPU_DEBUGDRIVER),1)
  spujob_driver_suffix := _debug
 else
  spujob_driver_suffix := 
  ifeq ($(OPTION_PROFILE),1)	
   ifeq ($(OPTION_PS3_SPU_PROFILE),1)
    spujob_driver_suffix := _profile
   endif
  endif	
 endif
 spujob_driver_lib := -lDriverSPU$(spujob_driver_suffix)

 spujob_link_ldflags = -nostartfiles -L $(ps3_jobman_dir)/lib
 spujob_link_ldlibs =
 ifeq ($(OPTION_PS3_SPU_SNDEBUG),1)
  spujob_link_ldflags += -T $(ps3_jobman_dir)/lib/spu_module.ld -Wl,-q
 endif
 spujob_link_ldflags += \
  -L$(CELL_SDK)/target/spu/lib/pic \
	$(CELL_SDK)/target/spu/lib/pic/libc.a \
	$(CELL_SDK)/target/spu/lib/pic/libstdc++.a \
	$(spujob_driver_lib)
 spujob_linkpage_ldflags = $(spujob_link_ldflags) 
 spujob_linkpage_ldlibs = $(spujob_link_ldlibs)
 spujob_linkexec_ldflags = $(spujob_link_ldflags)
 spujob_linkexec_ldlibs = $(spujob_link_ldlibs)

 SPUJOB_EXECUTE_SYMBOL := Execute

 SPUJOB_GENPAGE = $(genspujob) \
	-o $(1) -E $(2) -j $(3) -x \
	-d $(patsubst %.cpp,%.d,$(1))

 SPUJOB_GENEXEC = $(genspujob) \
	-o $(1) -E $(2) -j $(3) \
	-d $(patsubst %.cpp,%.d,$(1))

 SPUJOB_GENPAGEDESC = \
	$(BUILD_LINK) $(genpage) $(1) \
	  && mv $(patsubst %.o,%_patch.txt,$(1)) $(2)

 SPUJOB_LINKPAGE = \
	$(BUILD_LINK) $(CXX_SPU) \
	  $(CXXFLAGS_SPUJOB) \
	  $(XFLAGS_SPUJOB) \
	  -Wl,-entry=0x20 \
	  -Wl,--start-group $(1) -Wl,--end-group \
	  -o $(2) \
	  $(spujob_linkpage_ldflags) \
	  $(spujob_linkpage_ldlibs)

 SPUJOB_LINKEXEC = \
	$(BUILD_LINK) $(CXX_SPU) \
	  $(CXXFLAGS_SPUJOB) \
	  $(CFLAGS_SPUJOB) \
	  -Wl,-entry=$(SPUJOB_EXECUTE_SYMBOL) \
	  -Wl,--start-group $(1) -Wl,--end-group \
	  -o $(2) \
	  $(spujob_linkexec_ldflags) \
	  $(spujob_linkexec_ldlibs)

 SPUJOB_SN_MODPAGE = $(BUILD_LINK) $(SPUMODGEN) -q $(1) $(2)

 SPUJOB_SN_MODEXEC = $(BUILD_LINK) $(SPUMODGEN) -q $(1) $(2)

 SPUJOB_REPOSITORY_DEPS = \
	$(SPUJOB_PAGEDESC_FILES) \
	$(SPUJOB_JOBDESC_FILES) \
	$(SPUJOB_ELF_FILES) \
	$(SPUJOB_OBJECTS)
	
 ifeq ($(OPTION_PS3_SPU_SNDEBUG),1)	
  SPUJOB_REPOSITORY_DEPS += $(SPUJOB_BIN_FILES)
 endif

 spu_jobgen_options :=
 ifeq ($(MKOPTION_VERBOSE),1)
  spu_jobgen_options += -v
 endif
 ifeq ($(OPTION_PS3_SPU_SNDEBUG),1)
  spu_jobgen_options += -g
 endif
 spu_jobgen_options += \
	-P `cat $(ps3_jobman_dir)/lib/CPMHAddr$(spujob_driver_suffix).txt` \
	-R `cat $(ps3_jobman_dir)/lib/CPRHAddr$(spujob_driver_suffix).txt` \
	-S `cat $(ps3_jobman_dir)/lib/CPSABAddr$(spujob_driver_suffix).txt`

 spu_jobgen_symbol_file = $(BUILD_ROOT)/Lib/$(TARGET)/spujob/Symbols.nm
 spu_jobgen_list_file = $(BUILD_ROOT)/Lib/$(TARGET)/spujob/Files.list
 spu_jobgen_create_list_file = \
	$(PERL) $(MAKE_ROOT)/Tools/echo.pl -l
 ifeq ($(HOST_SYSTEM),Windows)
  spu_jobgen_create_list_file += -c
  ifdef CYGWIN_BASEDIR
   spu_jobgen_create_list_file += -b '$(CYGWIN_BASEDIR)'
  endif
 endif
 spu_jobgen_create_list_file += --

 EXEC_JOBGEN = $(MAKE_TOOLS_BINDIR)/JobGen -i
 ifeq ($(OPTION_PS3_SPU_SNDEBUG),1)
  EXEC_JOBGEN += -g
 endif

$(SPUJOB_REPOSITORY): $(SPUJOB_REPOSITORY_DEPS) $(PROJECT_OUTPUT)
	$(SILENT) mkdir -p $(dir $(SPUJOB_REPOSITORY))
	$(SILENT) mkdir -p $(PROJECT_BUILD)/spujob
	$(SILENT) rm -f $(spu_jobgen_symbol_file)
	$(BUILD_LINK) $(NM) -td --demangle $(PROJECT_OUTPUT) \
	  |grep " [bdrBDR] " \
	  |grep -v " keyed to " \
	  >$(spu_jobgen_symbol_file)
	$(SILENT) rm -f $(spu_jobgen_list_file)
	$(SILENT) $(spu_jobgen_create_list_file) $^ \
	  >$(spu_jobgen_list_file)
	$(BUILD_LINK) \
	  $(EXEC_JOBGEN) \
	    $(spu_jobgen_options) \
	    -l $(spu_jobgen_list_file) \
	    -s $(spu_jobgen_symbol_file) \
	    -o $(SPUJOB_REPOSITORY)
	$(SILENT) rm -f $(spu_jobgen_symbol_file)
	$(SILENT) rm -f $(spu_jobgen_list_file)

 postscan_deps := $(SPUJOB_SOURCES)

 postlink_deps := $(SPUJOB_REPOSITORY)

.PHONY: _exec_project_post$(STAGE)
_exec_project_post$(STAGE): $(post$(STAGE)_deps)
ifneq ($(MKOPTION_COMPACT),1)
	$(SILENT) echo '* Post-$(STAGE) $(TARGET) complete'
endif

else
 -include $(SPUJOBS_MK)
endif # EXECUTE_PROJECT_POST

LINK_CLEAN += \
	$(SPUJOB_REPOSITORY) \
	$(patsubst %.bin,%.log,$(SPUJOB_REPOSITORY))

SPUJOB_ENABLE ?= 0

# Setup the post-link steps.
PROJECT_POSTLINK = $(SILENT) :
ifeq ($(PROJECT_TYPE),program)
 ifeq ($(SPUJOB_ENABLE),1)
  PROJECT_POSTLINK += \
	&& $(MAKE) \
	  -f "$(COMMON_MK)" \
	  $(MAKE_FLAGS) \
	  $(COMMON_ARGS) \
	  EXEC_PROJECT_POSTLINK=1 \
	  PROJECT_OUTPUT='$(PROJECT_OUTPUT)' \
	  _exec_project_postlink \
	&& mkdir -p $(output_dir) \
	&& cp $(SPUJOB_REPOSITORY) $(output_dir)
 endif
endif
ifneq ($(OPTION_PS3_NOMAKEFSELF),1)
 ifeq ($(PROJECT_TYPE),module)
  ifeq ($(OPTION_PS3_PRX_$(TARGET)),1)
   ifeq ($(MKOPTION_PS3_COPYELF),1)
    PROJECT_POSTLINK += \
	&& rm -f $(output_dir)/$(TARGET)$(output_suffix).prx \
	&& cp \
	  $(PROJECT_OUTPUT) \
	  $(output_dir)/$(TARGET)$(output_suffix).prx
   endif
   ifeq ($(OPTION_PS3_PRXSTRIP),1)
    PROJECT_POSTLINK += \
	&& $(_BUILD_LINK) $(STRIP_PRX) $(PROJECT_OUTPUT)
   endif
   PROJECT_POSTLINK += \
	&& $(_BUILD_SILENT) mkdir -p $(output_dir) \
	&& \
	if [ $(PROJECT_OUTPUT) -nt $(output_dir)/$(TARGET)$(output_suffix).sprx ]; \
	then \
	  rm -f $(output_dir)/$(TARGET)$(output_suffix).sprx \
	  && $(_BUILD_LINK) $(MAKE_FSELF) \
	    $(PROJECT_OUTPUT) \
	    $(output_dir)/$(TARGET)$(output_suffix).sprx; \
	fi
   ifeq ($(MKOPTION_PS3_COPYELF),1)
    PROJECT_POSTLINK += \
	&& \
	if [ $(PROJECT_OUTPUT) -nt $(output_dir)/$(TARGET)$(output_suffix).prx ]; \
	then \
	  rm -f $(output_dir)/$(TARGET)$(output_suffix).prx \
	  && cp \
	    $(PROJECT_OUTPUT) \
	    $(output_dir)/$(TARGET)$(output_suffix).prx; \
	fi
   endif
  endif
 endif # PROJECT_TYPE == program
 ifeq ($(PROJECT_TYPE),program)
  PROJECT_POSTLINK += \
	&& $(_BUILD_SILENT) mkdir -p $(output_dir) \
	&& \
	if [ $(PROJECT_OUTPUT) -nt $(output_dir)/$(TARGET)$(output_suffix).self ]; \
	then \
	  rm -f $(output_dir)/$(TARGET)$(output_suffix).self \
	  && $(_BUILD_LINK) $(MAKE_FSELF) \
	    $(PROJECT_OUTPUT) \
	    $(output_dir)/$(TARGET)$(output_suffix).self; \
	fi
  ifeq ($(MKOPTION_PS3_COPYELF),1)
   PROJECT_POSTLINK += \
	&& \
	if [ $(PROJECT_OUTPUT) -nt $(output_dir)/$(TARGET)$(output_suffix).elf ]; \
	then \
	  rm -f $(output_dir)/$(TARGET)$(output_suffix).elf \
	  && cp \
	    $(PROJECT_OUTPUT) \
	    $(output_dir)/$(TARGET)$(output_suffix).elf; \
	fi
  endif
 endif
endif # OPTION_PS3_NOMAKEFSELF != 1


# Add options for function/data sections garbage collection.
ifndef OPTION_PS3_GCSECTIONS
 OPTION_PS3_GCSECTIONS := $(default_OPTION_PS3_GCSECTIONS)
endif
ifeq ($(OPTION_PS3_GCSECTIONS),1)
 ifneq ($(OPTION_PS3_PRX_$(TARGET)),1)
  ARCH_CFLAGS += -ffunction-sections -fdata-sections
 endif
 ARCH_LDFLAGS_program += -Wl,--gc-sections
endif

# Arch/PS3-cell.setup.mk
# vim:ts=8:sw=2

