#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Aug 1, 2006
## Description: GNU-make based build system
#############################################################################

# Common stage preparation code for the build stages.

# All preparation steps are provided as templates.  Evaluation of these
# templates will define a preparation rule and add to the $(PREPARE_DEPS)
# (dependencies to be added to the _prepare target).  The generated files are
# added to the $(FINAL_CLEAN_$(TARGET)) list.

# All templates expect a double evaluation via $(eval $(call ...)).

# The prepare_compile template adds a rule to extract file lists from a VCPROJ
# file.
# Parameters:
# $(1)	The full path to the VCPROJ file.
# $(2)	The prefix to be added to the generated file list variables.
# $(3)	The make include file for the generated file lists.
#
define prepare_compile
FILES_MK := $(PROJECT_BUILD)/$(3)
-include $$(FILES_MK)
$$(FILES_MK): $(1)
	$(SILENT)$(call MSG_READING_VCPROJ,$(1))
	$(SILENT) mkdir -p "$$(dir $$@)"
	$(BUILD_SILENT) $(RM) "$$@"
	$(BUILD_SILENT) $(PERL) "$(MAKE_ROOT)/Tools/extract.pl" \
	  "$$<" "$(PROJECT_CODE)" "$(2)" "$$@"
PREPARE_DEPS := $(PREPARE_DEPS) $$(FILES_MK)
FINAL_CLEAN_$(TARGET) := $(FINAL_CLEAN_$(TARGET)) $$(FILES_MK)
endef

# Lib/prepare.mk
# vim:ts=8:sw=8

