#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Apr 10, 2007
## Description: GNU-make based build system
#############################################################################

# Setup the compilation and linking flags.  This is common setup code for all
# stages requiring a compiler/linker invocations.
#
# The special variable $(FLAGS_SUFFIX) may be specifed to append a special
# suffix to all flag variable names.

ifndef FLAGS_SUFFIX
 FLAGS_SUFFIX :=
endif
ifneq ($(flavor FLAGS_SUFFIX),simple)
 $(error FLAGS_SUFFIX must be a simple variable)
endif

$(eval CFLAGS$(FLAGS_SUFFIX) = \
	$$(ARCH_CFLAGS_COMMON) \
	$$(ARCH_CFLAGS$(FLAGS_SUFFIX)) \
	$$(SOLUTION_CFLAGS_COMMON) \
	$$(SOLUTION_CFLAGS$(FLAGS_SUFFIX)) \
	$$(PROJECT_CFLAGS_COMMON) \
	$$(PROJECT_CFLAGS$(FLAGS_SUFFIX)))
$(eval CXXFLAGS$(FLAGS_SUFFIX) = \
	$$(ARCH_CXXFLAGS_COMMON) \
	$$(ARCH_CXXFLAGS$(FLAGS_SUFFIX)) \
	$$(SOLUTION_CXXFLAGS_COMMON) \
	$$(SOLUTION_CXXFLAGS$(FLAGS_SUFFIX)) \
	$$(PROJECT_CXXFLAGS_COMMON) \
	$$(PROJECT_CXXFLAGS$(FLAGS_SUFFIX)))
$(eval CPPFLAGS$(FLAGS_SUFFIX) = \
	-I$$(PROJECT_BUILD) -I$$(PROJECT_CODE) \
	$$(ARCH_CPPFLAGS_COMMON) \
	$$(ARCH_CPPFLAGS$(FLAGS_SUFFIX)) \
	$$(SOLUTION_CPPFLAGS_COMMON) \
	$$(SOLUTION_CPPFLAGS$(FLAGS_SUFFIX)) \
	$$(PROJECT_CPPFLAGS_COMMON) \
	$$(PROJECT_CPPFLAGS$(FLAGS_SUFFIX)))
$(eval LDFLAGS$(FLAGS_SUFFIX) = \
	$$(ARCH_LDFLAGS_COMMON) \
	$$(ARCH_LDFLAGS$(FLAGS_SUFFIX)) \
	$$(SOLUTION_LDFLAGS_COMMON) \
	$$(SOLUTION_LDFLAGS$(FLAGS_SUFFIX)) \
	$$(PROJECT_LDFLAGS_COMMON) \
	$$(PROJECT_LDFLAGS$(FLAGS_SUFFIX)) \
	-L$$(PROJECT_BUILD)/Lib)
$(eval LDRFLAGS$(FLAGS_SUFFIX) = \
	$$(ARCH_LDRFLAGS_COMMON) \
	$$(ARCH_LDRFLAGS$(FLAGS_SUFFIX)) \
	$$(SOLUTION_LDRFLAGS_COMMON) \
	$$(SOLUTION_LDRFLAGS$(FLAGS_SUFFIX)) \
	$$(PROJECT_LDRFLAGS_COMMON) \
	$$(PROJECT_LDRFLAGS$(FLAGS_SUFFIX)))
$(eval LDSFLAGS$(FLAGS_SUFFIX) = \
	$$(ARCH_LDSFLAGS_COMMON) \
	$$(ARCH_LDSFLAGS$(FLAGS_SUFFIX)) \
	$$(SOLUTION_LDSFLAGS_COMMON) \
	$$(SOLUTION_LDSFLAGS$(FLAGS_SUFFIX)) \
	$$(PROJECT_LDSFLAGS_COMMON) \
	$$(PROJECT_LDSFLAGS$(FLAGS_SUFFIX)) \
	-L$$(PROJECT_BUILD)/Lib)
$(eval LDLIBS$(FLAGS_SUFFIX) = \
	$$(ARCH_LDLIBS_COMMON) \
	$$(ARCH_LDLIBS$(FLAGS_SUFFIX)) \
	$$(SOLUTION_LDLIBS_COMMON) \
	$$(SOLUTION_LDLIBS$(FLAGS_SUFFIX)) \
	$$(PROJECT_LDLIBS_COMMON) \
	$$(PROJECT_LDLIBS$(FLAGS_SUFFIX)))

ifdef PROJECT_XFLAGS$(FLAGS_SUFFIX)
 # The project specific XFLAGS override all other XFLAGS settings (except for
 # per-file XFLAGS, see below).
 # Note that there's no PROJECT_XFLAGS_COMMON!
 $(eval XFLAGS$(FLAGS_SUFFIX) = $$(PROJECT_XFLAGS$(FLAGS_SUFFIX)))
else
 ifdef SOLUTION_XFLAGS$(FLAGS_SUFFIX)
  $(eval XFLAGS$(FLAGS_SUFFIX) = $$(SOLUTION_XFLAGS$(FLAGS_SUFFIX)))
 else
  $(eval XFLAGS$(FLAGS_SUFFIX) = $$(ARCH_XFLAGS$(FLAGS_SUFFIX)))
 endif
endif

# Handle build options for debug/profile/release builds.
ifeq ($(OPTION_DEDICATED),1)
 CPPFLAGS$(FLAGS_SUFFIX) += -DDEDICATED_SERVER
endif
ifeq ($(OPTION_DEBUG),1)
 CPPFLAGS$(FLAGS_SUFFIX) += -D_DEBUG
endif
ifeq ($(OPTION_PROFILE),1)
 CPPFLAGS$(FLAGS_SUFFIX) += -D_PROFILE
endif
ifeq ($(OPTION_RELEASE),1)
 CPPFLAGS$(FLAGS_SUFFIX) += -D_RELEASE -DNDEBUG
endif
ifeq ($(OPTION_WHOLE_PROJECT),1)
 CPPFLAGS$(FLAGS_SUFFIX) += -DWHOLE_PROJECT
 ifeq ($(OPTION_WHOLE_PROJECT_C),1)
  CPPFLAGS$(FLAGS_SUFFIX) + -DWHOLE_PROJECT_C
 endif
endif

# Add module depended architecure specific flags.
ifdef ARCH_CFLAGS_COMMON_$(PROJECT_TYPE)
 $(eval CFLAGS$(FLAGS_SUFFIX) += \
	$$(ARCH_CFLAGS_COMMON_$$(PROJECT_TYPE)))
endif
ifdef ARCH_CFLAGS$(FLAGS_SUFFIX)_$(PROJECT_TYPE)
 $(eval CFLAGS$(FLAGS_SUFFIX) += \
	$$(ARCH_CFLAGS$(FLAGS_SUFFIX)_$$(PROJECT_TYPE)))
endif
ifdef ARCH_CXXFLAGS_COMMON_$(PROJECT_TYPE)
 $(eval CXXFLAGS$(FLAGS_SUFFIX) += \
	$$(ARCH_CXXFLAGS_COMMON_$$(PROJECT_TYPE)))
endif
ifdef ARCH_CXXFLAGS$(FLAGS_SUFFIX)_$(PROJECT_TYPE)
 $(eval CXXFLAGS$(FLAGS_SUFFIX) += \
	$$(ARCH_CXXFLAGS$(FLAGS_SUFFIX)_$$(PROJECT_TYPE)))
endif
ifdef ARCH_CPPFLAGS_COMMON_$(PROJECT_TYPE)
 $(eval CPPFLAGS$(FLAGS_SUFFIX) += \
	$$(ARCH_CPPFLAGS_COMMON_$$(PROJECT_TYPE)))
endif
ifdef ARCH_CPPFLAGS$(FLAGS_SUFFIX)_$(PROJECT_TYPE)
 $(eval CPPFLAGS$(FLAGS_SUFFIX) += \
	$$(ARCH_CPPFLAGS$(FLAGS_SUFFIX)_$$(PROJECT_TYPE)))
endif
ifdef ARCH_LDFLAGS_COMMON_$(PROJECT_TYPE)
 $(eval LDFLAGS$(FLAGS_SUFFIX) += \
	$$(ARCH_LDFLAGS_COMMON_$$(PROJECT_TYPE)))
endif
ifdef ARCH_LDFLAGS$(FLAGS_SUFFIX)_$(PROJECT_TYPE)
 $(eval LDFLAGS$(FLAGS_SUFFIX) += \
	$$(ARCH_LDFLAGS$(FLAGS_SUFFIX)_$$(PROJECT_TYPE)))
endif
ifdef ARCH_LDRFLAGS_COMMON_$(PROJECT_TYPE)
 $(eval LDFLAGS$(FLAGS_SUFFIX) += \
	$$(ARCH_LDRFLAGS_COMMON_$$(PROJECT_TYPE)))
endif
ifdef ARCH_LDRFLAGS$(FLAGS_SUFFIX)_$(PROJECT_TYPE)
 $(eval LDFLAGS$(FLAGS_SUFFIX) += \
	$$(ARCH_LDRFLAGS$(FLAGS_SUFFIX)_$$(PROJECT_TYPE)))
endif
ifdef ARCH_LDSFLAGS_COMMON_$(PROJECT_TYPE)
 $(eval LDFLAGS$(FLAGS_SUFFIX) += \
	$$(ARCH_LDSFLAGS_COMMON_$$(PROJECT_TYPE)))
endif
ifdef ARCH_LDSFLAGS$(FLAGS_SUFFIX)_$(PROJECT_TYPE)
 $(eval LDFLAGS$(FLAGS_SUFFIX) += \
	$$(ARCH_LDSFLAGS$(FLAGS_SUFFIX)_$$(PROJECT_TYPE)))
endif
ifdef ARCH_LDLIBS_COMMON_$(PROJECT_TYPE)
 $(eval LDLIBS$(FLAGS_SUFFIX) += \
	$$(ARCH_LDLIBS_COMMON_$$(PROJECT_TYPE)))
endif
ifdef ARCH_LDLIBS$(FLAGS_SUFFIX)_$(PROJECT_TYPE)
 $(eval LDLIBS$(FLAGS_SUFFIX) += \
	$$(ARCH_LDLIBS$(FLAGS_SUFFIX)_$$(PROJECT_TYPE)))
endif

# Lib/setcflags.mk
# vim:ts=8:sw=8

