#############################################################################
## Crytek Source File
## Copyright (C) 2007, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Thu Jun 28, 2007
## Description: GNU-make based build system
#############################################################################

# Stage makefile for the 'link' stage.

ifdef BUILD_STRIP_PREFIX
 BUILDTOOL += -p $(BUILD_STRIP_PREFIX)/
endif

include $(MAKE_ROOT)/Lib/prepare.mk

ifneq ($(strip $(PROJECT_VCPROJ)),)
 $(eval $(call prepare_compile,\
	$(PROJECT_CODE)/$(PROJECT_VCPROJ),PROJECT_,Files.mk))
else
 PROJECT_SOURCE_DIRS := .
endif

include $(MAKE_ROOT)/Lib/setfiles.mk

# Tag messages for the compile stage operations.
ifneq ($(MKOPTION_COMPACT),1)
 tag_c := C
 tag_cxx := C++
 tag_pch := C++/PCH
 tag_link := LINK
else
 tag_c :=
 tag_cxx :=
 tag_pch :=
 tag_link := Linking
endif

# Convert a source file name into a compiled object file name.  Note that
# these functions are replicated in 'compile.mk'.  Both version must be kept
# in sync.
link_object_cpp = \
	$(subst /../,/,$(PROJECT_BUILD)/$(patsubst %.cpp,%.$(EXT_O),$(1)))
link_object_c = \
	$(subst /../,/,$(PROJECT_BUILD)/$(patsubst %.c,%.$(EXT_O),$(1)))

# Note: We're redefining $(PROJECT_OBJECTS), overriding the $(PROJECT_OBJECTS)
# variable set by 'setfiles.mk' included above.  This is because we're
# building a dummy rule for these objects claiming that they are all up to
# data (see below).  $(PROJECT_OBJECTS_ADD) is handled after the dummy rule
# has been defined, because some of the object files in $(PROJECT_OBJECTS_ADD)
# may have explicit construction rules specified in the 'Project.mk'.
PROJECT_OBJECTS :=
ifneq ($(OPTION_WHOLE_PROJECT),1)

 PROJECT_OBJECTS += \
	$(foreach cppfile,\
	  $(PROJECT_SOURCES_CPP),\
	  $(call link_object_cpp,$(cppfile))) \
	$(foreach cfile,\
	  $(PROJECT_SOURCES_C),\
	  $(call link_object_c,$(cfile)))

else # OPTION_WHOLE_PROJECT != 1

 whole_project_cpp = $(PROJECT_BUILD)/WholeProject_cpp.cpp
 whole_project_cpp_o = $(patsubst %.cpp,%.$(EXT_O),$(whole_project_cpp))
 ifneq ($(strip $(PROJECT_SOURCES_CPP)),)
  PROJECT_OBJECTS += $(whole_project_cpp_o)
 endif
 ifeq ($(OPTION_WHOLE_PROJECT_C),1)
  whole_project_c = $(PROJECT_BUILD)/WholeProject_c.c
  whole_project_c_o = $(patsubst %.c,%.$(EXT_O),$(whole_project_c))
  ifneq ($(strip $(PROJECT_SOURCES_C)),)
   PROJECT_OBJECTS += $(whole_project_c_o)
  endif
 else # OPTION_WHOLE_PROJECT_C == 1
  PROJECT_OBJECTS += \
	$(foreach cfile,\
	  $(PROJECT_SOURCES_C),\
	  $(call link_object_c,$(cfile)))
 endif # else OPTION_WHOLE_PROJECT_C == 1

endif # else OPTION_WHOLE_PROJECT != 1

PROJECT_DEPMODULES ?= $(PROJECT_LINKMODULES)

# In the link stage, we'll assume that all generated object files are up to
# date.  The rule below pevents 'make' from checking all object file time
# stamps against the corresponding source files.
$(PROJECT_OBJECTS):
	$(SILENT) :

# Handle $(PROJECT_OBJECTS_ADD) after defining the dummy rule, see comment
# above.
ifdef PROJECT_OBJECTS_ADD
 PROJECT_OBJECTS += $(PROJECT_OBJECTS_ADD)
endif

.PHONY: _prepare
_prepare: $(PREPARE_DEPS)
	$(SILENT) mkdir -p "$(PROJECT_BUILD)"

# Set the compile and link flags.
include $(MAKE_ROOT)/Lib/setcflags.mk

PROJECT_DEPMODULES ?= $(PROJECT_LINKMODULES)
PROJECT_OBJECTS_DEP := $(PROJECT_OBJECTS)

ifdef ARCH_LIBDEPS
 PROJECT_OBJECTS_DEP += $(ARCH_LIBDEPS)
endif

ifeq ($(PROJECT_TYPE),module)

 ifdef ARCH_LIBDEPS_module
  PROJECT_OBJECTS_DEP += $(ARCH_LIBDEPS_module)
 endif

 # Module may have link dependencies on some architecures.  Module link
 # dependencies are handled in architecure specific clauses below.

 ifeq ($(ARCH),PS3-cell)
  ifeq ($(OPTION_PS3_PRX),1)
   # Handle linker objects for PS3 PRX builds.  We'll add the stub libraries
   # to the objects if and only if the current module is a PRX and the
   # to-be-linked module was compiled as a PRX.
   ifeq ($(OPTION_PS3_PRX_$(TARGET)),1)
    define module_add_module
     ifeq ($$(OPTION_PS3_PRX_$(2)),1)
      $(1) += $(BUILD_ROOT)/Bin/$(call LINK_STUBLIB_NAME,$(2))
     endif
    endef
    $(foreach module,\
	$(PROJECT_LINKMODULES),\
	$(eval $(call module_add_module,PROJECT_OBJECTS,$(module))))
    $(foreach module,\
	$(PROJECT_DEPMODULES),\
	$(eval $(call module_add_module,PROJECT_OBJECTS_DEP,$(module))))
   endif # OPTION_PS3_PRX_$(TARGET) == 1
  endif # OPTION_PS3_PRX == 1
 endif # ARCH == PS3-cell

 ifneq ($(LINK_MODULE),)
  PROJECT_OUTPUT := $(BUILD_ROOT)/Bin/$(call LINK_MODULE_NAME,$(TARGET))

  # If there is only a single output file to link and $(OPTION_SKIPLINK) is
  # set, then the output file will be copied/symlinked instead of linking.
  project_output_skiplink := 0
  ifeq ($(OPTION_SKIPLINK),1)
   ifeq ($(words $(PROJECT_OBJECTS)),1)
    project_output_skiplink := 1
    ifeq ($(HOST_SYSTEM),Linux)
     skiplink := ln -s
    else
     skiplink := cp
    endif
    ifeq ($(MKOPTION_VERBOSE),1)
     skiplink += -v
    endif
   endif
  endif

# Output rule.
$(PROJECT_OUTPUT): $(PROJECT_OBJECTS_DEP)
	$(SILENT) mkdir -p "$(BUILD_ROOT)/Bin"
ifneq ($(MKOPTION_COMPACT),1)	
	$(BUILD_ECHO) $(tag_link) $(call LINK_MODULE_NAME,$(TARGET))
else
	$(BUILD_ECHO) $(tag_link) $(TARGET)
endif
	$(BUILD_SILENT) $(RM) $@
ifeq ($(project_output_skiplink),1)
	$(BUILD_ECHO) $(tag_link) $(TARGET)
	$(SILENT) $(skiplink) $(PROJECT_OBJECTS) $@
else
	$(call BUILD_MAKE_LDFILES,$(PROJECT_OBJECTS),$@)
	$(BUILD_LINK) \
	  $(call LINK_MODULE,$@,\
	    $(call BUILD_LDFILES,$(PROJECT_OBJECTS),$@))
endif
	$(call BUILD_RM_LDFILES,$@)
# End of output rule.

  LINK_CLEAN_$(TARGET) += \
	$(PROJECT_OUTPUT) $(PROJECT_OUTPUT).$(LDFILES_SUFFIX)

 else # else if LINK_MODULE == ''

  PROJECT_OUTPUT := $(BUILD_ROOT)/Bin/$(TARGET).linked
# Output rule.
$(PROJECT_OUTPUT):
	$(SILENT) mkdir -p "$(BUILD_ROOT)/Bin"
	$(SILENT) echo linked >'$@'
# End of output rule.

  LINK_CLEAN_$(TARGET) += \
	$(PROJECT_OUTPUT) $(PROJECT_OUTPUT).$(LDFILES_SUFFIX)

 endif # skip_link != 1
endif # PROJECT_TYPE == module

ifeq ($(PROJECT_TYPE),program)
 ifneq ($(LINK_PROGRAM),)

  project_linkmodules_objects :=
  project_depmodules_objects :=
  ifneq ($(LINK_MODULE),)
   project_linkmodules_objects += \
	$(foreach module,\
	  $(PROJECT_LINKMODULES),\
	  $(BUILD_ROOT)/Bin/$(call LINK_MODULE_NAME,$(module)))
   project_depmodules_objects += \
	$(foreach module,\
	  $(PROJECT_DEPMODULES),\
	  $(BUILD_ROOT)/Bin/$(call LINK_MODULE_NAME,$(module)))
  endif # LINK_MODULE != ''

  ifdef ARCH_LIBDEPS_program
   PROJECT_OBJECTS_DEP += $(ARCH_LIBDEPS_program)
  endif

  ifeq ($(ARCH),PS3-cell)
   ifeq ($(OPTION_PS3_PRX),1)
    # On PS3, a mixed module setup is possible, i.e. some modules may be
    # shared and some may be static.  For the shared modules, the PRX stub
    # library resulting from the compile pass is linked.  PRX stub libraries
    # _must_ be linked _after_ all static objects to resolve link order
    # dependencies.
    project_linkmodules_objects_prxstub :=
    project_linkmodules_objects_static :=
    project_depmodules_objects_prxstub :=
    project_depmodules_objects_static :=
    define program_add_linkmodule
     ifeq ($$(OPTION_PS3_PRX_$(1)),1)
      project_linkmodules_objects_prxstub += \
	$(BUILD_ROOT)/Bin/$$(call LINK_STUBLIB_NAME,$(1))
     else
      project_linkmodules_objects_static += \
	$(BUILD_ROOT)/Bin/$$(call LINK_MODULE_NAME_static,$(1))
     endif
    endef
    define program_add_depmodule
     ifeq ($$(OPTION_PS3_PRX_$(1)),1)
      project_depmodules_objects_prxstub += \
	$(BUILD_ROOT)/Bin/$$(call LINK_STUBLIB_NAME,$(1))
     else
      # If it is not a PRX, then it must be added to dep list _and_ to the
      # link list.
      project_depmodules_objects_static += \
	$(BUILD_ROOT)/Bin/$$(call LINK_MODULE_NAME_static,$(1))
      project_linkmodules_objects_static += \
	$(BUILD_ROOT)/Bin/$$(call LINK_MODULE_NAME_static,$(1))
     endif
    endef
    $(foreach module,\
	$(PROJECT_LINKMODULES),\
	$(eval $(call program_add_linkmodule,$(module))))
    $(foreach module,\
	$(PROJECT_DEPMODULES),\
	$(eval $(call program_add_depmodule,$(module))))
    project_linkmodules_objects := \
	$(project_linkmodules_objects_static) \
	$(project_linkmodules_objects_prxstub)
    project_depmodules_objects := \
	$(project_depmodules_objects_static) \
	$(project_depmodules_objects_prxstub)
   endif # OPTION_PS3_PRX == 1
  endif # ARCH == PS3-cell

  PROJECT_OBJECTS += $(project_linkmodules_objects)
  PROJECT_OBJECTS_DEP += $(project_depmodules_objects)

  PROJECT_OUTPUT := $(BUILD_ROOT)/Bin/$(call LINK_PROGRAM_NAME,$(TARGET))

# Output rule.
$(PROJECT_OUTPUT): $(PROJECT_OBJECTS_DEP)
	$(SILENT) mkdir -p "$(BUILD_ROOT)/Bin"
ifneq ($(MKOPTION_COMPACT),1)		
	$(BUILD_ECHO) $(tag_link) $(call LINK_PROGRAM_NAME,$(TARGET))
else	
	$(BUILD_ECHO) $(tag_link) $(TARGET)
endif	
	$(BUILD_SILENT) $(RM) $@
	$(call BUILD_MAKE_LDFILES,$(PROJECT_OBJECTS),$@)
	$(BUILD_LINK) \
	  $(call LINK_PROGRAM,$@,\
	    $(call BUILD_LDFILES,$(PROJECT_OBJECTS),$@))
	$(call BUILD_RM_LDFILES,$@)
# End of output rule.

  LINK_CLEAN_$(TARGET) += \
	$(PROJECT_OUTPUT) $(PROJECT_OUTPUT).$(LDFILES_SUFFIX)

 endif # LINK_PROGRAM != ''
endif # PROJECT_TYPE == program

.PHONY: __command_link
__command_link: $(PROJECT_OUTPUT)
	$(SILENT) :

.PHONY: _command_default
_command_default: __command_link
ifdef PROJECT_POSTLINK
	+$(PROJECT_POSTLINK)
else
	$(SILENT) :
endif # PROJECT_POSTLINK

.PHONY: _command_post
_command_post:
ifdef PROJECT_POSTLINK
	+$(PROJECT_POSTLINK)
else
	$(SILENT) :
endif # PROJECT_POSTLINK

.PHONY: _command_clean
_command_clean:
	$(BUILD_SILENT) $(RM) $(LINK_CLEAN_$(TARGET))

# Stage/compile.mk
# vim:ts=8:sw=2

