/*   SCE CONFIDENTIAL                                       */
/*   PLAYSTATION(R)3 Programmer Tool Runtime Library 154.001 */
/*   Copyright (C) 2006 Sony Computer Entertainment Inc.    */
/*   All Rights Reserved.                                   */

#if CELL_GCM_MEASURE
# define CELL_GCM_RESERVE(count) do { CELL_GCM_CURRENT += (count); } while(false)
# define CELL_GCM_RESERVE_RET(count, value) do { CELL_GCM_CURRENT += (count); } while(false)
#else
# if CELL_GCM_UNSAFE
#  define CELL_GCM_RESERVE(count) do { } while(false)
#  define CELL_GCM_RESERVE_RET(count, value) do { } while(false)
# else
#  define CELL_GCM_RESERVE(count) do { \
	    if(CELL_GCM_CURRENT + (count) > CELL_GCM_END) \
		{ \
			if((*CELL_GCM_CALLBACK)(CELL_GCM_THIS, (count)) != CELL_OK) \
				return; \
		} \
		} while(false)

#  define CELL_GCM_RESERVE_RET(count, value) do { \
	    if(CELL_GCM_CURRENT + (count) > CELL_GCM_END) \
		{ \
			if((*CELL_GCM_CALLBACK)(CELL_GCM_THIS, (count)) != CELL_OK) \
				return (value); \
		} \
		} while(false)
# endif
#endif

#if CELL_GCM_INLINE
# ifdef _cplusplus
#  define CELL_GCM_DECL inline __attribute__((always_inline))
# else
#  define CELL_GCM_DECL extern inline 
# endif  
#else
# define CELL_GCM_DECL
#endif

#if (CELL_GCM_MODE==CELL_GCM_CPP)
# define CELL_GCM_FUNC(a) CellGcmContext:: a
# define CELL_GCM_NO_ARGS()
# define CELL_GCM_ARGS(...) __VA_ARGS__
# define CELL_GCM_ARGS_FUNC(...) __VA_ARGS__
# define CELL_GCM_NO_ARGS_FUNC() 
#else
# define CELL_GCM_NO_ARGS() struct CellGcmContextData *CELL_GCM_THIS
# define CELL_GCM_ARGS(...) struct CellGcmContextData *CELL_GCM_THIS, __VA_ARGS__
# define CELL_GCM_ARGS_FUNC(...) CELL_GCM_THIS, __VA_ARGS__
# define CELL_GCM_NO_ARGS_FUNC() CELL_GCM_THIS
# if CELL_GCM_INLINE
#  if CELL_GCM_UNSAFE
#   define CELL_GCM_FUNC(a) cellGcm ## a ## UnsafeInline
#  else
#   define CELL_GCM_FUNC(a) cellGcm ## a ## Inline
#  endif
# else
#  if CELL_GCM_UNSAFE
#   define CELL_GCM_FUNC(a) cellGcm ## a ## Unsafe
#  else
#   define CELL_GCM_FUNC(a) cellGcm ## a
#  endif
# endif
#endif

#include <cell/gcm/gcm_implementation_sub.h>

#ifndef __SPU__
#include <cell/gcm/gcm_implementation_ppu.h>
#endif


#undef CELL_GCM_RESERVE
#undef CELL_GCM_RESERVE_RET
#undef CELL_GCM_DECL
#undef CELL_GCM_FUNC
#undef CELL_GCM_NO_ARGS
#undef CELL_GCM_ARGS
#undef CELL_GCM_ARGS_FUNC
#undef CELL_GCM_NO_ARGS_FUNC
