/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 154.001
 * Copyright (C) 2006 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef __CELL_SPURS_EVENT_FLAG_H__
#define __CELL_SPURS_EVENT_FLAG_H__ 1

/* The C Standard Library */
#include <stdint.h>

/* SPURS */
#include <cell/spurs/event_flag_types.h>
#include <cell/spurs/error.h>

static int cellSpursEventFlagInitializeIWL(uint64_t ea, CellSpursEventFlagClearMode clearMode, CellSpursEventFlagDirection direction);
static int cellSpursEventFlagInitialize(uint64_t ea, CellSpursEventFlagClearMode clearMode, CellSpursEventFlagDirection direction);

#ifdef __cplusplus
extern "C" {
#endif

int _cellSpursEventFlagInitialize(uint64_t ea, CellSpursEventFlagClearMode clearMode, CellSpursEventFlagDirection direction, int isIWL);
int cellSpursEventFlagSet(uint64_t ea, uint16_t bits);
int cellSpursEventFlagClear(uint64_t ea, uint16_t bits);
int cellSpursEventFlagWait(uint64_t ea, uint16_t* bits, CellSpursEventFlagWaitMode mode);
int cellSpursEventFlagTryWait(uint64_t ea, uint16_t* bits, CellSpursEventFlagWaitMode mode);
int cellSpursEventFlagGetDirection(uint64_t ea, CellSpursEventFlagDirection* direction);
int cellSpursEventFlagGetClearMode(uint64_t ea, CellSpursEventFlagClearMode* clear_mode);
int cellSpursEventFlagGetTasksetAddress(uint64_t ea, uint64_t* pEaTaskset);

#ifdef __cplusplus
} /* extern "C" */
#endif

static inline int cellSpursEventFlagInitializeIWL(uint64_t ea, CellSpursEventFlagClearMode clearMode, CellSpursEventFlagDirection direction)
{
	return _cellSpursEventFlagInitialize(ea, clearMode, direction, 1);
}
static inline int cellSpursEventFlagInitialize(uint64_t ea, CellSpursEventFlagClearMode clearMode, CellSpursEventFlagDirection direction)
{
	return _cellSpursEventFlagInitialize(ea, clearMode, direction, 0);
}

#endif /* __CELL_SPURS_EVENT_FLAG_H__ */

/*
 * Local Variables:
 * mode: C
 * c-file-style: "stroustrup"
 * tab-width: 4
 * End:
 * vim:sw=4:sts=4:ts=4
 */
