/* SCE CONFIDENTIAL
   PLAYSTATION(R)3 Programmer Tool Runtime Library 154.001
   * Copyright (C) 2006 Sony Computer Entertainment Inc.
   * All Rights Reserved.
   */

#ifndef __CELL_SPURS_JOB_CONTEXT_H__
#define __CELL_SPURS_JOB_CONTEXT_H__

#include <stdint.h>

#include <cell/spurs/job_descriptor.h>

#ifdef __cplusplus
extern "C" {
#endif

	typedef struct CellSpursJobContext
	{
		/// input/cache input data pointers
		void *ioBufferList[26];

		/// number of io buffers
		uint16_t numIoBuffer;

		/// number of cache input buffers
		uint16_t numCacheBuffer;

		/// Output buffer
		void* oBuffer;

		/// Scratch buffer
		void* sBuffer;
  
		/// DMA tag for this job's I/O dmas. This will be one of: {20,21}.
		/// This value identifies a single job.
		unsigned int dmaTag;

		/// Job descriptor Effective Address
		uint64_t eaJobDescriptor;

	} CellSpursJobContext;


#ifdef __cplusplus
}
#endif


#endif /* __CELL_SPURS_JOB_CONTEXT_H__ */

/*
 * Local Variables:
 * mode: C
 * c-file-style: "stroustrup"
 * tab-width: 4
 * End:
 * vim:sw=4:sts=4:ts=4
 */
