#include "StdAfx.h"
#include "ExportStub.h"
#include "../CGF/PathUtil.h"
#include "ResourceCompilerHelper.h"

class ExportStubClassDesc : public ClassDesc2 
{
public:
	int 			IsPublic()					{ return 1; }
	void *			Create( BOOL loading )		{ return new ExportStubGUP(); } 
	const TCHAR *	ClassName()					{ return _T("CryENGINE 2 Library"); }
	SClass_ID		SuperClassID()				{ return GUP_CLASS_ID; }
	Class_ID 		ClassID()					{ return EXPORT_STUB_CLASS_ID; }
	const TCHAR* 	Category()					{ return _T("Global Utility Plug-In");  }

	// Hardwired name, used by MAX Script as unique identifier
	const TCHAR*	InternalName()				{ return _T("cryengine2"); }
	HINSTANCE		HInstance()					{ return hInstance; }
};

static ExportStubClassDesc exportStubClassDesc;

ClassDesc* GetExportStubDesc()
{
	return &exportStubClassDesc;
}
ExportStubGUP::ExportStubGUP()
{
}

ExportStubGUP::~ExportStubGUP()
{
}

DWORD ExportStubGUP::Start()
{
	CResourceCompilerHelper rcHelper;

	for (int attempt = 1; ; ++attempt)
	{
		std::string buildPath = rcHelper.GetRootPath(true);

#if !defined WIN64
#	define EXPORT_LIBRARY_BIT_EXTENSION ""
#else //!defined WIN64
#	define EXPORT_LIBRARY_BIT_EXTENSION "_64"
#endif //!defined WIN64

		char buffer[1024];
		sprintf(buffer, "Tools\\MaxExportLibrary%d%s.dll", MAX_PRODUCT_VERSION_MAJOR, EXPORT_LIBRARY_BIT_EXTENSION);
		std::string libraryPath = PathUtil::Make(buildPath, buffer);

		m_exportLibrary = LoadLibrary(libraryPath.c_str());

		if (m_exportLibrary || attempt >= 2)
			break;

		rcHelper.ResourceCompilerUI(GetCOREInterface()->GetMAXHWnd());
	}

	if (m_exportLibrary)
	{
		typedef void (* InitializeFn)(ClassDesc* parentClass);
		InitializeFn initialize = (InitializeFn)GetProcAddress(m_exportLibrary, "Initialize");
		if (initialize)
			initialize(&exportStubClassDesc);
	}

	return GUPRESULT_KEEP;
}

void ExportStubGUP::Stop()
{
	if (m_exportLibrary)
	{
		typedef void (* FinalizeFn)();
		FinalizeFn finalize = (FinalizeFn)GetProcAddress(m_exportLibrary, "Finalize");
		if (finalize)
			finalize();
		
		FreeLibrary(m_exportLibrary);
	}

	m_exportLibrary = 0;
}

DWORD_PTR ExportStubGUP::Control(DWORD parameter)
{
	return 0;
}

void ExportStubGUP::DeleteThis()
{
	delete this;
}
