// Utilities for Maya<->CryEngine conversion

#ifndef _MAYA_CRY_EXPORT_MAYA_CRY_UTILS_HDR_
#define _MAYA_CRY_EXPORT_MAYA_CRY_UTILS_HDR_

// converts the time from Maya units to native CryAnimation CAF file units (3DSMAX ticks)
extern int MayaToCryTime (const MTime& time);

// converts the color from MColor to CryIRGB
extern CryIRGB MayaToCryIRGB (const MColor& rgbMayaColor);

// converts the time from Maya units to native CryAnimation CAF file units (3DSMAX ticks)
// this is for unitless time
extern int MayaToCryTime (double fTime);

// converts the Cry time to Maya time
extern MTime CryToMayaTime (int nTick);

// Converts the translation/rotation into CryBoneKey structure
extern CryBoneKey ToCryBoneKey (int time, MVector& vmTranslation, MQuaternion& qmRotation);

// converts rotation order in the format of the transformation matrix class
// into the rotation order in the format of the euler rotation class
extern MEulerRotation::RotationOrder ToEulOrd (MTransformationMatrix::RotationOrder nRotOrd);

extern Vec3& assign (Vec3& left, MFloatVector& right);
extern Vec3& assign (Vec3& left, MPoint& right);
extern Vec3& assign (Vec3& left, MVector& right);

extern void FixupPath (std::string& strTexPath);
extern bool GetRelativePath(char* szBuffer, int nBufSize, const char* szFullPath );
#endif