// Base class for Cry file translator plugins.
// Parses options, identifies the file
#include "StdAfx.h"
#include "CryHeaders.h"
#include "TranslatorCryFile.h"

CTranslatorCryFile::CTranslatorCryFile(void):
	m_nNumLinksPerVertexOption (10000),
	m_nExportWeightsOption (1),
	m_bEnableManualRange(false)
{
}

CTranslatorCryFile::~CTranslatorCryFile(void)
{
}

// converts the string of options got from the Exporter interface to the string of options
// passed to the Exporter command
MString CTranslatorCryFile::convertOptionsToFlags (const MString& strOptions)
{
	MString strResult;
	MStringArray arrOptions;
	strOptions.split (';', arrOptions);

	for (unsigned nOption = 0; nOption < arrOptions.length(); ++nOption)
	{
		// parsed option
		MStringArray arrTokens;
		arrOptions[nOption].split('=',arrTokens);
		if (arrTokens.length() >= 2)
		{
			MString strOption = convertOptionToFlag (arrTokens[0], arrTokens[1]);
			if (strOption.length() > 0)
			{
				if (strResult.length() > 0)
					strResult += " ";
				strResult += strOptions;
			}
		}
	}

	// interpret multiple options (the options that may influence each other)

	// interpret the checkbox "Export Weights" with the radiobutton  of the number of weights
	if (m_nExportWeightsOption == 0)
		strResult += " -maxWeightsPerLink 0";
	else
	{
		char szOption[100];
		sprintf (szOption, " -maxWeightsPerLink %u", m_nNumLinksPerVertexOption);
		strResult += szOption;
	}

	// interpret the manual range start and end options
	if (m_bEnableManualRange)
	{
		strResult += " -manualRangeStart " + m_strManualRangeStart;
		strResult += " -manualRangeEnd " + m_strManualRangeEnd;
	}

	return strResult;
}


// converts the given option with the value into a flag with the value (or "" if not recognized)
MString CTranslatorCryFile::convertOptionToFlag (const MString& strOption, const MString& strValue)
{
	if (strOption == "dontConvertCS")
	{
		if (strValue.asInt() != 0)
			return "-dontConvertCS";
		else
			return "";
	}
	else
	if (strOption == "exportAsBuilding")
	{
		return ""; // this flag i snot used
	}
	else
	if (strOption == "exportVertexColors")
	{
		if (strValue.asInt() != 0)
			return "-vertexColors";
		else
			return "";
	}
	else
	if (strOption == "ignoreDummies")
	{
		if (strValue.asInt() != 0)
			return "-ignoreDummies";
		else
			return "";
	}
	else
	if (strOption == "weightsPerLinkRadio")
	{
		m_nNumLinksPerVertexOption = strValue.asInt();
		return ""; // will be interpreted later
	}
	else
	if (strOption == "exportWeights")
	{
		m_nExportWeightsOption = strValue.asInt();
	}
	else
	if (strOption == "allowMultiUVPerVertex")
	{
		if (strValue.asInt() == 0)
			return "-dontAllowMultiUV";
		else
			return "";
	}
	else
	if (strOption == "exportMaterials")
	{
		if (strValue.asInt() == 0)
			return "-ignoreMaterials";
		else
			return "";
	}
	else
	if (strOption == "animationSampleStep")
	{
		return "-animationStep " + strValue;
	}
	else
	if (strOption == "enableKeyOptimization")
	{
		if (strValue.asInt() == 0)
			return "-disableKeyOptimization";
	}
	else
	if (strOption == "rotationPrecision")
	{
		return "-rotationPrecision " + strValue;
	}
	else
	if (strOption == "positionPrecision")
	{
		return "-positionPrecision " + strValue;
	}
	else
	if (strOption == "enableManualRange")
	{
		m_bEnableManualRange = (strValue.asInt() != 0);
	}
	else
	if (strOption == "manualRangeStart")
	{
		m_strManualRangeStart = strValue;
	}
	else
	if (strOption == "manualRangeEnd")
	{
		m_strManualRangeEnd = strValue;
	}

	return "";
}


// optional feature of Maya translator: identifies if the file is likely to be the correct format
MPxFileTranslator::MFileKind CTranslatorCryFile::identifyFile (
	const MFileObject& fileName,
	const char* buffer,
	short size) const
{
	if (!strncmp (buffer,"CryTek", size))
		return kNotMyFileType;
	if (size >= 11)
	{
		//const FILE_HEADER* pHeader = (const FILE_HEADER*)buffer;
		const int *pFileType = reinterpret_cast<const int*>(buffer+7);
		if (*pFileType != getMyFileType())
			return kNotMyFileType;

		if (size >= 15 && pFileType[1] != getMyFileVersion())
			return kNotMyFileType;
		return kIsMyFileType;
	}
	else
	{
		// can't say anything definite
		return kCouldBeMyFileType;
	}
}
